<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;
use backend\models\Calificacioncalificaciones;
use backend\models\Promedio;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte707Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo-periodo']);

            $model->reporte = Yii::t('app', 'R707-Reporte');
            $model->observaciones = Yii::t('app', 'R707-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $periodo = Yii::$app->request->get('periodo');
            $size_font = 7;
            $ver_colores = 1;
            $size_font = 7;
            $alto = 3;
            
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $grupo = Grupo::find()->where(['id' => $grupo])->one();

        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R707-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
        
        $sede = Sede::FindOne($grupo->sede);

        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 32,
                         'margin_bottom' => 16,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => 'L']);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);
    
        if($ver_fecha == 1)
        {
            $fecha = strftime("%A, %d de %B de %Y");
            $pdf->setX(200);
            $pdf->SetFont('helvetica','',$size_font);
            $pdf->Cell(60,$alto + 2,$fecha,0,0,'R');
            $pdf->Ln($alto + 2);    
        }    
        
        $pdf->SetFont('Helvetica','B',$size_font + 2);   
        $pdf->Cell(250,$alto + 2,Yii::t('app', 'R707-SABANA DE NOTAS CON NIVELACION'),0,0,'C',0);

        $pdf->Ln($alto + 2);        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Sede'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(55,$alto + 2,$grupo->sedes->sede,0,0);

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Jornada'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(20,$alto + 2,$grupo->jornadas->jornada,0,0);  

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(12,$alto + 2,Yii::t('app', 'Grupo'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(25,$alto + 2,$grupo->grupo,0,0);
        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(10,$alto + 2,Yii::t('app', 'Año'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(8,$alto + 2,date('Y'),0,0);

        $pdf->Ln($alto + 2);
        $pdf->setFillColor(230);
        $pdf->SetFont('Helvetica','B',$size_font - 2);

        $pdf->Cell(5,10,Yii::t('app', '#'),1,0,'J',1);
        $pdf->Cell(50,10,mb_strtoupper(Yii::t('app', 'Estudiante')),1,0,'C',1);

        $asignaturas = Asignatura::find()->where(['grado' => $grupo->grados->id])->all();
            
        foreach ($asignaturas as $asignatura) 
        {
            $pdf->SetFont('Helvetica','B',$size_font - 2);
            $pdf->Cell(10,5,mb_strtoupper(substr($asignatura->codigo,0,5)),1,0,'C',1); 
        }
        
        if ($sede->tipo_calificacion != '1')
        {
            $pdf->Cell(8,10,mb_strtoupper(Yii::t('app', 'PROM')),1,0,'C',1);
            $pdf->Cell(8,10,mb_strtoupper(Yii::t('app', 'PUESTO')),1,0,'C',1); 
        }

        $pdf->Cell(8,10,mb_strtoupper(Yii::t('app', 'G')),1,0,'C',1); 
        $pdf->Cell(8,10,mb_strtoupper(Yii::t('app', 'P')),1,0,'C',1);

        $pdf->Ln(5);
        $pdf->Cell(55,0,'',0,0,'C',0); 

        foreach ($asignaturas as $asignatura) 
        {
            $pdf->SetFont('Helvetica','B',$size_font - 2);
            $pdf->Cell(5,5,mb_strtoupper(Yii::t('app', 'Not')),1,0,'C',1); 
            $pdf->Cell(5,5,mb_strtoupper(Yii::t('app', 'Niv')),1,0,'C',1); 
        }

        $pdf->Ln(5);
        
        $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
        
        $x=1;

        foreach ($estudiantes as $estudiante) 
        {
            $perdidas = 0;
            $ganadas = 0;

            $tipo_calificacion = $grupo->grados->tipo_calificacion;
            $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

            $pdf->setFillColor(255);
            $pdf->SetFont('Helvetica','',$size_font-2);  

            $nombre = mb_strtoupper($estudiante->estudiantes->nombreinverso);

            $pdf->Cell(5,$alto,$x,1,0,'J',0);
            $pdf->Cell(50,$alto,$nombre,1,0,'J',0);
            
            $x++;

            foreach ($asignaturas as $asignatura) 
            {
            
                $calificacion = Calificacion::find()
                        ->where(['estudiante' => $estudiante->id])
                        ->andWhere(['grupo' => $grupo->id])
                        ->andWhere(['asignatura' => $asignatura->id])
                        ->andWhere(['periodo' => $periodo])
                        ->one();

            //$pdf->Cell(10,$alto + 2,mb_strtoupper(Yii::t('app', 'Def')),'LBTR',0,'C',1);

                if(isset($calificacion))
                {


                    $desempeno = new Desempeno();
                      
                    
                    if($ver_letrasonumeros == 1) // LETRAS
                    {
                        

                        if($desempeno->perdido($calificacion->definitiva_final_periodo,$tipo_calificacion) == '1')
                        {
                            $perdidas = $perdidas + 1;
                        }    
                        else
                        {
                            $ganadas = $ganadas + 1;
                        } 

                        $color = $desempeno->hex2rgb($desempeno->color($calificacion->definitiva_periodo,$tipo_calificacion));
                    
                        if($ver_colores == 1)
                        {
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                        }  
                    
                        $desempenos = $desempeno->nota($calificacion->definitiva_periodo,$tipo_calificacion);
                        $pdf->Cell(5,$alto,$desempenos,'LBTR',0,'C',1);

                        $color = $desempeno->hex2rgb($desempeno->color($calificacion->nivelacion == NULL ? 0 : $calificacion->nivelacion,$tipo_calificacion));
                    
                        if($ver_colores == 1)
                        {
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                        }  

                        if ($calificacion->nivelacion != NULL)
                        {    
                            $desempenos = $desempeno->nota($calificacion->nivelacion,$tipo_calificacion);
                        }
                        else
                        {
                            $desempenos = '';
                        }

                        $pdf->Cell(5,$alto,$desempenos,'LBTR',0,'C',1);

                        //$desempenos = $desempeno->nota($calificacion->definitiva_final_periodo,$tipo_calificacion);
                        //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                    }
                    else // NUMEROS
                    { 
                        
                        if($desempeno->perdido($calificacion->definitiva_final_periodo,$tipo_calificacion) == '1')
                        {
                            $perdidas = $perdidas + 1;
                        }    
                        else
                        {
                            $ganadas = $ganadas + 1;
                        }

                        $color = $desempeno->hex2rgb($desempeno->color($calificacion->definitiva_periodo,$tipo_calificacion));
                    
                        if($ver_colores == 1)
                        {
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                        }  
                    
                        $pdf->Cell(5,$alto,$calificacion->definitiva_periodo,'LBTR',0,'C',1);
                        
                        $color = $desempeno->hex2rgb($desempeno->color($calificacion->nivelacion == NULL ? 0: $calificacion->nivelacion,$tipo_calificacion));
                    
                        if($ver_colores == 1)
                        {
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                        }

                        $pdf->Cell(5,$alto,$calificacion->nivelacion == NULL ? '': $calificacion->nivelacion,'LBTR',0,'C',1); 
                        //$desempenos = $desempeno->nota($calificacion->definitiva_final_periodo,$tipo_calificacion);
                        //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                    }    
                    
                    $pdf->setFillColor(255); 
                }
                else
                {
                    $desempeno = new Desempeno();
                    $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                    $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }    
                    
                    $pdf->Cell(5,$alto,'','LBTR',0,'C',1);
                    $pdf->Cell(5,$alto,'','LBTR',0,'C',1);
                    $pdf->setFillColor(255);

                    $perdidas = $perdidas + 1;
                }    
            }

            if ($sede->tipo_calificacion != '1')
            {
                $promedio = Promedio::find()
                            ->where(['estudiante' => $estudiante->id])
                            ->andWhere(['grupo' => $grupo->id])
                            ->andWhere(['periodo' => $periodo])
                            ->one();

                $desempeno = new Desempeno();
                $color = $desempeno->hex2rgb($desempeno->color((!isset($promedio) ? 0 : $promedio->promedio_estudiante), $tipo_calificacion));
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                }    
                
                if($ver_letrasonumeros == 1) // LETRAS
                {
                    $pdf->Cell(8,$alto,$desempenos = $desempeno->nota((!isset($promedio) ? 0 : $promedio->promedio_estudiante),$tipo_calificacion),1,0,'C',1);
                }
                else
                {
                    $pdf->Cell(8,$alto,(!isset($promedio) ? 0 : $promedio->promedio_estudiante),1,0,'C',1);
                }
                

                $pdf->setFillColor(255); 
                $pdf->Cell(8,$alto,(!isset($promedio) ? "" : $promedio->puesto_grupo),1,0,'C',0); 
            }
                $pdf->setFillColor(255);
                $pdf->Cell(8,$alto,$ganadas,1,0,'C',0); 
                $pdf->Cell(8,$alto,$perdidas,1,0,'C',0);
             
            
            $pdf->Ln($alto);
                
        }

        $pdf->Output("R707-Sabana-Notas-Grupo(".date("d-m-Y_H-i").").pdf",'D');
    }  

}
