<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Tercero;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Sede;
use backend\models\LanzadorForm;
use backend\models\Promedioarea;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte708Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo-periodo']);

            $model->reporte = Yii::t('app', 'R708-Reporte');
            $model->observaciones = Yii::t('app', 'R708-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $periodo = Yii::$app->request->get('periodo');
            $size_font = 7;
            $ver_colores = 1;
            $size_font = 7;
            $alto = 3;
            
        }

        if($periodo == '5')
        {
            list($condicionpromocion) = Yii::$app->createController('condicionpromocion');
            $condicionpromocion->actionComprobar($grupo);
        }           

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $grupo = Grupo::find()->where(['id' => $grupo])->one();

        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R708-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
        
        $sede = Sede::FindOne($grupo->sede);

        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 32,
                         'margin_bottom' => 16,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => 'L']);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);
    
        if($ver_fecha == 1)
        {
            $fecha = strftime("%A, %d de %B de %Y");
            $pdf->setX(200);
            $pdf->SetFont('helvetica','',$size_font);
            $pdf->Cell(60,$alto + 2,$fecha,0,0,'R');
            $pdf->Ln($alto + 2);    
        }    
        
        $pdf->SetFont('Helvetica','B',$size_font + 2);   
        $pdf->Cell(250,$alto + 2,Yii::t('app', 'R708-SABANA DE NOTAS DEL AREA Y GRUPO'),0,0,'C',0);

        $pdf->Ln($alto + 2);        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Sede'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(90,$alto + 2,$grupo->sedes->sede,0,0);

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Jornada'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(20,$alto + 2,$grupo->jornadas->jornada,0,0);  

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(12,$alto + 2,Yii::t('app', 'Grupo'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(25,$alto + 2,$grupo->grupo,0,0);


        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Periodo'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(25,$alto + 2,$periodo,0,0);
        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(10,$alto + 2,Yii::t('app', 'Año'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(8,$alto + 2,date('Y'),0,0);


        $pdf->Ln($alto + 2);
        $pdf->setFillColor(230);
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(7,$alto + 2,Yii::t('app', '#'),1,0,'J',1);
        $pdf->Cell(65,$alto + 2,mb_strtoupper(Yii::t('app', 'Estudiante')),1,0,'C',1);

        $asignaturas = Asignatura::find()
                        ->where(['grado' => $grupo->grados->id])
                        ->groupBy(['area'])
                        ->all();
            
        foreach ($asignaturas as $asignatura) 
        {
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(14,$alto + 2,mb_strtoupper(substr($asignatura->areas->codigo,0,20)),1,0,'C',1); 
        }

        //$pdf->Cell(8,$alto + 2,mb_strtoupper(Yii::t('app', 'PROM')),1,0,'C',1);
        //$pdf->Cell(8,$alto + 2,mb_strtoupper(Yii::t('app', 'PUESTO')),1,0,'C',1); 
        $pdf->Cell(10,$alto + 2,mb_strtoupper(Yii::t('app', 'G')),1,0,'C',1); 
        $pdf->Cell(10,$alto + 2,mb_strtoupper(Yii::t('app', 'P')),1,0,'C',1);
        
        if($periodo == '5')
        {
            $pdf->Cell(15,$alto + 2,mb_strtoupper(Yii::t('app', 'Aprobo')),1,0,'C',1);     
        }
        
        $pdf->Ln($alto + 2);
        
        $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
        
        $x=1;

        foreach ($estudiantes as $estudiante) 
        {
            if($periodo == '5')
            {
                $estado = ($estudiante->estudiantes->grupos->aprobo == 1) ? Yii::t('app', 'SI') : Yii::t('app', 'NO');
            }

            $perdidas = 0;
            $ganadas = 0;

            $tipo_calificacion = $grupo->grados->tipo_calificacion;
            $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

            $pdf->setFillColor(255);
            $pdf->SetFont('Helvetica','',$size_font);  

            $nombre = mb_strtoupper($estudiante->estudiantes->nombreinverso);

            $pdf->Cell(7,$alto,$x,1,0,'J',0);
            $pdf->Cell(65,$alto,$nombre,1,0,'J',0);
            
            $x++;
            foreach ($asignaturas as $asignatura) 
            {
            
                $calificacion = Promedioarea::find()
                        ->where(['estudiante' => $estudiante->id])
                        ->andWhere(['grupo' => $grupo->id])
                        ->andWhere(['area' => $asignatura->area])
                        ->andWhere(['periodo' => $periodo])
                        ->one();

            //$pdf->Cell(10,$alto + 2,mb_strtoupper(Yii::t('app', 'Def')),'LBTR',0,'C',1);

                if(isset($calificacion))
                {


                    $desempeno = new Desempeno();
                    
                    $color = $desempeno->hex2rgb($desempeno->color($calificacion->promedio_estudiante,$tipo_calificacion));
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }    
                    
                    if($desempeno->perdido($calificacion->promedio_estudiante,$tipo_calificacion) == '1')
                    {
                        $perdidas = $perdidas + 1;
                    }    
                    else
                    {
                        $ganadas = $ganadas + 1;
                    }
                       
                    
                    if($ver_letrasonumeros == 1) // LETRAS
                    {
                        $desempenos = $desempeno->nota($calificacion->promedio_estudiante,$tipo_calificacion);
                        $pdf->Cell(14,$alto,$desempenos,'LBTR',0,'C',1);
                        //$desempenos = $desempeno->nota($calificacion->promedio_estudiante,$tipo_calificacion);
                        //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                    }
                    else // NUMEROS
                    { 
                        $pdf->Cell(14,$alto,$calificacion->promedio_estudiante == 0 ? '': $calificacion->promedio_estudiante,'LBTR',0,'C',1); 
                        //$desempenos = $desempeno->nota($calificacion->promedio_estudiante,$tipo_calificacion);
                        //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                    }    
                    
                    $pdf->setFillColor(255); 
                }
                else
                {
                    $desempeno = new Desempeno();
                    $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                    $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }    
                    
                    $pdf->Cell(14,$alto,'','LBTR',0,'C',1);
                    $pdf->setFillColor(255);

                    $perdidas = $perdidas + 1;
                }    
            }
/*
            $promedio = Promedio::find()
                        ->where(['estudiante' => $estudiante->id])
                        ->andWhere(['grupo' => $grupo->id])
                        ->andWhere(['periodo' => $periodo])
                        ->one();

            $desempeno = new Desempeno();
            $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
            
            if($ver_colores == 1)
            {
                $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
            }    
            
            $pdf->Cell(8,$alto,$promedio->promedio_estudiante,1,0,'C',1);

            $pdf->setFillColor(255); 
            $pdf->Cell(8,$alto,$promedio->puesto_grupo,1,0,'C',0); 
*/
            $pdf->Cell(10,$alto,$ganadas,1,0,'C',0); 
            $pdf->Cell(10,$alto,$perdidas,1,0,'C',0); 
            
            if($periodo == '5')
            {
                $pdf->Cell(15,$alto,$estado,1,0,'C',0); 
            }
            
            $pdf->Ln($alto);
                
        }

        $pdf->Output("R708-Sabana-Notas-Area-Grupo(".date("d-m-Y_H-i").").pdf",'D');
    }  

}
