<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Tercero;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Sede;
use backend\models\Grado;
use backend\models\LanzadorForm;
use backend\models\Promedioarea;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte710Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grado-periodo']);

            $model->reporte = Yii::t('app', 'R710-Reporte');
            $model->observaciones = Yii::t('app', 'R710-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {
                $sede = $model->sede;
                $grado = $model->grado;
                $periodo = $model->periodo;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => false,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                            'multiple_grado' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => false,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                            'multiple_grado' => true,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $sede = Yii::$app->request->get('sede');
            $periodo = Yii::$app->request->get('periodo');
            $size_font = 7;
            $ver_colores = 1;
            $size_font = 7;
            $alto = 3;
            
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");
        
        $sede = Sede::FindOne($sede);

        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 32,
                         'margin_bottom' => 16,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => 'L']);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);
    
        if($ver_fecha == 1)
        {
            $fecha = strftime("%A, %d de %B de %Y");
            $pdf->setX(200);
            $pdf->SetFont('helvetica','',$size_font);
            $pdf->Cell(60,$alto + 2,$fecha,0,0,'R');
            $pdf->Ln($alto + 2);    
        }    
        
        $pdf->SetFont('Helvetica','B',$size_font + 2);   
        $pdf->Cell(250,$alto + 2,Yii::t('app', 'R710-SABANA DE NOTAS POR AREA Y GRUPO'),0,0,'C',0);

        $pdf->Ln($alto + 2);        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(10,$alto + 2,Yii::t('app', 'Grado'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        
        $gra = "";

        $total_grados = count($grado);
        $x = 1;

        foreach ($grado as $grado_id) {
            $grado_ = Grado::findOne($grado_id);
            $gra .= $grado_->grado;

            if($x < $total_grados)
            $gra .= ", ";    
            $x++;
        }
        
        $pdf->Cell(180,$alto + 2,$gra,0,0);

        $pdf->Ln($alto + 2);
        $pdf->setFillColor(230);
        $pdf->SetFont('Helvetica','B',$size_font - 2);
        $pdf->Cell(5,$alto + 2,Yii::t('app', '#'),1,0,'J',1);
        $pdf->Cell(50,$alto + 2,mb_strtoupper(Yii::t('app', 'Grupo')),1,0,'C',1);

        $asignaturas = Asignatura::find()
                        ->where(['IN', 'grado', $grado])
                        ->groupBy(['area'])
                        ->orderBy(['grado' => SORT_ASC, 'id' => SORT_ASC])
                        ->all();
            
        foreach ($asignaturas as $asignatura) 
        {
            $pdf->SetFont('Helvetica','B',$size_font - 2);
            $pdf->Cell(8,$alto + 2,mb_strtoupper(substr($asignatura->areas->codigo,0,20)),1,0,'C',1); 
        }

        $pdf->Cell(8,$alto + 2,mb_strtoupper(Yii::t('app', 'PGRUPO')),1,0,'C',1);
        $pdf->Cell(8,$alto + 2,mb_strtoupper(Yii::t('app', 'PGRADO')),1,0,'C',1); 
        $pdf->Cell(8,$alto + 2,mb_strtoupper(Yii::t('app', 'G')),1,0,'C',1); 
        $pdf->Cell(8,$alto + 2,mb_strtoupper(Yii::t('app', 'P')),1,0,'C',1); 
        
        $pdf->Ln($alto + 2);
        
        $grupos = Grupo::find()
                    ->where(['grado' => $grado])
                    ->orderBy(['grado' => SORT_ASC, 'grupo' => SORT_ASC])
                    ->all();  
        
        $x=1;


        foreach ($grupos as $grupo) 
        {
            $suma = 0;
            $perdidas = 0;
            $ganadas = 0;

            $tipo_calificacion = $grupo->grados->tipo_calificacion;
            $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

            $pdf->setFillColor(255);
            $pdf->SetFont('Helvetica','',$size_font-2);  

            $pdf->Cell(5,$alto,$x,1,0,'J',0);
            $pdf->Cell(50,$alto,mb_strtoupper($grupo->grupo),1,0,'J',0);
            
            $x++;
            foreach ($asignaturas as $asignatura) 
            {
            
                $calificacion = Promedioarea::find()
                        ->where(['grupo' => $grupo->id])
                        ->andWhere(['area' => $asignatura->area])
                        ->andWhere(['periodo' => $periodo])
                        ->limit(1)
                        ->one();

                if(isset($calificacion))
                {

                    $desempeno = new Desempeno();
                    
                    $color = $desempeno->hex2rgb($desempeno->color($calificacion->promedio_area_grupo,$tipo_calificacion));
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }    
                    
                    if($calificacion->promedio_area_grupo < 3)
                    {
                        $perdidas = $perdidas + 1;
                    }    
                    else
                    {
                        $ganadas = $ganadas + 1;
                    }   
                    
                    if($ver_letrasonumeros == 1) // LETRAS
                    {
                        $desempenos = $desempeno->nota($calificacion->promedio_area_grupo,$tipo_calificacion);
                        $pdf->Cell(8,$alto,$desempenos,'LBTR',0,'C',1);
                        //$desempenos = $desempeno->nota($calificacion->promedio_area_grupo,$tipo_calificacion);
                        //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                    }
                    else // NUMEROS
                    { 
                        $suma += $calificacion->promedio_area_grupo;

                        $pdf->Cell(8,$alto,$calificacion->promedio_area_grupo == 0 ? '': $calificacion->promedio_area_grupo,'LBTR',0,'C',1); 
                        //$desempenos = $desempeno->nota($calificacion->promedio_area_grupo,$tipo_calificacion);
                        //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                    }    
                    
                    $pdf->setFillColor(255); 
                }
                else
                {
                    $desempeno = new Desempeno();
                    $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                    $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }    
                    
                    $pdf->Cell(8,$alto,'','LBTR',0,'C',1);
                    $pdf->setFillColor(255);

                    $perdidas = $perdidas + 1;
                }    
            }

            $pdf->setFillColor(255);    

            $calificacion = Promedioarea::find()
                ->select(['promedio_grupo', 'promedio_grado'])
                ->where(['grupo' => $grupo->id])
                ->andWhere(['periodo' => $periodo])
                ->limit('1')
                ->one();

            //echo "<br>".$calificacion->createCommand()->getRawSql();
            /*
            $calificacion = Promedioarea::find()
                ->select(new \yii\db\Expression('ROUND(AVG(promedio_estudiante),1) AS promedio_estudiante, promedio_grupo'))
                ->where(['grupo' => $grupo->id])
                ->andWhere(['periodo' => $periodo])
                ->one();
            */
            if(isset($calificacion))
            {
                $desempeno = new Desempeno();
                $color = $desempeno->hex2rgb($desempeno->color($calificacion->promedio_grupo,$tipo_calificacion));
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                }

                $pdf->Cell(8,$alto,$calificacion->promedio_grupo,1,0,'C',1);

                $desempeno = new Desempeno();
                $color = $desempeno->hex2rgb($desempeno->color($calificacion->promedio_grado,$tipo_calificacion));
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                }
                
                $pdf->Cell(8,$alto,$calificacion->promedio_grado,1,0,'C',1);
                
            }
            else
            {

                $desempeno = new Desempeno();
                $color = $desempeno->hex2rgb($desempeno->color('0',$tipo_calificacion));
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                }
                
                $pdf->Cell(8,$alto,'',1,0,'C',1);
                $pdf->Cell(8,$alto,'',1,0,'C',1);
            }  

            $pdf->Cell(8,$alto,$ganadas,1,0,'C',0); 
            $pdf->Cell(8,$alto,$perdidas,1,0,'C',0); 
            
            $pdf->Ln($alto);
                
        }

        $pdf->setFillColor(255);
        $pdf->SetFont('Helvetica','',$size_font-2);
        $pdf->Cell(190,$alto,Yii::t('app', 'PGRUPO - Promedio Grupo, PGRADO - Promedio Grado, P - Perdidas, G - Ganadas.'),0,0,'L',0); 


        $pdf->Output("R710-Sabana-Notas-Area-Grupo(".date("d-m-Y_H-i").").pdf",'D');
    }  

}
