<?php

namespace backend\controllers;


use Yii;
use yii\web\Controller;
use yii\web\Response;
use yii\widgets\ActiveForm;

use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;
use backend\models\Calificacioncalificaciones;


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Helper\Sample;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;


class Reporte714Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo-periodo']);

            $model->reporte = Yii::t('app', 'R714-Reporte');
            $model->observaciones = Yii::t('app', 'R714-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $sede = $model->sede;
                $tercero = $model->tercero;
                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                //$ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador_docente', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'multiple_grado' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'rango_fechas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                            'ver_parametros' => false,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador_docente', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'multiple_grado' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                            'ver_parametros' => false,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $tercero = Yii::$app->request->get('tercero');
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $periodo = Yii::$app->request->get('periodo');
            $size_font = 7;
            $ver_colores = 1;
            $size_font = 10;
            $alto = 3;
            
        }
/*
        echo "<br>T:".$tercero;
        echo "<br>G:".$grado;
        echo "<br>Gr".$grupo;
        echo "<br>P".$periodo;
        echo "<br>F".$size_font;
        echo "<br>C".$ver_colores;
        echo "<br>S".$size_font;
        echo "<br>A".$alto;
*/
        $periodo = Periodo::FindOne($periodo);

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $grupo = Grupo::find()->where(['id' => $grupo])->one();
        
        $sede = Sede::FindOne($sede);

        $tercero = Tercero::FindOne($tercero);

        //echo '<br>grupo'.$grupo->id;
        //echo '<br>docente'.$tercero->id;

        $carga = Carga::find()->select(['asignatura'])->where(['grupo' => $grupo->id])->andWhere(['docente' => $tercero->id])->andWhere(['eliminado_por' => '0']);

        $asignaturas = Asignatura::find()->where(['grado' => $grado])->andWhere(['id' => $carga])->all();

        //echo $asignaturas->createCommand()->getRawSql();

        /// MARGENES HOJA
        $top = '1';
        $right = '0.1';
        $left = '0.1';
        $bottom = '1';

        $Excel = new Spreadsheet();

        $Excel->getProperties()
        ->setCreator("Sonic")
        ->setLastModifiedBy("Sonic")
        ->setTitle("Reporte 714 - Estudiantes por Asignatura y Grupo")
        ->setDescription("Documento generado por Sonic")
        ->setCategory("Listados"); 



        $this->render('/reporte/_headerandfooter_excel_landscape', ['Excel' => $Excel]);    

        $Excel->setActiveSheetIndex(0);

        $Excel->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_LANDSCAPE);
        $Excel->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_FOLIO);
        $Excel->getActiveSheet()->getPageSetup()->setHorizontalCentered(false);
        $Excel->getActiveSheet()->getPageMargins()->setTop($top);
        $Excel->getActiveSheet()->getPageMargins()->setRight($right);
        $Excel->getActiveSheet()->getPageMargins()->setLeft($left);
        $Excel->getActiveSheet()->getPageMargins()->setBottom($bottom);
        
        $Excel->getActiveSheet()->setTitle('Planilla Auxiliar');
        $Excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(4);
        $Excel->getDefaultStyle()->getFont()->setName('Calibri')->setSize($size_font);


        $Excel->getActiveSheet()->setCellValue('A1', Yii::t('app', 'Docente'));
        $Excel->getActiveSheet()->mergeCells('A1:C1');
        $Excel->getActiveSheet()->getStyle('A1:C1')->getFont()->setBold(true);

        $Excel->getActiveSheet()->setCellValue('D1', $tercero->nombre);
        $Excel->getActiveSheet()->mergeCells('D1:S1');

        $Excel->getActiveSheet()->setCellValue('A2', Yii::t('app', 'Grupo'));
        $Excel->getActiveSheet()->mergeCells('A2:C2');
        $Excel->getActiveSheet()->getStyle('A2:C2')->getFont()->setBold(true);

        $Excel->getActiveSheet()->setCellValue('D2', $grupo->grupo);
        $Excel->getActiveSheet()->mergeCells('D2:F2');

        $Excel->getActiveSheet()->setCellValue('G2', Yii::t('app', 'Jornada'));
        $Excel->getActiveSheet()->mergeCells('G2:J2');
        $Excel->getActiveSheet()->getStyle('G2:J2')->getFont()->setBold(true);

        $Excel->getActiveSheet()->setCellValue('K2', $grupo->jornadas->jornada);
        $Excel->getActiveSheet()->mergeCells('K2:M2');

        $Excel->getActiveSheet()->setCellValue('N2', Yii::t('app', 'Periodo'));
        $Excel->getActiveSheet()->mergeCells('N2:P2');
        $Excel->getActiveSheet()->getStyle('N2:P2')->getFont()->setBold(true);

        $Excel->getActiveSheet()->setCellValue('Q2', $periodo->periodo);
        $Excel->getActiveSheet()->mergeCells('Q2:S2');

        

        $Excel->getActiveSheet()->setCellValue('A4', "#");
        $Excel->getActiveSheet()->mergeCells('A4:A5');
        
        $Excel->getActiveSheet()->setCellValue('B4', "ESTUDIANTE");  
        $Excel->getActiveSheet()->mergeCells('B4:J5');
        
        $x = 'K';
        foreach ($asignaturas as $asignatura) 
        {
            $x_i = $x;
            $competencias = Competencia::find()
                            ->where(['asignatura' => $asignatura->id])
                            ->andWhere(['periodo' => $periodo])
                            ->andWhere(['grado' => $grado])
                            ->all();

            $Excel->getActiveSheet()->setCellValue($x.'4', mb_strtoupper(substr($asignatura->codigo,0,5)));  

            $c = 1;

            foreach ($competencias as $competencia) 
            {
                $Excel->getActiveSheet()->setCellValue($x.'5', $c);  
                
                if(count($competencias) == $c)
                {
                    $Excel->getActiveSheet()->mergeCells($x_i.'4:'.$x.'4');   
                }
                
                $c++;
                $x++;
            }
        }

        $Excel->getActiveSheet()->setCellValue($x.'4', "#");
        $Excel->getActiveSheet()->mergeCells($x.'4:'.$x.'5');




        $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
        
        $n = 1;
        $y = 6;
        
        
        foreach ($estudiantes as $estudiante) 
        {
            
            //$tipo_calificacion = $grupo->grados->tipo_calificacion;
            //$calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;


            $Excel->getActiveSheet()->setCellValue('A'.$y, $n);  
            $Excel->getActiveSheet()->setCellValue('B'.$y, mb_strtoupper($estudiante->estudiantes->nombreinverso)); 
            $Excel->getActiveSheet()->mergeCells('B'.$y.':J'.$y); 

            $x = 'K';
            foreach ($asignaturas as $asignatura) 
            {   
                $competencias = Competencia::find()
                            ->where(['asignatura' => $asignatura->id])
                            ->andWhere(['periodo' => $periodo])
                            ->andWhere(['grado' => $grado])
                            ->all();
                
                foreach ($competencias as $competencia) 
                {
                   $Excel->getActiveSheet()->setCellValue($x.''.$y, '');
                   //$Excel->getActiveSheet()->getColumnDimension($x.''.$y)->setWidth(4);
                   $x++;
                }
            }
            
            $Excel->getActiveSheet()->setCellValue($x.''.$y, $n);
            
            $y = $y + 1;
            $n++;
                
        }

        //$Excel->getActiveSheet()->getColumnDimension('A')->setWidth(4);
        $Excel->getActiveSheet()->getStyle('A4:'.$Excel->getActiveSheet()->getHighestColumn().''.$Excel->getActiveSheet()->getHighestRow())->getFont()->setBold(true);
        //$Excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        //$Excel->getActiveSheet()->getColumnDimension('B')->setWidth(40);

        //$Excel->getActiveSheet()->getColumnDimension($Excel->getActiveSheet()->getHighestColumn())->setAutoSize(true);
        //$Excel->getActiveSheet()->getColumnDimension($Excel->getActiveSheet()->getHighestColumn())->setWidth(4);

        $Excel->getActiveSheet()->getStyle('A4:' . 
        $Excel->getActiveSheet()->getHighestColumn() . 
        $Excel->getActiveSheet()->getHighestRow()
        )->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

        
        $Excel->getActiveSheet()->getStyle('A4:'.$Excel->getActiveSheet()->getHighestColumn().'5')->applyFromArray(
            array(
                'fill' => array(
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => array('argb' => 'DDDDDDDD')
                ),
            'alignment' => array(
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
            )
        );

        
        $col1 = ['1' => 'A', '2' => 'M', '3' => 'AA', '4' => 'AM', '5' => 'AY', '6' => 'BK']; // ASIGNATURA - ID
        $col2 = ['1' => 'B', '2' => 'N', '3' => 'AB', '4' => 'AN', '5' => 'AZ', '6' => 'BL']; // INICIO COMPETENCIA
        $col3 = ['1' => 'K', '2' => 'Y', '3' => 'AK', '4' => 'AW', '5' => 'BI', '6' => 'BU']; // FIN COMPETENCIA
        

        $y = $y + 1;

        $asig_num = 1;
        $col = 1;
        $y_ini = $y;


        foreach ($asignaturas as $asignatura) 
        { 
            
            if($asig_num != '1' && $y > 45)
            {                
                $col++;
                $y = $y_ini;
            }           

            $Excel->getActiveSheet()->setCellValue($col1[$col].''.$y, mb_strtoupper($asignatura->asignatura));
            

            $Excel->getActiveSheet()->getStyle($col1[$col].''.$y.':'.$col3[$col].''.$y)->applyFromArray(
                array(
                    'font' => array('bold' => true),
                    'fill' => array(
                        'fillType' => Fill::FILL_SOLID,
                        'startColor' => array('argb' => 'DDDDDDDD')
                    ),
                    'borders' => array(
                        'outline' => array(
                            'borderStyle' => Border::BORDER_THIN,
                            'color' => array('argb' => '00000000'),
                        ),
                    ),
                    'alignment' => array(
                        'wrapText' => TRUE,
                        'vertical' => Alignment::VERTICAL_CENTER,
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                    )
                )
            );



            $Excel->getActiveSheet()->mergeCells($col1[$col].''.$y.':'.$col3[$col].''.$y);
            //$Excel->getActiveSheet()->getStyle($col1[$col].''.$y.':'.$col3[$col].''.$y)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

            $competencias = Competencia::find()
                            ->where(['asignatura' => $asignatura->id])
                            ->andWhere(['periodo' => $periodo])
                            ->andWhere(['grado' => $grado])
                            ->all();
            
            $y = $y + 1;
            $c = 1;

            $posx = $x;
            $posx++;

            $total_competencias = count($competencias);

            foreach ($competencias as $competencia) 
            {
                if($asig_num != '1' && $y > 45)
                {                
                    $col++;
                    $y = $y_ini;
                }

                $Excel->getActiveSheet()->setCellValue($col1[$col].''.$y, $c);
                $Excel->getActiveSheet()->setCellValue($col2[$col].''.$y, ltrim(rtrim($competencia->competencia)));
                $Excel->getActiveSheet()->mergeCells($col2[$col].''.$y.':'.$col3[$col].''.$y);

                $Excel->getActiveSheet()->getStyle($col1[$col].''.$y_ini.':'.$col1[$col].''.$y)->applyFromArray(
                array(
                    'font' => array('bold' => true),
                    'fill' => array(
                        'fillType' => Fill::FILL_SOLID,
                        'startColor' => array('argb' => 'DDDDDDDD')
                    ),
                    'alignment' => array(
                        'wrapText' => TRUE,
                        'vertical' => Alignment::VERTICAL_CENTER,
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                    )
                )
            );

            $Excel->getActiveSheet()->getStyle($col2[$col].''.$y.':'.$col3[$col].''.$y)->applyFromArray(
                array(
                    'font' => array('bold' => false),
                    'alignment' => array(
                        'wrapText' => TRUE,
                        'vertical' => Alignment::VERTICAL_CENTER,
                        'horizontal' => Alignment::HORIZONTAL_LEFT,
                    )
                )
            );

            $Excel->getActiveSheet()->getStyle($col1[$col].''.$y.':'.$col3[$col].''.$y)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);
            
                $y = $y + 1;
                $c = $c + 1;
            }

            //$Excel->getActiveSheet()->mergeCells($col1[$col].''.$y_ini.':'.$col1[$col].''.intval($y-1));

            //$Excel->getActiveSheet()->mergeCells($x.''.$y_ini.':'.$x.''.$y);

            
            $asig_num++;
        }

        

        $Excel->setActiveSheetIndex('0');

        $filename = "R714-Sabana-Auxiliar-Notas-Grupo(".date("d-m-Y_H-i").").xlsx";
         
        // Redirect output to a client’s web browser (Xlsx)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
         
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $writer = IOFactory::createWriter($Excel, 'Xlsx');
        $writer->save('php://output');
        exit;
        
    }  

}
