<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Nivel;
use backend\models\Frd;
use backend\models\Competencia;
use backend\models\Planmejoramiento;
use backend\models\Promedioarea;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncalificaciones;
use backend\models\Comportamientocalificaciones;
use backend\models\Calificacioncompromisos;
use backend\models\Calificacionfrd;
use backend\models\Observaciongeneral;
use backend\models\Comportamiento;
use backend\models\LanzadorForm;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte716Controller extends Controller
{

    public function actionIndex($tercero = NULL, $ver_estandar = 1,$ver_competencia = 1, $ver_niveles = 1, $ver_desempenos = 1, $ver_frd = 1, $ver_fecha = 1, $ver_letrasonumeros = 1) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {
        $size_font = 7;

        if($tercero == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            //$model->reporte = 'Reporte de Valorativo por Grupo';
            //$model->observaciones = 'Exporta el informe valorativo de los estudiantes por grupos.; este reporte se genera en formato PDF.';
            $model->reporte = Yii::t('app', 'R716-Reporte');
            $model->observaciones = Yii::t('app', 'R716-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $id_tercero = $model->tercero;
                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = 5;

                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                
                
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $ver_emoticons = $model->ver_emoticons;
                $size_font = $model->fuente;
                $alto = $model->alto;

            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_emoticons' => false,
                            'ver_parametros' => true,
                        ]);

                    //exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => true,
                            'ver_emoticons' => false,
                            'ver_parametros' => true,
                        ]);

                    //exit;
                }
            }    
        }
        else
        {
            $id_tercero = Yii::$app->request->get('tercero');
            //$periodo = new Periodo();
            //$periodo = $periodo->actual->id;
            $periodo = 5;

            /*$grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $asignatura = Yii::$app->request->get('asignatura');
            $periodo = Yii::$app->request->get('periodo');*/
            
        }

        list($condicionpromocion) = Yii::$app->createController('condicionpromocion');
        $condicionpromocion->actionComprobar($grupo);
                
        $sede = Sede::find()->where(['principal' => '1'])->one();
        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        if($id_tercero != '')
        {
            
            if (($tercero = Tercero::find()->where(['id' => $id_tercero])->one()) === null)
            {
                throw new NotFoundHttpException('No existe el tercero');
            }  

            if (($estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])
                            ->andWhere(['academico.estudiante' => $tercero->id])
                            ->orderBy('primer_apellido')
                            ->all()) === null)
            {
                throw new NotFoundHttpException('No estudiante no tiene registro académico.');
            }  
            else
            {
                foreach ($estudiantes as $tercero) {
                    $grupo = Grupo::find()->where(['id' => $tercero->grupo])->one();
                }    
            }    
        }
        else
        {
            $grupo = Grupo::find()->where(['id' => $grupo])->one();
            //$sede = Sede::FindOne($grupo->sede);
            $estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])
                            ->where(['<', 'tercero.estado', 3])
                            ->andWhere(['academico.grupo' => $grupo->id])
                            ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])
                            ->all();  
        }    
        
        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R715-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }

        //$sede = Sede::FindOne($grupo->sede);
            
        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 35,
                         'margin_bottom' => 18,
                         'margin_header' => 9,
                         'margin_footer' => 5,
                         'orientation' => 'P']);  
        
        //$pdf->StarProgressBarOutput(2);


        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $i = 1;    

        $compromisos = Compromisosacudiente::find()->select(['compromiso'])->asArray()->all();

        $compromiso = [];

        foreach ($compromisos as $compromiso1) {
            $compromiso[] = $compromiso1['compromiso'];
        }
        
        foreach ($estudiantes as $estudiante) 
        {

            $estado = ($estudiante->estudiantes->grupos->aprobo == 1) ? Yii::t('app', 'Aprobó') : Yii::t('app', 'No Aprobó');

            $pdf->AddPage(0,'Letter');

            $pdf->SetFillColor(255);
            $pdf->SetTextColor(0);
            $pdf->SetDrawColor(0,0,0);
        
            if($ver_fecha == 1)
            {
                $fecha = strftime("%A, %d de %B de %Y");

                $pdf->setX(140);
                $pdf->SetFont('helvetica','',$size_font);
                $pdf->Cell(60,5,$fecha,0,0,'R');
                $pdf->Ln(5);
            }    

            $pdf->Ln(5);

            $pdf->SetFont('Helvetica','',$size_font+2);   
            $pdf->MultiCell(185, 5, Yii::t('app', 'El suscrito Rector(a) del {institucion}', [
                'institucion' => $sede->sede,
            ]), 0,'C',0);

            $pdf->Ln(5);
            $pdf->SetFont('Helvetica','B',$size_font+5);   
            $pdf->Cell(190,10,Yii::t('app', 'R706-CERTIFICA'),0,0,'C');

            $pdf->Ln(15);

            $pdf->SetFont('Helvetica','',$size_font+2);

            $pdf->MultiCell(185, 5, Yii::t('app', 'Que el estudiante(a) {estudiante} identificado(a) con {tipo_identificacion} Nº {identificacion} de {municipio} ({departamento}), Cursó y {aprobo} el grado {grado} en la Sede {sede} jornada {jornada} en el grupo {grupo} de Educación {modalidad} en la Especialidad {especialidad} durante el año electivo {vigencia} y obtuvo las siguientes calificaciones conceptuales e intensidad horaria que a continuación presentamos.', [
                'estudiante' => $estudiante->estudiantes->nombreinverso,
                'tipo_identificacion' => $estudiante->estudiantes->tipos->tipo,
                'identificacion' => $estudiante->estudiantes->identificacion,
                'municipio' => isset ($estudiante->estudiantes->municipioexpedido->nombre) ? $estudiante->estudiantes->municipioexpedido->nombre : "No Especificado",
                'departamento' => isset($estudiante->estudiantes->departamentoexpedido->nombre) ? $estudiante->estudiantes->departamentoexpedido->nombre : "No Especificado",
                'aprobo' => $estado,
                'sede' => $sede->sede,
                'jornada' => $grupo->jornadas->jornada,
                'grado' => $grupo->grados->grado,
                'grupo' => $grupo->grupo,
                'modalidad' => $grupo->modalidades->modalidad,
                'especialidad' => $estudiante->especialidades->especialidad,
                'vigencia' => $sede->vigencia
            ]), 0,'L',0);


            $pdf->Bookmark(mb_strtoupper($estudiante->estudiantes->nombreinverso), 0);
            
            $pdf->Ln(5);

            $tipo_calificacion = $grupo->grados->tipo_calificacion;
            $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

            

            if($estudiante->especialidad == '1')
            {   //echo "<br> Sin Especialidad";
                $asignaturas = Asignatura::find()
                                ->joinWith('areas')    
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->orderBy(['area.area' => SORT_ASC])
                                ->all();
            }
            else
            {   //echo "<br> Con Especialidad";
                $asignaturas = Asignatura::find()
                                ->joinWith('areas')
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->orWhere(['especialidad' => $estudiante->especialidad])
                                ->orderBy(['area' => SORT_ASC])
                                ->all();
            }    

            $i = 1;

            $cod_area_anterior = '';

            $pdf->SetFont('Helvetica','B',$size_font - 2);

            $pdf->Cell(135);
            $pdf->Cell(25,$alto,mb_strtoupper(Yii::t('app', 'Escala Institucional')),'LTRB',0,'C',1);
            $pdf->Cell(25,$alto,mb_strtoupper(Yii::t('app', 'Escala Nacional')),'LTRB',0,'C',1);

            
            foreach ($asignaturas as $asignatura) 
            {

                if($ver_colores == 1)
                {
                    $pdf->setFillColor(230);
                }

                $pdf->SetFont('Helvetica','B',$size_font);

                $cod_area_nuevo = $asignatura->areas->id;

                if($cod_area_anterior != $cod_area_nuevo)
                { 
                    $pdf->Ln($alto);

//                    $pdf->Cell(135,$alto,mb_strtoupper(Yii::t('app', 'Área').' - '.$asignatura->areas->area),1,0,'C',1);
                    $pdf->Cell(185,$alto,mb_strtoupper(Yii::t('app', 'Área').' - '.$asignatura->areas->area),1,0,'C',1);
                
                    $cod_area_anterior = $asignatura->areas->id;

/*
                    ///////   DEFINITIVA DEL ÁREA   ////////////

                    $pdf->SetFont('Helvetica','B',$size_font);
                    //$pdf->Cell(25,5,mb_strtoupper(Yii::t('app', 'Definitiva')),'LTRB',0,'C',1);

                    $promedio = Promedioarea::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['area' => $asignatura->areas->id])
                                ->andWhere(['periodo' => $periodo])
                                ->one();

                    $desempeno = new Desempeno();
                            
                    //$pdf->setFillColor(255);
                    //$pdf->SetTextColor(0);                          

                    if($ver_colores == 1)
                    {
                        $color = $desempeno->hex2rgb($desempeno->color(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion));
                    }

                    if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                    {
                        // ESCALA INSTITUCIONAL
                        $desempenos = $desempeno->desempeno(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        
                        if($ver_colores == 1)
                        {
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                        }

                        $pdf->Cell(25,$alto,isset($promedio) ? $promedio->promedio_estudiante : 0,'LTRB',0,'C',1);


                        // ESCALA NACIONAL
                        $desempenos = $desempeno->desempeno(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);

                        if($ver_colores == 1)
                        {
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                        } 
                        
                        $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);
                        

                    }
                    else // NOTA O DESEMPEÑO EN LETRAS
                    {
                        
                        // ESCALA INSTITUCIONAL
                        $desempenos = $desempeno->nota(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                        $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);

                        // ESCALA NACIONAL
                        $desempenos = $desempeno->desempeno(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        
                        if($ver_colores == 1)
                        {
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                        }

                        $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);
                        
                    }
*/
                     
                }
                    
                $pdf->Ln($alto);
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor(230);
                }

                $pdf->Cell(18,$alto,mb_strtoupper(Yii::t('app', 'Asignatura')),1,0,'C',1);
                
                $pdf->setFillColor(255);
                $pdf->SetFont('Helvetica','',$size_font);    
      
                $pdf->Cell(97,$alto,mb_strtoupper($asignatura->asignatura),1,0,'J',0);  

                
                $pdf->SetFont('Helvetica','B',$size_font);
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor(230);
                }

                $pdf->Cell(5,$alto,mb_strtoupper(Yii::t('app', 'IH')),'LBTR',0,'C',1);
                $pdf->SetFont('Helvetica','',$size_font);
                $pdf->setFillColor(255);
                $pdf->Cell(5,$alto,$asignatura->intensidad,1,0,'C',0);

                $calificacion = Calificacion::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $periodo])
                                ->one();

            

                if ($grupo->sedes->fallas == 1)
                {
                    $fallas = Asistencia::find()
                                ->select(['fallas'])
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $periodo])
                                ->sum('fallas');
                }
                else
                {
                    $fallas = isset($calificacion) ? $calificacion->fallas : '';
                    //$fallas =0;
                }

                $pdf->SetFont('Helvetica','B',$size_font);
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor(230);
                }
                
                $pdf->Cell(5,$alto,mb_strtoupper(Yii::t('app', 'F')),1,0,'C',1);
                $pdf->SetFont('Helvetica','',$size_font);
                $pdf->setFillColor(255);
                $pdf->Cell(5,$alto,$fallas,1,0,'C',0);  
            

                ///////   DEFINITIVA DE LA ASIGNATURA   ////////////

                $pdf->SetFont('Helvetica','B',$size_font);
                //$pdf->Cell(25,$alto,mb_strtoupper(Yii::t('app', 'Definitiva')),'LTRB',0,'C',1);

                $desempeno = new Desempeno();
                        
                //$pdf->setFillColor(255);
                //$pdf->SetTextColor(0);                          

                ////////////////////

                if($ver_colores == 1)
                {
                    $color = $desempeno->hex2rgb($desempeno->color(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion));
                }

                if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                {
                    // ESCALA INSTITUCIONAL
                    $desempenos = $desempeno->desempeno(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                    
                    $pdf->SetFont('Helvetica','B',$size_font);          
                    $pdf->SetTextColor(0);
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }

                    $pdf->Cell(25,$alto,isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,'LTRB',0,'C',1);

                    // ESCALA NACIONAL
                    $desempenos = $desempeno->desempeno(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                    
                    $pdf->SetFont('Helvetica','B',$size_font);          
                    $pdf->SetTextColor(0);
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }

                    $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);

                }
                else // NOTA O DESEMPEÑO EN LETRAS
                {
                    // ESCALA INSTITUCIONAL
                    $desempenos = $desempeno->nota(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                    
                    $pdf->SetFont('Helvetica','B',$size_font);          
                    $pdf->SetTextColor(0);
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }

                    $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);


                    // ESCALA NACIONAL
                    $desempenos = $desempeno->desempeno(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                    
                    $pdf->SetFont('Helvetica','B',$size_font);          
                    $pdf->SetTextColor(0);
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }

                    $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);
                    
                }
            }



//////////////////////////   OBSERVACIONES GENERALES    //////////////////////////////////


            
            $comportamiento = Comportamiento::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['periodo' => '5'])
                                ->one();

            //if(isset($comportamiento))
            //{    


                ///////////////////////  INICIO DE LA CALIFICACION DEL COMPORTAMIENTO  ////////////////////

                $pdf->Ln($alto);
                $pdf->setFillColor(255);
                $pdf->SetFont('Helvetica','',$size_font);    
      

                ///////   DEFINITIVA DEL COMPORTAMIENTO   ////////////

                $pdf->SetFont('Helvetica','B',$size_font);
                $pdf->Cell(135,$alto,mb_strtoupper(Yii::t('app', 'Comportamiento del Estudiante')),'LTRB',0,'C',1);

                $desempeno = new Desempeno();
                        
                //$pdf->setFillColor(255);
                //$pdf->SetTextColor(0);                          

                ////////////////////

                if($ver_emoticons == 0) // VER EMOTICONS - NO
                {
                    if($ver_colores == 1)
                    {
                        $color = $desempeno->hex2rgb($desempeno->color(isset($comportamiento) ? $comportamiento->calificacion : 0,$tipo_calificacion));
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                    }

                    if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                    {
                        $desempenos = $desempeno->desempeno(isset($comportamiento) ? $comportamiento->calificacion : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        $pdf->Cell(25,$alto,isset($comportamiento) ? $comportamiento->calificacion : 0,'LTRB',0,'C',1);
                        
                        

                    }
                    else // NOTA O DESEMPEÑO EN LETRAS
                    {
                        $desempenos_nota = $desempeno->nota(isset($comportamiento) ? $comportamiento->calificacion : 0,$tipo_calificacion);
                        $desempenos = $desempeno->desempeno(isset($comportamiento) ? $comportamiento->calificacion : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        $pdf->Cell(25,$alto,$desempenos_nota,'LTRB',0,'C',1);
                        $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);
                        //$pdf->Cell(20,5,isset($comportamiento) ? $comportamiento->calificacion : 0,'LTRB',0,'C',1);
                    }
                }
                else  // VER EMOTICONS - SI
                {
                    if($tipo_calificacion == 1) // LETRAS
                    {
                        $desempenos = isset($comportamiento) ? $comportamiento->calificacion : '';
                        
                        if($ver_colores == 1)
                        {
                            $color = $desempeno->hex2rgb($desempeno->color(isset($comportamiento) ? $comportamiento->calificacion : 'NE',$tipo_calificacion));
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                        }

                        $emoticons = $desempeno->emoticons(isset($comportamiento) ? $comportamiento->calificacion : 'NE',$tipo_calificacion);
                        
                        
                        $pdf->Cell(15,$alto,$desempenos,'LTRB',0,'C',1);
                    }
                    else // NUMEROS
                    {
                        if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                        {
                            $desempenos = isset($comportamiento) ? $comportamiento->calificacion : '';
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(isset($comportamiento) ? $comportamiento->calificacion : 0,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $emoticons = $desempeno->emoticons(isset($comportamiento) ? (float)$comportamiento->calificacion : 0,$tipo_calificacion);
                            
                            
                            $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);
                        }
                        else
                        {
                            $desempenos = $desempeno->desempeno(isset($comportamiento) ? $comportamiento->calificacion : 0,$tipo_calificacion);
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(isset($comportamiento) ? $comportamiento->calificacion : 0,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $emoticons = $desempeno->emoticons(isset($comportamiento) ? (float)$comportamiento->calificacion : 0,$tipo_calificacion);
                            
                            
                            $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);
                        }
                    }

                    //$pdf->setFillColor($color['r'],$color['g'],$color['b']);
                    //$pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);

                    $x = $pdf->x+0.3;
                    $y = $pdf->y+0.3;

                    $pdf->Cell(5,$alto,'','LBTR',0,'C',0); 

                    $pdf->Image(Yii::getAlias('@web/images/smile/'.$emoticons),$x,$y,4.5);
                    $pdf->Ln(-($alto)); 
                }
                                

            //}    


            // ESCALA DE DESEMPEÑOS 

            $pdf->Ln(5);

            $pdf->SetFont('Helvetica','',$size_font-2);

            $niveles = Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->andWhere(['estado' => 1])->all();    
                
            foreach ($niveles as $nivel) 
            {
                $desempeno = new Desempeno();

                if($ver_colores == 1)
                {
                    $color = $desempeno->hex2rgb($nivel->color);
                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                }                 
                
                $pdf->Cell(5,3,$nivel->nota,'LBT',0,'C',1);
                $pdf->setFillColor(255);

                $pdf->Cell(12 ,3,mb_strtoupper($nivel->desempeno),'BTR',0,'C',0);    
            }

            $pdf->Ln(10);

            $pdf->SetFont('Helvetica','B',$size_font+1);

            //echo "<pre>";
            //print_r($estudiante);
            //echo "</pre><br><br>";
            
            
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Ln(8);
           // $pdf->Cell(180,6,"En constancia de entrega y publicación del informe valorativo y en constancia firmamos. ",0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);

            $y = $pdf->y;
            $x = $pdf->x;

            $pdf->Ln(20); 
            
            
            //$pdf->Image(\Yii::getAlias('@webroot/uploads/'.$grupo->sedes->rector_firma),$x+65,$y,50);
            
            $pdf->setY($pdf->y-15);
            
            $pdf->Cell(60);
            $pdf->Cell(60,5,$grupo->sedes->rector_nombre,'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(60);
            $pdf->Cell(60,5,Yii::t('app', 'Rector(a)'),'',0,'C',0);
            $pdf->Ln(1); 


        }

        $pdf->Output("R716-Certificado-Informe-Final(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}
