<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Nivel;
use backend\models\Frd;
use backend\models\Competencia;
use backend\models\Planmejoramiento;
use backend\models\Promedioarea;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncalificaciones;
use backend\models\Comportamientocalificaciones;
use backend\models\Calificacioncompromisos;
use backend\models\Calificacionfrd;
use backend\models\Observaciongeneral;
use backend\models\Comportamiento;
use backend\models\LanzadorForm;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte718Controller extends Controller
{

    public function actionIndex($tercero = NULL, $ver_estandar = 1,$ver_competencia = 1, $ver_niveles = 1, $ver_desempenos = 1, $ver_frd = 1, $ver_fecha = 1, $ver_letrasonumeros = 1) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {
        $size_font = 7;

        if($tercero == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            //$model->reporte = 'Reporte de Valorativo por Grupo';
            //$model->observaciones = 'Exporta el informe valorativo de los estudiantes por grupos.; este reporte se genera en formato PDF.';
            $model->reporte = Yii::t('app', 'R716-Reporte');
            $model->observaciones = Yii::t('app', 'R716-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $id_tercero = $model->tercero;
                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = 5;

                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                
                
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_emoticons' => false,
                            'ver_parametros' => true,
                        ]);

                    //exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => true,
                            'ver_emoticons' => false,
                            'ver_parametros' => true,
                        ]);

                    //exit;
                }
            }    
        }
        else
        {
            $id_tercero = Yii::$app->request->get('tercero');
            $periodo = new Periodo();
            $periodo = $periodo->actual->id;

            /*$grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $asignatura = Yii::$app->request->get('asignatura');
            $periodo = Yii::$app->request->get('periodo');*/
            
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        if($id_tercero != '')
        {
            
            if (($tercero = Tercero::find()->where(['id' => $id_tercero])->one()) === null)
            {
                throw new NotFoundHttpException('No existe el tercero');
            }  

            if (($estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])
                            ->andWhere(['academico.estudiante' => $tercero->id])
                            ->orderBy('primer_apellido')
                            ->all()) === null)
            {
                throw new NotFoundHttpException('No estudiante no tiene registro académico.');
            }  
            else
            {
                foreach ($estudiantes as $tercero) {
                    $grupo = Grupo::find()->where(['id' => $tercero->grupo])->one();
                }    
            }    
        }
        else
        {
            $grupo = Grupo::find()->where(['id' => $grupo])->one();
            //$sede = Sede::FindOne($grupo->sede);
            $estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])
                            //->where(['<', 'tercero.estado', 3])
                            ->andWhere(['academico.grupo' => $grupo->id])
                            ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])
                            ->all();  
        }    
        
        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R716-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
            
        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 35,
                         'margin_bottom' => 18,
                         'margin_header' => 9,
                         'margin_footer' => 5,
                         'orientation' => 'P']);  
        
        //$pdf->StarProgressBarOutput(2);


        if ($grupo->sedes->pdf_marcadeagua == 'T' OR $grupo->sedes->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($grupo->sedes->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($grupo->sedes->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($grupo->sedes->pdf_header);
        $pdf->setFooter($grupo->sedes->pdf_footer);
        
        $pdf->AliasNbPages();

        foreach ($estudiantes as $estudiante) 
        {

            $pdf->AddPage(0,'Letter');

            $pdf->SetFillColor(255);
            $pdf->SetTextColor(0);
            $pdf->SetDrawColor(0,0,0);
        
            if($ver_fecha == 1)
            {
                $fecha = strftime("%A, %d de %B de %Y");

                $pdf->setX(140);
                $pdf->SetFont('helvetica','',$size_font);
                $pdf->Cell(60,5,$fecha,0,0,'R');
                $pdf->Ln(5);
            }    

            $pdf->SetFont('Helvetica','B',10);   
            $pdf->Cell(190,10,Yii::t('app', 'R716-INFORME FINAL'),0,0,'C');

            $pdf->Ln(10);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(18,$alto,Yii::t('app', 'Estudiante'),0,0); 
            $pdf->SetFont('Helvetica','',$size_font);

            $nombre = mb_strtoupper($estudiante->estudiantes->nombreinverso);
            //echo "<br><br>Estudiante : ".$nombre;
            $pdf->Bookmark($nombre, 0);
            $pdf->Cell(65,$alto,$nombre,0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(23,$alto,Yii::t('app', 'Identificación'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(25,$alto,$estudiante->estudiantes->identificacion,0,0);
            
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(20,$alto,Yii::t('app', 'Especialidad'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(50,$alto,$estudiante->especialidades->especialidad,0,0);
            
            
            $pdf->Ln($alto);
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,$alto,Yii::t('app', 'Sede'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(50,$alto,$grupo->sedes->sede,0,0);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(12,$alto,Yii::t('app', 'Jornada'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(20,$alto,$grupo->jornadas->jornada,0,0);  

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,$alto,Yii::t('app', 'Grupo'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(20,$alto,$grupo->grupo,0,0);
            /*
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(13,$alto,Yii::t('app', 'Periodo'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(8,$alto,$periodo,0,0);
            */
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,$alto,Yii::t('app', 'Año'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(8,$alto,$grupo->sedes->vigencia,0,0);

            $pdf->Ln($alto + 5);
            
            $tipo_calificacion = $grupo->grados->tipo_calificacion;
            $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

            

            if($estudiante->especialidad == '1')
            {   //echo "<br> Sin Especialidad";
                $asignaturas = Asignatura::find()
                                ->joinWith('areas')    
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->orderBy(['area.area' => SORT_ASC])
                                ->all();
            }
            else
            {   //echo "<br> Con Especialidad";
                $asignaturas = Asignatura::find()
                                ->joinWith('areas')
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->orWhere(['especialidad' => $estudiante->especialidad])
                                ->orderBy(['area' => SORT_ASC])
                                ->all();
            }    

            $i = 1;

            $cod_area_anterior = '';

            $pdf->SetFont('Helvetica','B',$size_font - 2);

            $pdf->Cell(135);
            $pdf->Cell(50,$alto,mb_strtoupper(Yii::t('app', 'Escala Definitiva')),'LTRB',0,'C',1);
            

            $pdf->Ln($alto);

            $pdf->Cell(115);
            
            for($p=1;$p<$periodo;$p++)
            {
                $pdf->SetTextColor(0);
                $pdf->setFillColor(255);
                $pdf->Cell(5,$alto,Yii::t('app', 'P').$p,'LTRB',0,'C',1);
            }

            $pdf->Cell(25,$alto,mb_strtoupper(Yii::t('app', 'Institucional')),'LTRB',0,'C',1);
            $pdf->Cell(25,$alto,mb_strtoupper(Yii::t('app', 'Nacional')),'LTRB',0,'C',1);

            
            foreach ($asignaturas as $asignatura) 
            {

                
                    $pdf->setFillColor(230);
                    $pdf->SetFont('Helvetica','B',$size_font);

                    $cod_area_nuevo = $asignatura->areas->id;

                    if($cod_area_anterior != $cod_area_nuevo)
                    { 
                        $pdf->Ln($alto);

                        $pdf->Cell(115,$alto,mb_strtoupper(Yii::t('app', 'Área').' - '.$asignatura->areas->area),1,0,'C',1);
                    
                        $cod_area_anterior = $asignatura->areas->id;

                        for($p=1;$p<=$periodo;$p++)
                        {
                            ///////   DEFINITIVA DEL ÁREA   ////////////

                            $pdf->SetFont('Helvetica','B',$size_font);
                            //$pdf->Cell(25,$alto,mb_strtoupper(Yii::t('app', 'Definitiva')),'LTRB',0,'C',1);

                            $promedio = Promedioarea::find()
                                        ->where(['estudiante' => $estudiante->id])
                                        ->andWhere(['grupo' => $grupo->id])
                                        ->andWhere(['area' => $asignatura->areas->id])
                                        ->andWhere(['periodo' => $p])
                                        ->one();

                            $desempeno = new Desempeno();
                                    
                            //$pdf->setFillColor(255);
                            //$pdf->SetTextColor(0);                          

                        
                            $color = $desempeno->hex2rgb($desempeno->color(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion));

                            if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                            {
                               
                                if ($p == 5)
                                {
                                    // ESCALA INSTITUCIONAL
                                    //$desempenos = $desempeno->desempeno(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion);
                                    
                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                    $pdf->SetTextColor(0);
                                    $pdf->setFillColor(255);
                                    $pdf->Cell(25,$alto,isset($promedio) ? $promedio->promedio_estudiante : 0,'LTRB',0,'C',1);
                                    

                                    $desempenos = $desempeno->desempeno(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion);
                                    
                                    // ESCALA NACIONAL
                                    
                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                    $pdf->SetTextColor(0);
                                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                    $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);

                                }
                                else
                                {
                                    // ESCALA NACIONAL
                                    $desempenos = $desempeno->nota(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion);
                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                    $pdf->SetTextColor(0);
                                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                    $pdf->Cell(5,$alto,isset($promedio) ? $promedio->promedio_estudiante : 0,'LTRB',0,'C',1);
                                    //$pdf->Cell(5,$alto,$desempenos,'LTRB',0,'C',1);
                                }

                            }
                            else // NOTA O DESEMPEÑO EN LETRAS
                            {
                                if ($p == 5)
                                {
                                    // ESCALA INSTITUCIONAL
                                    $desempenos = $desempeno->nota(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion);
                                    
                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                    $pdf->SetTextColor(0);
                                    $pdf->setFillColor(255);
                                    $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);
                                    //$pdf->Cell(25,$alto,isset($promedio) ? $promedio->promedio_estudiante : 0,'LTRB',0,'C',1);

                                    $desempenos = $desempeno->desempeno(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion);
                                    
                                    // ESCALA NACIONAL
                                    
                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                    $pdf->SetTextColor(0);
                                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                    $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);

                                }
                                else
                                {
                                    // ESCALA NACIONAL
                                    $desempenos = $desempeno->nota(isset($promedio) ? $promedio->promedio_estudiante : 0,$tipo_calificacion);
                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                    $pdf->SetTextColor(0);
                                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                    $pdf->Cell(5,$alto,$desempenos,'LTRB',0,'C',1);
                                }
                            }
                        }
                         
                    }
                        
                    $pdf->Ln($alto);
                    
                    $pdf->setFillColor(230);

                    $pdf->Cell(18,$alto,mb_strtoupper(Yii::t('app', 'Asignatura')),1,0,'C',1);
                    
                    $pdf->setFillColor(255);
                    $pdf->SetFont('Helvetica','',$size_font);    
          
                    $pdf->Cell(77,$alto,mb_strtoupper($asignatura->asignatura),1,0,'J',0);  

                    $pdf->SetFont('Helvetica','B',$size_font);
                    $pdf->setFillColor(230);
                    $pdf->Cell(5,$alto,mb_strtoupper(Yii::t('app', 'IH')),'LBTR',0,'C',1);
                    $pdf->SetFont('Helvetica','',$size_font);
                    $pdf->setFillColor(255);
                    $pdf->Cell(5,$alto,$asignatura->intensidad,1,0,'C',0);

                    if ($grupo->sedes->fallas == 1)
                    {
                        $fallas = Asistencia::find()
                                    ->select(['fallas'])
                                    ->where(['estudiante' => $estudiante->id])
                                    ->andWhere(['grupo' => $grupo->id])
                                    ->andWhere(['asignatura' => $asignatura->id])
                                    ->andWhere(['periodo' => $p])
                                    ->sum('fallas');
                    }
                    else
                    {
                        $fallas = isset($calificacion) ? $calificacion->fallas : '';
                        //$fallas =0;
                    }

                    $pdf->SetFont('Helvetica','B',$size_font);
                    $pdf->setFillColor(230);
                    $pdf->Cell(5,$alto,mb_strtoupper(Yii::t('app', 'F')),1,0,'C',1);
                    $pdf->SetFont('Helvetica','',$size_font);
                    $pdf->setFillColor(255);
                    $pdf->Cell(5,$alto,$fallas,1,0,'C',0);  


                    for($p=1;$p<=$periodo;$p++)
                    {
                        $calificacion = Calificacion::find()
                                        ->where(['estudiante' => $estudiante->id])
                                        ->andWhere(['grupo' => $grupo->id])
                                        ->andWhere(['asignatura' => $asignatura->id])
                                        ->andWhere(['periodo' => $p])
                                        ->one();

                    
                        ///////   DEFINITIVA DE LA ASIGNATURA   ////////////

                        $pdf->SetFont('Helvetica','B',$size_font);
                        //$pdf->Cell(25,$alto,mb_strtoupper(Yii::t('app', 'Definitiva')),'LTRB',0,'C',1);

                        $desempeno = new Desempeno();
                                
                        //$pdf->setFillColor(255);
                        //$pdf->SetTextColor(0);                          

                        ////////////////////

                        $color = $desempeno->hex2rgb($desempeno->color(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion));

                        if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                        {
                            
                            if ($p == 5)
                            {
                                // ESCALA INSTITUCIONAL
                                $desempenos = $desempeno->desempeno(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                                
                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->SetTextColor(0);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(25,$alto,isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,'LTRB',0,'C',1);

                                // ESCALA NACIONAL
                                $desempenos = $desempeno->desempeno(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                                
                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->SetTextColor(0);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);
                            }
                            else
                            {
                                // ESCALA INSTITUCIONAL
                                $desempenos = $desempeno->nota(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                                
                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->SetTextColor(0);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(5,$alto,isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,'LTRB',0,'C',1);

                                /*
                                // ESCALA NACIONAL
                                $desempenos = $desempeno->desempeno(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                                
                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->SetTextColor(0);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(5,$alto,$desempenos,'LTRB',0,'C',1);
                                */
                            }

                        }
                        else // NOTA O DESEMPEÑO EN LETRAS
                        {
                            if ($p == 5)
                            {
                                // ESCALA INSTITUCIONAL
                                $desempenos = $desempeno->nota(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                                
                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->SetTextColor(0);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);


                                // ESCALA INSTITUCIONAL
                                $desempenos = $desempeno->desempeno(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                                
                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->SetTextColor(0);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(25,$alto,$desempenos,'LTRB',0,'C',1);
                            }
                            else
                            {
                                // ESCALA INSTITUCIONAL
                                $desempenos = $desempeno->nota(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                                
                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->SetTextColor(0);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(5,$alto,$desempenos,'LTRB',0,'C',1);
                            }
                            
                        }
                    }
                    //$pdf->Ln(5);
                    
                    
                    
                
            }



            $pdf->Ln(10);

            $pdf->SetFont('Helvetica','',$size_font-2);

            $niveles = Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->andWhere(['estado' => 1])->all();    
                
            foreach ($niveles as $nivel) 
            {
                $desempeno = new Desempeno();

                $color = $desempeno->hex2rgb($nivel->color);
                
                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                $pdf->Cell(5,3,$nivel->nota,'LBT',0,'C',1);
                $pdf->setFillColor(255);

                $pdf->Cell(12 ,3,mb_strtoupper($nivel->desempeno),'BTR',0,'C',0);    
            }


            $pdf->Ln(5);

            $pdf->SetFont('Helvetica','',$size_font);
            //$pdf->Ln(8);
            //$pdf->Cell(180,6,"En constancia de entrega y publicación del informe valorativo y en constancia firmamos. ",0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);

            $y = $pdf->y;
            $x = $pdf->x;

            if($director_firma != '' or $director_firma != NULL )
            {
                //$pdf->Image(\Yii::getAlias('@webroot/uploads/'.$director_firma),$x+30,$y,50);    
            }    
            
            
            $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$grupo->sedes->rector_firma),$x+105,$y,50);
            
            $pdf->setY($pdf->y-15);
            $pdf->Cell(30);
            $pdf->Cell(60,5,$director_nombre,'T',0,'C',0);

            $pdf->Cell(15);
            $pdf->Cell(60,5,$grupo->sedes->rector_nombre,'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(25);
            $pdf->Cell(60,5,Yii::t('app', 'Director(a)'),'',0,'C',0);
            $pdf->Cell(15);
            $pdf->Cell(60,5,Yii::t('app', 'Rector(a)'),'',0,'C',0);
            $pdf->Ln(1); 


        }

        $pdf->Output("R716-Reporte-Acumulado-Informe-Final(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}
