<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;
use backend\models\Calificacioncalificaciones;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Helper\Sample;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;

//use Mpdf\Mpdf;

class Reporte718Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            $model->reporte = Yii::t('app', 'R718-Reporte');
            $model->observaciones = Yii::t('app', 'R718-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $periodo = Yii::$app->request->get('periodo');
            $size_font = 7;
            $ver_colores = 1;
            $size_font = 7;
            $alto = 3;
            
        }

        list($condicionpromocion) = Yii::$app->createController('condicionpromocion');
        $condicionpromocion->actionComprobar($grupo);
                

        $periodo_actual = new Periodo();
        $periodo_actual = $periodo_actual->actual->id;

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $grupo = Grupo::find()->where(['id' => $grupo])->one();

        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R718-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
        
        $sede = Sede::FindOne($grupo->sede);
        $asignaturas = Asignatura::find()->where(['grado' => $grupo->grados->id])->all();


        /// MARGENES HOJA
        $top = '1';
        $right = '0.5';
        $left = '0.5';
        $bottom = '1';

        $Excel = new Spreadsheet();

        $Excel->getProperties()
        ->setCreator("Sonic")
        ->setLastModifiedBy("Sonic")
        ->setTitle("Reporte 718 - Sábana de notas acumulado por grupos")
        ->setDescription("Documento generado por Sonic")
        ->setCategory("Listados"); 



        $this->render('/reporte/_headerandfooter_excel_landscape', ['Excel' => $Excel]);    

        $Excel->setActiveSheetIndex(0);

        $Excel->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_LANDSCAPE);
        $Excel->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_FOLIO);
        $Excel->getActiveSheet()->getPageSetup()->setHorizontalCentered(true);
        $Excel->getActiveSheet()->getPageMargins()->setTop($top);
        $Excel->getActiveSheet()->getPageMargins()->setRight($right);
        $Excel->getActiveSheet()->getPageMargins()->setLeft($left);
        $Excel->getActiveSheet()->getPageMargins()->setBottom($bottom);
        
        $Excel->getActiveSheet()->setTitle('Listado');

        $style = array(
            'alignment' => array(
                'horizontal' => Alignment::HORIZONTAL_CENTER,
            )
        );

        
        $Excel->getActiveSheet()->mergeCells('A1:V1');
        $Excel->getActiveSheet()->setCellValue('A1', mb_strtoupper(Yii::t('app', 'INFORME VALORATIVO ACUMULADO')));
        $Excel->getActiveSheet()->getStyle('A1')->applyFromArray($style);
        $Excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);

        $Excel->getActiveSheet()->mergeCells('A2:V2');
        //$Excel->getActiveSheet()->setCellValue('A2', isset($grupo) ? mb_strtoupper(Yii::t('app', 'Grupo').' '.$grupo->grupo) : mb_strtoupper(Yii::t('app', 'Grado').' '.$grado->grado));
        $Excel->getActiveSheet()->getStyle('A2')->applyFromArray($style);
        $Excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);

        //$Excel->getActiveSheet()->setCellValue('B3', mb_strtoupper(Yii::t('app', 'Sede')));
        $Excel->getActiveSheet()->setCellValue('G3', mb_strtoupper(Yii::t('app', 'Jornada')));
        $Excel->getActiveSheet()->setCellValue('J3', mb_strtoupper(Yii::t('app', 'Grupo')));
        
        $Excel->getActiveSheet()->mergeCells('B3:F3');
        $Excel->getActiveSheet()->setCellValue('B3', mb_strtoupper($grupo->sedes->sede));
        $Excel->getActiveSheet()->mergeCells('H3:I3');
        $Excel->getActiveSheet()->setCellValue('H3', mb_strtoupper($grupo->jornadas->jornada));
        $Excel->getActiveSheet()->mergeCells('K3:L3');
        $Excel->getActiveSheet()->setCellValue('K3', mb_strtoupper($grupo->grupo));
        

        
        if($ver_fecha == 1)
        {
            $fecha = strftime("%A, %d de %B de %Y");

            $Excel->getActiveSheet()->setCellValue('M3', mb_strtoupper(Yii::t('app', 'Fecha')));
            $Excel->getActiveSheet()->mergeCells('N3:Q3');
            $Excel->getActiveSheet()->setCellValue('N3', mb_strtoupper($fecha));

        }    

        $Excel->getActiveSheet()->setCellValue('A5', mb_strtoupper(Yii::t('app', '#')));
        $Excel->getActiveSheet()->setCellValue('B5', mb_strtoupper(Yii::t('app', 'Estudiante')));

        $columna = 'C';
        foreach ($asignaturas as $asignatura) 
        {
            $col_ini = $columna;
            $Excel->getActiveSheet()->setCellValue($columna.'5', mb_strtoupper(substr($asignatura->codigo,0,5)));
            $columna++;
            $columna++;
            $col_fin = $columna;
            $columna++;
            

            $Excel->getActiveSheet()->mergeCells($col_ini.'5:'.$col_fin.'5');
        }

        $Excel->getActiveSheet()->setCellValue($columna.'5', mb_strtoupper(Yii::t('app', 'G')));
        $columna++;
        $Excel->getActiveSheet()->setCellValue($columna.'5', mb_strtoupper(Yii::t('app', 'P')));
        $columna++;
        $Excel->getActiveSheet()->setCellValue($columna.'5', mb_strtoupper(Yii::t('app', 'Promovido')));

        $Excel->getActiveSheet()->setAutoFilter('A5:'.$Excel->getActiveSheet()->getHighestColumn().'5');

        $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad','academico.aprobo'])
                        ->joinWith(['estudiantes'])
                        ->where(['<', 'tercero.estado', 3])
                        ->andWhere(['academico.grupo' => $grupo->id])
                        ->orderBy('primer_apellido')->all();  
        
        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

        $x=1;
        $fila = 6;

        $ivan = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad','academico.aprobo'])
        ->joinWith(['estudiantes'])
        ->where(['<', 'tercero.estado', 3])
        ->andWhere(['academico.grupo' => $grupo->id])
        ->orderBy('primer_apellido');  

        foreach ($estudiantes as $estudiante) 
        {
            $perdidas = 0;
            $ganadas = 0;

            $Excel->getActiveSheet()->setCellValue('A'.$fila, $x);
            $Excel->getActiveSheet()->setCellValue('B'.$fila, mb_strtoupper($estudiante->estudiantes->nombreinverso));

            //$Excel->getActiveSheet()->setCellValue('B'.$fila, $ivan->createCommand()->getRawSql());

            //echo $query->createCommand()->getRawSql(); // Mostrar SQL   

            
            $x++;
            
            $columna = 'C';
            foreach ($asignaturas as $asignatura) 
            {   
                for ($p=1; $p <= 5; $p++) 
                { 
                    if($p == 1)
                    {
                        $col_p1 = $columna;
                    }
                    
                    $calificacion = Calificacion::find()
                            ->where(['estudiante' => $estudiante->id])
                            ->andWhere(['grupo' => $grupo->id])
                            ->andWhere(['asignatura' => $asignatura->id])
                            ->andWhere(['periodo' => $p])
                            ->one();

                    if(isset($calificacion))
                    {
                        
                        $color = "#fff;";

                        if($ver_colores == 1)
                        {
                            $desempeno = new Desempeno();
                            $color = $desempeno->color($calificacion->definitiva_final_periodo,$tipo_calificacion);
                        }    
                        
                        if($tipo_calificacion != 1)
                        {
                            if($p != 5)
                            {
                                if($calificacion->definitiva_final_periodo < 3 && $p <= $periodo_actual) 
                                {
                                    $perdidas = $perdidas + 1;
                                }    
                                else
                                {
                                    $ganadas = $ganadas + 1;
                                }
                            }   
                        }
                        else
                        {
                            if($p != 5)
                            {
                                //$perdido = Desempeno::find()->where(['nota' => ($calificacion->definitiva_final_periodo =="" ? "NE" : $calificacion->definitiva_final_periodo)])->andWhere(['tipo_calificacion' => $tipo_calificacion])->one();
                                
                                $desempeno = new Desempeno();

                                if($desempeno->perdido($calificacion->definitiva_final_periodo, $tipo_calificacion) == 1)
                                {
                                    $perdidas = $perdidas + 1;
                                }    
                                else
                                {
                                    $ganadas = $ganadas + 1;
                                }
                            }
                        }
                        
                        if($ver_letrasonumeros == 1) // LETRAS
                        {
                            $desempeno = new Desempeno();
                            $desempenos = $desempeno->nota($calificacion->definitiva_final_periodo,$tipo_calificacion);

                            if($p == 3)
                            {
                                $columna = $col_p1;
                                $fila++;
                            }

                            if($p == 5)
                            {
                                //$columna++;
                                $fila--;
                            }

                            $Excel->getActiveSheet()->setCellValue($columna.''.$fila, mb_strtoupper($desempenos));

                            if($p == 5)
                            {
                                $Excel->getActiveSheet()->mergeCells($columna.''.$fila.':'.$columna.''.($fila+1));
                            }

                            $Excel->getActiveSheet()->getStyle($columna.''.$fila)->applyFromArray(
                                array(
                                    'font'  => array(
                                        'bold'  => false,
                                        'size'  => 12,
                                        'name'  => 'Calibri'
                                    ),
                                    'fill' => array(
                                        'fillType' => Fill::FILL_SOLID,
                                        'color' => array('rgb' => substr($color,1,6)),
                                    ),
                                    'alignment' => array(
                                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                                        'vertical' => Alignment::VERTICAL_CENTER,
                                    ),
                                    'border' => array(
                                        'border' => Border::BORDER_THICK,
                                        'color' => array('rgb' => '000000'),
                                    ),

                                  )
                            );

                        }
                        else // NUMEROS
                        { 
                            $desempenos = $calificacion->definitiva_final_periodo == 0 ? '': $calificacion->definitiva_final_periodo;
                            
                            
                            switch ($p) 
                            {
                                case '1':
                                    //$pdf->WriteHTML('<td width="15px" style="text-align:center; border-right: 1px solid #000; background-color:'.$color.' word-wrap: break-word;">'.$desempenos.'</td>');
                                    break;

                                case '2':
                                    //$pdf->WriteHTML('<td style="width:15px; text-align:center; border: none; background-color:'.$color.' word-wrap: break-word;">'.$desempenos.'</td>');
                                    break;

                                case '3':
                                    //$pdf->WriteHTML('<td style="width:15px; text-align:center; border-top: 1px solid #000; background-color:'.$color.' word-wrap: break-word;">'.$desempenos.'</td>');
                                    break;

                                case '4':
                                    //$pdf->WriteHTML('<td style="width:15px; text-align:center; border-top: 1px solid #000; border-left: 1px solid #000; background-color:'.$color.' word-wrap: break-word;">'.$desempenos.'</td>');
                                    break;            
                                
                                default:
                                    //$pdf->WriteHTML('<td style="width:15px; text-align:center; border: none; background-color:'.$color.' word-wrap: break-word;">'.$desempenos.'</td>');
                                    break;
                            }
                        }    
                    }
                    else
                    {

                        if($tipo_calificacion == 1)
                        {

                            $desempeno = new Desempeno();
                            $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                            $desempenos = $desempeno->nota('NE',$tipo_calificacion);   

                            
                            $color = "#fff;";

                            if($ver_colores == 1)
                            {
                                $desempeno = new Desempeno();
                                $color = $desempeno->color(0,$tipo_calificacion);
                            }   
                            
                            if($p == 3)
                            {
                                $columna = $col_p1;
                                $fila++;
                            }

                            if($p == 5)
                            {
                                //$columna++;
                                $fila--;
                            }

                            $Excel->getActiveSheet()->setCellValue($columna.''.$fila, mb_strtoupper($desempenos));

                            if($p == 5)
                            {
                                $Excel->getActiveSheet()->mergeCells($columna.''.$fila.':'.$columna.''.($fila+1));
                            }

                            $Excel->getActiveSheet()->getStyle($columna.''.$fila)->applyFromArray(
                                array(
                                    'font'  => array(
                                        'bold'  => false,
                                        'size'  => 12,
                                        'name'  => 'Calibri'
                                    ),
                                    'fill' => array(
                                        'fillType' => Fill::FILL_SOLID,
                                        'color' => array('rgb' => substr($color,1,6)),
                                    ),
                                    'alignment' => array(
                                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                                        'vertical' => Alignment::VERTICAL_CENTER,
                                    ),
                                    'border' => array(
                                        'border' => Border::BORDER_THIN,
                                    ),

                                  )
                            );

                            if (($p <= $periodo_actual) && ($p != 5))
                            {
                                $perdidas = $perdidas + 1;    
                            }  
                        }

                        if($tipo_calificacion != 1)
                        {

                            $desempeno = new Desempeno();
                            $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                            $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                            
                            $color = "#fff;";

                            if($ver_colores == 1)
                            {
                                $desempeno = new Desempeno();
                                $color = $desempeno->color(0,$tipo_calificacion);
                            }   
                            
                            switch ($p) 
                                {
                                    case '1':
                                        //$pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border-right: 1px solid #000; word-wrap: break-word;">&nbsp;</td>');
                                        break;

                                    case '2':
                                        //$pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border: none; word-wrap: break-word;">&nbsp;</td>');
                                        break;

                                    case '3':
                                        //$pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border-top: 1px solid #000; word-wrap: break-word;">&nbsp;</td>');
                                        break;

                                    case '4':
                                        //$pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border-top: 1px solid #000; border-left: 1px solid #000; word-wrap: break-word;">&nbsp;</td>');
                                        break;            
                                    
                                    default:
                                        //$pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border: none; word-wrap: break-word;">&nbsp;</td>');
                                        break;
                                }

                            if (($p <= $periodo_actual) && ($p != 5))
                            {
                                $perdidas = $perdidas + 1;    
                            }  
                        }  
                    } 

                    $columna++;

                    /*if($p == 4)
                    {
                        $fila--;
                    } 

                    if($p == 5)
                    {
                        $fila--;
                    } */

                    
                      
                }

            }
            

            $Excel->getActiveSheet()->setCellValue($columna.''.$fila, $ganadas);
            //$columna++;
            

            $fil_ini = $fila;
            $fila+=2;
            $fil_fin = $fila-1;

            $Excel->getActiveSheet()->mergeCells('A'.$fil_ini.':A'.$fil_fin);
            $Excel->getActiveSheet()->mergeCells('B'.$fil_ini.':B'.$fil_fin);
            $Excel->getActiveSheet()->mergeCells($columna.''.$fil_ini.':'.$columna.''.$fil_fin);

            $columna++;
            $Excel->getActiveSheet()->setCellValue($columna.''.$fil_ini, $perdidas);
            $Excel->getActiveSheet()->mergeCells($columna.''.$fil_ini.':'.$columna.''.$fil_fin);
            
            $columna++;
            $Excel->getActiveSheet()->setCellValue($columna.''.$fil_ini, ($estudiante->aprobo == '1') ? Yii::t('app', 'Aprobado') : Yii::t('app', 'Reprobado'));
            $Excel->getActiveSheet()->mergeCells($columna.''.$fil_ini.':'.$columna.''.$fil_fin);
        }

        
        // ENCABEZADO LISTA
          $Excel->getActiveSheet()->getStyle('A5:'.$Excel->getActiveSheet()->getHighestColumn().'5')->applyFromArray(
              array(
                'font'  => array(
                    'bold'  => true,
                    'size'  => 12,
                    'name'  => 'Calibri'
                ),
                'fill' => array(
                    'fillType' => Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDDDDD')
                ),
                'alignment' => array(
                  'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
              )
          );

        // BORDE
        $Excel->getActiveSheet()->getStyle('A5:'.$Excel->getActiveSheet()->getHighestColumn().$Excel->getActiveSheet()->getHighestRow())->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

        $Excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);  
        $Excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true); 
        $Excel->getActiveSheet()->getColumnDimension($Excel->getActiveSheet()->getHighestColumn())->setAutoSize(true); 
         

        
        $niveles = Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->andWhere(['estado' => 1])->all();    
            
        foreach ($niveles as $nivel) 
        {
            $desempeno = new Desempeno();
            $color = $desempeno->hex2rgb($nivel->color);
        }

        $Excel->setActiveSheetIndex('0');

        if(isset($grupo))
        {
            $filename = "R718-Sabana-Notas-Acumulado-Grupo(".date("d-m-Y_H-i").").xlsx";
        }    
        else
        {
            $filename = "R718-Sabana-Notas-Acumulado-Grado(".date("d-m-Y_H-i").").xlsx";
        } 

        

        // Redirect output to a client’s web browser (Xlsx)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

         
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $writer = IOFactory::createWriter($Excel, 'Xlsx');
        $writer->save('php://output');
        exit;
    }  

}
