<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\Comportamiento;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;
use backend\models\Calificacioncalificaciones;
use backend\models\Promedio;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte719Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            $model->reporte = Yii::t('app', 'R719-Reporte');
            $model->observaciones = Yii::t('app', 'R719-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                //$periodo = $model->periodo;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            //$periodo = Yii::$app->request->get('periodo');
            $size_font = 7;
            $ver_colores = 1;
            $size_font = 7;
            $alto = 3;
            
        }

        list($condicionpromocion) = Yii::$app->createController('condicionpromocion');
        $condicionpromocion->actionComprobar($grupo);
                

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $grupo = Grupo::find()->where(['id' => $grupo])->one();

        $tipo_calificacion = $grupo->grados->tipo_calificacion;

        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R719-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
        
        $sede = Sede::FindOne($grupo->sede);



        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 32,
                         'margin_bottom' => 18,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => 'P']);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);
    
        if($ver_fecha == 1)
        {
            $fecha = strftime("%A, %d de %B de %Y");
            $pdf->setX(200);
            $pdf->SetFont('helvetica','',$size_font);
            $pdf->Cell(60,$alto + 2,$fecha,0,0,'R');
            $pdf->Ln($alto + 2);    
        }    
        
        $pdf->SetFont('Helvetica','B',$size_font + 2);   
        $pdf->Cell(250,$alto + 2,Yii::t('app', 'R719-LIBRO FINAL'),0,0,'C',0);

        $pdf->Ln($alto + 2);        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Sede'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(55,$alto + 2,$grupo->sedes->sede,0,0);

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Jornada'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(20,$alto + 2,$grupo->jornadas->jornada,0,0);  

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(12,$alto + 2,Yii::t('app', 'Grupo'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(25,$alto + 2,$grupo->grupo,0,0);
/*
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(13,$alto + 2,Yii::t('app', 'Periodo'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(8,$alto + 2,$periodo,0,0);
*/        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(10,$alto + 2,Yii::t('app', 'Año'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(8,$alto + 2,$sede->vigencia,0,0);

        $pdf->Ln(60);

        $pdf->setFillColor(230);
        $pdf->SetFont('Helvetica','B',$size_font - 2);

        $pdf->Cell(5,$alto + 2,Yii::t('app', '#'),1,0,'J',1);
        $pdf->Cell(50,$alto + 2,mb_strtoupper(Yii::t('app', 'Estudiante')),1,0,'C',1);

        $asignaturas = Asignatura::find()->where(['grado' => $grupo->grados->id])->all();

        $pdf->Ln($alto + 2);

        $pdf->setX(70);

        foreach ($asignaturas as $asignatura) 
        {
            $pdf->SetFont('Helvetica','B',$size_font);
            //$pdf->Cell(8,$alto + 2,mb_strtoupper(substr($asignatura->codigo,0,5)),1,0,'C',1); 

            $pdf->StartTransform();
            $pdf->Rotate(90);
            $pdf->Cell(50,$alto + 3,mb_strtoupper(substr($asignatura->asignatura,0,30)),1,0,'C',1); 
            $pdf->Cell(8,$alto + 3,mb_strtoupper('IH '.$asignatura->intensidad),1,0,'C',1); 
            $pdf->StopTransform();
            
            
            $pdf->setX($pdf->x-51);
        
        }
        //$pdf->setX($pdf->x-42);
        //$pdf->setXY(($pdf->x),($pdf->y-$alto-2));

        $pdf->SetFont('Helvetica','B',$size_font);
        
        $pdf->StartTransform();
        $pdf->Rotate(90);
        $pdf->Cell(50,$alto + 3,mb_strtoupper(Yii::t('app', 'APROBADO')),1,0,'C',1); 
        $pdf->StopTransform();
        $pdf->setX($pdf->x-43);

        $pdf->StartTransform();
        $pdf->Rotate(90);
        $pdf->Cell(50,$alto + 3,mb_strtoupper(Yii::t('app', 'REPROBADO')),1,0,'C',1); 
        $pdf->StopTransform();
        $pdf->setX($pdf->x-43);

        $pdf->setY($pdf->y);

        //$pdf->Ln($alto + 2);
        $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad','academico.aprobo'])->joinWith(['estudiantes'])->andWhere(['academico.grupo' => $grupo->id])->andWhere(['tercero.eliminado_por' => 0])->andWhere(['academico.eliminado_por' => 0])->orderBy(['tercero.estado' => SORT_ASC, 'primer_apellido' => SORT_ASC])->all();  
        
        $x=1;

        foreach ($estudiantes as $estudiante) 
        {
            $perdidas = 0;
            $ganadas = 0;

            $pdf->setFillColor(255);
            $pdf->SetFont('Helvetica','',$size_font);  

            $pdf->Cell(5,$alto,$x,1,0,'J',0);
            $pdf->Cell(50,$alto,mb_strtoupper($estudiante->estudiantes->nombreinverso),1,0,'J',0);
            
            $total_asignaturas = count($asignaturas) + 2;

            if($estudiante->estudiantes->estado >= '3')
            {
                $pdf->Cell(($total_asignaturas * 7),$alto,mb_strtoupper($estudiante->estudiantes->estados->estado),1,0,'C',0);    
                $x++;
            }
            else
            {
                $x++;
                foreach ($asignaturas as $asignatura) 
                {
                    $calificacion = Calificacion::find()
                            ->where(['estudiante' => $estudiante->id])
                            ->andWhere(['grupo' => $grupo->id])
                            ->andWhere(['asignatura' => $asignatura->id])
                            ->andWhere(['periodo' => '5'])
                            ->one();

                    if(isset($calificacion))
                    {


                        $desempeno = new Desempeno();
                        
                        $color = $desempeno->hex2rgb($desempeno->color($calificacion->definitiva_final_periodo,$tipo_calificacion));
                        
                        if($ver_colores == 1)
                        {
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                        }                

                        if($tipo_calificacion == 1) // TIPO DE CALIFICACION LETRAS
                        {   
                            $nota = ($calificacion->definitiva_final_periodo == '') ? 'NE' : $calificacion->definitiva_final_periodo;
                        }
                        else
                        {
                           // $perdido = Desempeno::find()->where(['nota' => $calificacion->definitiva_final_periodo])->andWhere(['tipo_calificacion' => $tipo_calificacion])->one();
                        }

                        
                        if($ver_letrasonumeros == 1) // LETRAS
                        {
                            $desempenos = $desempeno->nota($calificacion->definitiva_final_periodo, $tipo_calificacion);
                            $pdf->Cell(7,$alto,$desempenos,'LBTR',0,'C',1);
                            //$desempenos = $desempeno->nota($calificacion->definitiva_final_periodo,$tipo_calificacion);
                            //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                        }
                        else // NUMEROS
                        { 
                            $pdf->Cell(7,$alto,$calificacion->definitiva_final_periodo == 0 ? '': $calificacion->definitiva_final_periodo,'LBTR',0,'C',1); 
                            //$desempenos = $desempeno->nota($calificacion->definitiva_final_periodo,$tipo_calificacion);
                            //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                        }    
                        
                        $pdf->setFillColor(255); 
                    }
                    else
                    {
                        $desempeno = new Desempeno();
                        $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                        $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                        
                        if($ver_colores == 1)
                        {
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                        }    
                        
                        $pdf->Cell(7,$alto,'','LBTR',0,'C',1);
                        $pdf->setFillColor(255);
                    } 
                } 


                

                $pdf->Cell(7,$alto,($estudiante->aprobo == '1') ? Yii::t('app', 'X') : '',1,0,'C',0); 
                $pdf->Cell(7,$alto,($estudiante->aprobo == '0') ? Yii::t('app', 'X') : '',1,0,'C',0); 
                
            }

            $pdf->Ln($alto);
               
                
        }



            $pdf->Ln(8);

            $pdf->SetFont('Helvetica','',$size_font);
            //$pdf->Ln(8);
            //$pdf->Cell(180,6,"En constancia de entrega y publicación del informe valorativo y en constancia firmamos. ",0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);

            $y = $pdf->y;
            $x = $pdf->x;

            if($director_firma != '' or $director_firma != NULL )
            {
                $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$director_firma),$x+30,$y,50);    
            }    
            
            
            $pdf->Image(\Yii::getAlias('@web/uploads/'.$grupo->sedes->rector_firma),$x+105,$y,50);
            
            $pdf->setY($pdf->y-15);
            $pdf->Cell(30);
            $pdf->Cell(60,5,$director_nombre,'T',0,'C',0);

            $pdf->Cell(15);
            $pdf->Cell(60,5,$grupo->sedes->rector_nombre,'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(25);
            $pdf->Cell(60,5,Yii::t('app', 'Director(a)'),'',0,'C',0);
            $pdf->Cell(15);
            $pdf->Cell(60,5,Yii::t('app', 'Rector(a)'),'',0,'C',0);
            $pdf->Ln(1); 


        $pdf->Output("R719-Libro-Final-Grupo(".date("d-m-Y_H-i").").pdf",'D');
    }  

}
