<?php

namespace backend\controllers;

use Yii;
use backend\models\Sede;
use backend\models\Grupo;
use backend\models\Matricula;
use backend\models\Pais;
use backend\models\Tercero;

use backend\models\LanzadorForm;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte901Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'sede']);

            $model->reporte = Yii::t('app', 'R901-Reporte');
            $model->observaciones = Yii::t('app', 'R901-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {
                $sede = $model->sede;

                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => false,
                            'grupo' => false,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                            'ver_parametros' => true,
                            'multiple_grado' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => false,
                            'grupo' => false,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                            'ver_parametros' => true,
                            'multiple_grado' => true,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $sede = Yii::$app->request->get('sede');
            $size_font = 7;
            $ver_colores = 1;
            $size_font = 7;
            $alto = 3;
            
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");
        
        $sede = Sede::FindOne($sede);
        

        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 35,
                         'margin_bottom' => 20,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => 'P']);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);
    
        if($ver_fecha == 1)
        {
            $fecha = strftime("%A, %d de %B de %Y");
            $pdf->setX(200);
            $pdf->SetFont('helvetica','',$size_font);
            $pdf->Cell(60,$alto + 2,$fecha,0,0,'R');
            $pdf->Ln($alto + 2);    
        }    
        

        $pdf->SetFont('Helvetica','B',$size_font + 2);   
        $pdf->Cell(185,$alto + 2,Yii::t('app', 'R717-CONSOLIDADO'),0,0,'C',0);

        $pdf->Ln($alto + 2);        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(50,$alto + 2,Yii::t('app', 'Total de Estudiantes Matriculados'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        
        $matriculados = Matricula::find()->where(['estado' => '1'])->orderBy(['grupo' => SORT_ASC])->all();
        $total = count($matriculados);

        $pdf->Cell(180,$alto + 2,$total,0,0);

        $pdf->Ln($alto + 2);

        if($ver_colores == '1')
        {
            $pdf->setFillColor(230);    
        }
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(5,$alto + 2,Yii::t('app', '#'),1,0,'J',1);
        $pdf->Cell(60,$alto + 2,mb_strtoupper(Yii::t('app', 'Grupo')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Hombre')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Mujer')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Nuevos')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Antiguos')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Total')),1,0,'C',1);
        
        $pdf->Ln($alto + 2);
        
        $grupos = Grupo::find()->where(['estado' => '1'])->orderBy(['id' => SORT_ASC])->all();

        $x=1;

        foreach ($grupos as $grupo) 
        {
            
            $pdf->setFillColor(255);
            $pdf->SetFont('Helvetica','B',$size_font);
            
            //$pdf->Cell(5,$alto,$x,1,0,'J',0);
            $pdf->Cell(5,$alto,$grupo->id,1,0,'J',0);
            $pdf->Cell(60,$alto,mb_strtoupper($grupo->grupo),1,0,'J',0);

            $pdf->SetFont('Helvetica','',$size_font);  

            $total_m = Matricula::find()
                     ->joinWith(['estudiantes'])
                     ->where(['tercero.estado' => '1'])
                     ->andWhere(['tercero.genero' => 'M'])
                     ->andWhere(['matricula.grupo' => $grupo->id])
                     ->count();
        
            $pdf->Cell(20,$alto,$total_m,'LBTR',0,'C',1);

            $total_f = Matricula::find()
                     ->joinWith(['estudiantes'])
                     ->where(['tercero.estado' => '1'])
                     ->andWhere(['tercero.genero' => 'F'])
                     ->andWhere(['matricula.grupo' => $grupo->id])
                     ->count();
        
            $pdf->Cell(20,$alto,$total_f,'LBTR',0,'C',1);

            
            $new = Matricula::find()
                     ->joinWith(['estudiantes'])
                     ->where(['tercero.estado' => '1'])
                     ->andWhere(['matricula.grupo' => $grupo->id])
                     ->andWhere(['!=','matricula.creado_por', '0'])
                     ->count();

            $pdf->Cell(20,$alto,$new,'LBTR',0,'C',1);

            $old = Matricula::find()
                     ->joinWith(['estudiantes'])
                     ->where(['tercero.estado' => '1'])
                     ->andWhere(['matricula.grupo' => $grupo->id])
                     ->andWhere(['matricula.creado_por' => '0'])
                     ->count();

            $pdf->Cell(20,$alto,$old,'LBTR',0,'C',1);

            $total = $total_m + $total_f;

            if($ver_colores == '1')
            {
                $pdf->setFillColor(230);    
            }
            
            $pdf->Cell(20,$alto,$total,'LBTR',0,'C',1);

            $pdf->Ln($alto);

            $x++;
                
        }

        $query2 = "SELECT grupo.grupo, COUNT(matricula.id) as matriculados 
                   FROM grupo LEFT JOIN matricula ON grupo.id = matricula.grupo
                   GROUP BY grupo.id
                   ORDER BY grupo.grado ASC, grupo.grupo ASC";


        $matriculados = Grupo::findbySql($query2)->asArray()->all();

        $query3 = "SELECT grupo.grupo, (SELECT COUNT(matricula.id) as matriculados
                   FROM tercero LEFT JOIN matricula ON tercero.id = matricula.estudiante
                   WHERE matricula.grupo = grupo.id 
                   AND tercero.tipo_tercero = 1
                   AND tercero.genero = 'M') AS 'Masculino',
                   (SELECT COUNT(matricula.id) as matriculados
                   FROM tercero LEFT JOIN matricula ON tercero.id = matricula.estudiante
                   WHERE matricula.grupo = grupo.id
                   AND tercero.tipo_tercero = 1
                   AND tercero.genero = 'F') AS 'Femenino'
                   FROM grupo LEFT JOIN matricula ON grupo.id = matricula.grupo
                   GROUP BY grupo.id
                   ORDER BY grupo.grado ASC, grupo.grupo ASC;";
        

        $matriculadosxgeneroxgrupo = Grupo::findbySql($query3)->asArray()->all();

        $query4 = "SELECT 'Géneros', (SELECT COUNT(matricula.id) as matriculados
                   FROM tercero LEFT JOIN matricula ON tercero.id = matricula.estudiante
                   WHERE tercero.tipo_tercero = 1
                   AND tercero.genero = 'M') AS 'Masculino',
                   (SELECT COUNT(matricula.id) as matriculados
                   FROM tercero LEFT JOIN matricula ON tercero.id = matricula.estudiante
                   WHERE tercero.tipo_tercero = 1
                   AND tercero.genero = 'F') AS 'Femenino'";
        

        $generos = Tercero::findbySql($query4)->asArray()->all();
        
        $query5 = "SELECT tercero.pais, COUNT(matricula.id) as matriculados 
                   FROM tercero LEFT JOIN matricula ON tercero.id = matricula.estudiante
                   WHERE tercero.tipo_tercero = 1
                   GROUP BY tercero.pais
                   ORDER BY tercero.pais ASC";

        $nacionalidades = Tercero::findbySql($query5)->asArray()->all();

        $total_matriculados = Matricula::find()->count();

        
        $pdf->WriteHtml($this->renderPartial('grafica_matriculados',[
            'matriculados' => $matriculados,
            'matriculadosxgeneroxgrupo' => $matriculadosxgeneroxgrupo,
            'generos' => $generos,
            'nacionalidades' => $nacionalidades,
            'total_matriculados' => $total_matriculados,
            ]));



        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);
    

        $pdf->SetFont('Helvetica','B',$size_font + 2);   
        $pdf->Cell(185,$alto + 2,Yii::t('app', 'R717-Consolidado por Países'),0,0,'C',0);

        $pdf->Ln($alto + 2);        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(50,$alto + 2,Yii::t('app', 'Total de Estudiantes Matriculados'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        
        $matriculados = Matricula::find()->where(['estado' => '1'])->orderBy(['grupo' => SORT_ASC])->all();
        $total = count($matriculados);

        $pdf->Cell(180,$alto + 2,$total,0,0);

        $pdf->Ln($alto + 2);

        if($ver_colores == '1')
        {
            $pdf->setFillColor(230);    
        }
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(5,$alto + 2,Yii::t('app', '#'),1,0,'J',1);
        $pdf->Cell(60,$alto + 2,mb_strtoupper(Yii::t('app', 'Nacionalidad')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Hombre')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Mujer')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Total')),1,0,'C',1);
        
        $pdf->Ln($alto + 2);
        
        $paises = Pais::find()->where(['estado' => '1'])->orderBy(['codigo' => SORT_ASC])->all();

        $x=1;

        foreach ($paises as $pais) 
        {
            $total_pais = Matricula::find()
                         ->joinWith(['estudiantes'])
                         ->where(['tercero.estado' => '1'])
                         ->andWhere(['tercero.pais' => $pais->codigo])
                         ->count();

            if($total_pais > 0)
            {
                
                $pdf->setFillColor(255);
                $pdf->SetFont('Helvetica','B',$size_font);
                
                //$pdf->Cell(5,$alto,$x,1,0,'J',0);
                $pdf->Cell(5,$alto,mb_strtoupper($pais->codigo),1,0,'C',0);
                $pdf->Cell(60,$alto,mb_strtoupper($pais->pais),1,0,'J',0);

                $pdf->SetFont('Helvetica','',$size_font);  

                $total_m = Matricula::find()
                         ->joinWith(['estudiantes'])
                         ->where(['tercero.estado' => '1'])
                         ->andWhere(['tercero.genero' => 'M'])
                         ->andWhere(['tercero.pais' => $pais->codigo])
                         ->count();
            
                $pdf->Cell(20,$alto,$total_m,'LBTR',0,'C',1);

                $total_f = Matricula::find()
                         ->joinWith(['estudiantes'])
                         ->where(['tercero.estado' => '1'])
                         ->andWhere(['tercero.genero' => 'F'])
                         ->andWhere(['tercero.pais' => $pais->codigo])
                         ->count();
            
                $pdf->Cell(20,$alto,$total_f,'LBTR',0,'C',1);


                $total = $total_m + $total_f;

                if($ver_colores == '1')
                {
                    $pdf->setFillColor(230);    
                }
                
                $pdf->Cell(20,$alto,$total,'LBTR',0,'C',1);

                $pdf->Ln($alto);

                $x++;
            }
                
        }


        $pdf->Ln($alto + 2);        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(50,$alto + 2,Yii::t('app', 'Total de Estudiantes Matriculados'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        
        $matriculados = Matricula::find()->where(['estado' => '1'])->orderBy(['grupo' => SORT_ASC])->all();
        $total = count($matriculados);

        $pdf->Cell(180,$alto + 2,$total,0,0);

        $pdf->Ln($alto + 2);

        if($ver_colores == '1')
        {
            $pdf->setFillColor(230);    
        }
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(5,$alto + 2,Yii::t('app', '#'),1,0,'J',1);
        $pdf->Cell(10,$alto + 2,Yii::t('app', 'COD'),1,0,'J',1);
        $pdf->Cell(60,$alto + 2,mb_strtoupper(Yii::t('app', 'Nacionalidad')),1,0,'C',1);
        $pdf->Cell(40,$alto + 2,mb_strtoupper(Yii::t('app', 'Grupo')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Hombre')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Mujer')),1,0,'C',1);
        $pdf->Cell(20,$alto + 2,mb_strtoupper(Yii::t('app', 'Total')),1,0,'C',1);
        
        $pdf->Ln($alto + 2);
        
        $paises = Pais::find()->where(['estado' => '1'])->orderBy(['codigo' => SORT_ASC])->all();

        $x=1;

        foreach ($paises as $pais) 
        {
            
            $total_pais = Matricula::find()
                         ->joinWith(['estudiantes'])
                         ->where(['tercero.estado' => '1'])
                         ->andWhere(['tercero.pais' => $pais->codigo])
                         ->count();

            if($total_pais > 0)
            {
                $grupos = Grupo::find()->where(['estado' => '1'])->orderBy(['id' => SORT_ASC])->all();

                foreach ($grupos as $grupo) 
                {
                    $pdf->setFillColor(255);
                    $pdf->SetFont('Helvetica','B',$size_font);
                    
                    $pdf->Cell(5,$alto,$x,1,0,'J',0);
                    $pdf->Cell(10,$alto,mb_strtoupper($pais->codigo),1,0,'C',0);
                    $pdf->Cell(60,$alto,mb_strtoupper($pais->pais),1,0,'J',0);
                    $pdf->Cell(40,$alto,mb_strtoupper($grupo->grupo),1,0,'C',0);

                    $pdf->SetFont('Helvetica','',$size_font);  

                    $total_m = Matricula::find()
                             ->joinWith(['estudiantes'])
                             ->where(['tercero.estado' => '1'])
                             ->andWhere(['tercero.genero' => 'M'])
                             ->andWhere(['tercero.pais' => $pais->codigo])
                             ->andWhere(['matricula.grupo' => $grupo->id])
                             ->count();
                
                    $pdf->Cell(20,$alto,$total_m,'LBTR',0,'C',1);

                    $total_f = Matricula::find()
                             ->joinWith(['estudiantes'])
                             ->where(['tercero.estado' => '1'])
                             ->andWhere(['tercero.genero' => 'F'])
                             ->andWhere(['tercero.pais' => $pais->codigo])
                             ->andWhere(['matricula.grupo' => $grupo->id])
                             ->count();
                
                    $pdf->Cell(20,$alto,$total_f,'LBTR',0,'C',1);


                    $total = $total_m + $total_f;

                    if($ver_colores == '1')
                    {
                        $pdf->setFillColor(230);    
                    }
                    
                    $pdf->Cell(20,$alto,$total,'LBTR',0,'C',1);

                    $pdf->Ln($alto);

                    $x++; 
                } 
            }
                
        }

        $pdf->AddPage();

        

        $pdf->SetFont('Helvetica','B',$size_font + 2);   
        $pdf->Cell(185,$alto + 2,Yii::t('app', 'R717-MATRICULADOS'),0,0,'C',0);

        $pdf->Ln($alto + 2);        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(50,$alto + 2,Yii::t('app', 'Total de Estudiantes Matriculados'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        
        $total = count($matriculados);

        $pdf->Cell(180,$alto + 2,$total,0,0);

        $pdf->Ln($alto + 2);
        
        if($ver_colores == '1')
        {
            $pdf->setFillColor(230);    
        }
        
        $pdf->SetFont('Helvetica','B',$size_font - 2);
        $pdf->Cell(5,$alto + 2,Yii::t('app', '#'),1,0,'J',1);
        $pdf->Cell(120,$alto + 2,mb_strtoupper(Yii::t('app', 'Estudiante')),1,0,'C',1);


        $pdf->Cell(30,$alto + 2,mb_strtoupper(Yii::t('app', 'Grupo')),1,0,'C',1);
        $pdf->Cell(30,$alto + 2,mb_strtoupper(Yii::t('app', 'Fecha')),1,0,'C',1);
        
        $pdf->Ln($alto + 2);
        
        $x=1;


        $grupo_actual = '';

        foreach ($matriculados as $matriculado) 
        {
            
            if($grupo_actual != $matriculado->grupos->grupo)
            {

                if($ver_colores == '1')
                {
                    $pdf->setFillColor(230);    
                }

                $pdf->SetFont('Helvetica','B',$size_font-2); 
                $pdf->Cell(185,$alto,mb_strtoupper(Yii::t('app', 'Grupo').' '.$matriculado->grupos->grupo),1,0,'C',1); 
                $pdf->Ln($alto);
            }

            $pdf->setFillColor(255);
            $pdf->SetFont('Helvetica','',$size_font-2);  


            $pdf->Cell(5,$alto,$x,1,0,'J',0);
            $pdf->Cell(120,$alto,mb_strtoupper($matriculado->estudiantes->nombre),1,0,'J',0);
        
        
            $pdf->Cell(30,$alto,mb_strtoupper($matriculado->grupos->grupo),'LBTR',0,'C',1);
            $pdf->Cell(30,$alto,mb_strtoupper($matriculado->fecha_matricula),'LBTR',0,'C',1);

            $grupo_actual = $matriculado->grupos->grupo;

            $pdf->Ln($alto);

            $x++;
                
        }

                

        $pdf->Output("R717-Matriculados(".date("d-m-Y_H-i").").pdf",'D');
    }  

}
