<?php

namespace backend\controllers;

use Yii;
use backend\models\Authitem;

use yii\web\Controller;
use yii\helpers\Html;
use yii\helpers\Url;


class ReporteController extends Controller
{
    
    public function actionIndex() 
    {
        $model = new Authitem();
        
        return $this->render('index', [
            'model' => $model
        ]);  

    }

    public function actionBuscar($query = '')
    {
        $output = '';

        if(isset($_POST["query"]))
        {
            $search = $_POST["query"];
            
            $reportes = Authitem::find()
                        ->where(['like', 'name', 'Reporte%', false])
                        ->andWhere(['like', 'description', $search])
                        ->orderBy(['name' => SORT_ASC])
                        ->all();

            //return $reportes->createCommand()->getRawSql(); // Mostrar SQL   
        }
        else
        {
            $reportes = Authitem::find()
                        ->where(['like', 'name', 'Reporte%', false])
                        ->orderBy(['name' => SORT_ASC])
                        ->all();
        }

        if(count($reportes) > 0)
        {
            $output .= '
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead class="thead-light">
                            <tr>
                                 <th class="hidden-xs">#</th>
                                 <th>Reporte</th>
                                 <th class="hidden-xs">Descripción</th>
                                 <th>Acciones</th>
                            </tr>
                        </thead>    
             ';

            foreach ($reportes as $reporte) 
            {
                $output .= '<tr>';
                $output .= '<td class="hidden-xs">'.Html::a(substr($reporte->name,8,3),false,['value' => Url::to([$reporte->authItemChildren->child]), 'title' => substr($reporte->name,14), 'data-toggle' => 'tooltip', 'class' => 'showModalButton', 'style' => 'cursor: pointer;']).'</td>';
                $output .= '<td>'.Html::a(substr($reporte->name,14),false,['value' => Url::to([$reporte->authItemChildren->child]), 'title' => substr($reporte->name,14), 'data-toggle' => 'tooltip', 'class' => 'showModalButton', 'style' => 'cursor: pointer;']).'</td>';
                $output .= '<td class="hidden-xs">'.Html::a($reporte->description,false,['value' => Url::to([$reporte->authItemChildren->child]), 'title' => substr($reporte->name,14), 'data-toggle' => 'tooltip', 'class' => 'showModalButton', 'style' => 'cursor: pointer;']).'</td>';
                $output .= '<td align="center">'.Html::button('<i class="fa fa-rocket" aria-hidden="true"></i> <span class="hidden-xs">Lanzar</span>', ['value' => Url::to([$reporte->authItemChildren->child]), 'title' => substr($reporte->name,14), 'data-toggle' => 'tooltip', 'class' => 'showModalButton btn btn-xs btn-warning']).'</td>';  
                $output .= '</tr>';
            }
            return $output;
        }
        else
        {
            return '<center><h4>No Encontrado</h4></center>';
        }
    }


}