<?php
namespace backend\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use common\models\LoginForm;
use yii\filters\VerbFilter;
use yii\data\SqlDataProvider;
use yii\web\Response;
use yii\widgets\ActiveForm;
use yii\db\Expression;


use common\models\User;
use backend\models\Sede;
use backend\models\Agenda;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Asistencia;
use backend\models\Carga;
use backend\models\Mensajes;
use backend\models\CargaSearch;
use backend\models\Periodo;
use backend\models\Tercero;
use backend\models\Academico;
use backend\models\Matricula;
use backend\models\TerceroForm;
use backend\models\PasswordResetRequestForm;
use backend\models\ResetPasswordForm;


//use backend\models\SignupForm;
use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;


/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout', 'signup'],
                'rules' => [
                    [
                        'actions' => ['signup'],
                        'allow' => true,
                        'roles' => ['?'],
                    ],
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    public function actionIndex($tercero=null)
    {

        $sede = Sede::find()->where(['principal' => '1'])->one();
        $tercero = new TerceroForm();
        $periodo = new Periodo;

        if (Yii::$app->request->isAjax && $tercero->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($tercero);
        }

        $tercero->load(Yii::$app->request->post());
        

        switch (Yii::$app->session->get('__tipo')) {
            case '1':
                    //Yii::$app->user->logout();
                    //return $this->redirect('../../site/login');
                    return $this->redirect(['estudiante/index']);
                break;
            case '2':    
                    return $this->redirect(['docente/index']);
                break;
            
        }  

        $query1 = "SELECT g1.grupo, 
                  (SELECT SUM(a2.fallas) FROM grupo g2 LEFT JOIN asistencia a2 ON g2.id = a2.grupo 
                  WHERE DATE(a2.fecha)=CURDATE()
                  AND g2.jornada = 2 
                  AND g2.grupo = g1.grupo) as 'Mañana',
                  (SELECT SUM(a3.fallas) FROM grupo g3 LEFT JOIN asistencia a3 ON g3.id = a3.grupo 
                  WHERE DATE(a3.fecha)=CURDATE()
                  AND g3.jornada = 3 
                  AND g3.grupo = g1.grupo) as 'Tarde'
                  from grupo g1
                  group by g1.grupo
                  order by g1.grupo ASC";


        $dataProvider = new SqlDataProvider([
            'sql' => $query1,
            'pagination' => false
        ]);


        if($sede->activar_matriculas  == 1)
        {
            
            $query2 = "SELECT grupo.grupo, COUNT(academico.id) as matriculados 
                       FROM grupo LEFT JOIN academico ON grupo.id = academico.grupo
                       WHERE academico.actualizado_el LIKE '2025%'
                       GROUP BY grupo.id
                       ORDER BY grupo.grado ASC, grupo.grupo ASC";

            
            $query3 = "SELECT grupo.grupo, (SELECT COUNT(academico.id) as matriculados
                       FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE academico.grupo = grupo.id 
                       AND academico.actualizado_el LIKE '2025%'
                       AND tercero.tipo_tercero = 1
                       AND tercero.genero = 'M') AS 'Masculino',
                       (SELECT COUNT(academico.id) as matriculados
                       FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE academico.grupo = grupo.id
                       AND academico.actualizado_el LIKE '2025%'
                       AND tercero.tipo_tercero = 1
                       AND tercero.genero = 'F') AS 'Femenino'
                       FROM grupo LEFT JOIN academico ON grupo.id = academico.grupo
                       GROUP BY grupo.id
                       ORDER BY grupo.grado ASC, grupo.grupo ASC;";

            $query4 = "SELECT 'Generos', (SELECT COUNT(academico.id) as matriculados
                       FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE tercero.tipo_tercero = 1
                       AND academico.actualizado_el LIKE '2025%'
                       AND tercero.genero = 'M') AS 'Masculino',
                       (SELECT COUNT(academico.id) as matriculados
                       FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE tercero.tipo_tercero = 1
                       AND academico.actualizado_el LIKE '2025%'
                       AND tercero.genero = 'F') AS 'Femenino'";
                        
            $query5 = "SELECT tercero.pais, COUNT(academico.id) as matriculados 
                       FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE tercero.tipo_tercero = 1
                       AND academico.actualizado_el LIKE '2025%'
                       GROUP BY tercero.pais
                       ORDER BY tercero.pais ASC";

            $query6 = NULL;
            
            $query7 = "SELECT (SELECT count(tercero.id)
                        FROM tercero 
                        WHERE id NOT IN (SELECT estudiante from academico WHERE eliminado_por = 0 AND academico.actualizado_el LIKE '2025%')
                        AND tipo_tercero = 1
                        AND eliminado_por = 0) AS 'nomatriculado',
                        (SELECT count(tercero.id)
                        FROM tercero 
                        WHERE id IN (SELECT estudiante from academico WHERE eliminado_por = 0 AND academico.actualizado_el LIKE '2025%')
                        AND tipo_tercero = 1
                        AND eliminado_por = 0) AS 'matriculado';";

            $total_matriculados = Academico::find()->where(new \yii\db\Expression('actualizado_el LIKE :term', [':term' => '2025' . '%']))->count();
            
          /*
            $query2 = "SELECT grupo.grupo, COUNT(matricula.id) as matriculados 
                       FROM grupo LEFT JOIN matricula ON grupo.id = matricula.grupo
                       GROUP BY grupo.id
                       ORDER BY grupo.grado ASC, grupo.grupo ASC";

            $query3 = "SELECT grupo.grupo, (SELECT COUNT(matricula.id) as matriculados
                       FROM tercero LEFT JOIN matricula ON tercero.id = matricula.estudiante
                       WHERE matricula.grupo = grupo.id 
                       AND tercero.tipo_tercero = 1
                       AND tercero.genero = 'M') AS 'Masculino',
                       (SELECT COUNT(matricula.id) as matriculados
                       FROM tercero LEFT JOIN matricula ON tercero.id = matricula.estudiante
                       WHERE matricula.grupo = grupo.id
                       AND tercero.tipo_tercero = 1
                       AND tercero.genero = 'F') AS 'Femenino'
                       FROM grupo LEFT JOIN matricula ON grupo.id = matricula.grupo
                       GROUP BY grupo.id
                       ORDER BY grupo.grado ASC, grupo.grupo ASC;";

            $query4 = "SELECT 'Generos', (SELECT COUNT(matricula.id) as matriculados
                       FROM tercero LEFT JOIN matricula ON tercero.id = matricula.estudiante
                       WHERE tercero.tipo_tercero = 1
                       AND tercero.genero = 'M') AS 'Masculino',
                       (SELECT COUNT(matricula.id) as matriculados
                       FROM tercero LEFT JOIN matricula ON tercero.id = matricula.estudiante
                       WHERE tercero.tipo_tercero = 1
                       AND tercero.genero = 'F') AS 'Femenino'";
                        
            $query5 = "SELECT tercero.pais, COUNT(matricula.id) as matriculados 
                       FROM tercero LEFT JOIN matricula ON tercero.id = matricula.estudiante
                       WHERE tercero.tipo_tercero = 1
                       GROUP BY tercero.pais
                       ORDER BY tercero.pais ASC";

            $query6 = NULL;
            $query7 = NULL;

            $total_matriculados = Matricula::find()->count();*/
        }
        else
        {

            $query2 = "SELECT grupo.grupo, COUNT(academico.id) as matriculados 
                       FROM grupo 
                       LEFT JOIN academico ON grupo.id = academico.grupo
                       LEFT JOIN tercero ON tercero.id = academico.estudiante
                       WHERE academico.fecha_retiro is null
                       AND academico.eliminado_por = 0
                       AND tercero.eliminado_por = 0
                       GROUP BY grupo.id
                       ORDER BY grupo.grado ASC, grupo.grupo ASC";

            $query3 = "SELECT grupo.grupo, (SELECT COUNT(academico.id) as matriculados
                       FROM tercero 
                       LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE academico.grupo = grupo.id 
                       AND tercero.tipo_tercero = 1
                       AND academico.fecha_retiro is null
                       AND academico.eliminado_por = 0
                       AND tercero.eliminado_por = 0
                       AND tercero.genero = 'M') AS 'Masculino',
                       (SELECT COUNT(academico.id) as matriculados
                       FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE academico.grupo = grupo.id
                       AND tercero.tipo_tercero = 1
                       AND academico.fecha_retiro is null
                       AND academico.eliminado_por = 0
                       AND tercero.eliminado_por = 0
                       AND tercero.genero = 'F') AS 'Femenino'
                       FROM grupo LEFT JOIN academico ON grupo.id = academico.grupo
                       GROUP BY grupo.id
                       ORDER BY grupo.grado ASC, grupo.grupo ASC;";

            $query4 = "SELECT 'Generos', (SELECT COUNT(academico.id) as matriculados
                       FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE tercero.tipo_tercero = 1
                       AND academico.fecha_retiro is null
                       AND academico.eliminado_por = 0
                       AND tercero.eliminado_por = 0
                       AND tercero.genero = 'M') AS 'Masculino',
                       (SELECT COUNT(academico.id) as academico
                       FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE tercero.tipo_tercero = 1
                       AND academico.fecha_retiro is null
                       AND academico.eliminado_por = 0
                       AND tercero.eliminado_por = 0
                       AND tercero.genero = 'F') AS 'Femenino'";
            
                        ///BORRADO
                            $query4 = "SELECT tercero.genero, COUNT(academico.id) as matriculados
                                    FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                                    WHERE tercero.tipo_tercero = 1
                                    GROUP BY tercero.genero
                                    ORDER BY tercero.genero ASC";
                                       
            $query5 = "SELECT tercero.pais, COUNT(academico.id) as matriculados 
                       FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE tercero.tipo_tercero = 1
                       AND academico.fecha_retiro is null
                       AND academico.eliminado_por = 0
                       AND tercero.eliminado_por = 0
                       GROUP BY tercero.pais
                       ORDER BY tercero.pais ASC";

            $query6 = "SELECT grupo.grupo, (SELECT COUNT(academico.id) as matriculados
                       FROM tercero 
                       LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE academico.grupo = grupo.id 
                       AND tercero.tipo_tercero = 1
                       AND academico.fecha_retiro is null
                       AND academico.eliminado_por = 0
                       AND tercero.eliminado_por = 0
                       AND academico.aprobo = '1') AS 'Aprobados',
                       (SELECT COUNT(academico.id) as matriculados
                       FROM tercero LEFT JOIN academico ON tercero.id = academico.estudiante
                       WHERE academico.grupo = grupo.id
                       AND tercero.tipo_tercero = 1
                       AND academico.fecha_retiro is null
                       AND academico.eliminado_por = 0
                       AND tercero.eliminado_por = 0
                       AND academico.aprobo != '1') AS 'Reprobados'
                       FROM grupo LEFT JOIN academico ON grupo.id = academico.grupo
                       GROUP BY grupo.id
                       ORDER BY grupo.grado ASC, grupo.grupo ASC;";

            $query7 = "SELECT (SELECT count(tercero.id)
                        FROM tercero 
                        WHERE id NOT IN (SELECT estudiante from academico WHERE eliminado_por = 0)
                        AND tipo_tercero = 1
                        AND eliminado_por = 0) AS 'nomatriculado',
                        (SELECT count(tercero.id)
                        FROM tercero 
                        WHERE id IN (SELECT estudiante from academico WHERE eliminado_por = 0)
                        AND tipo_tercero = 1
                        AND eliminado_por = 0) AS 'matriculado';";

            $total_matriculados = Academico::find()->where(['is','fecha_retiro', null])->andWhere(['eliminado_por' => '0'])->count();
            
        }

        $query_ausentismo = "SELECT g1.grupo, 
                            (SELECT SUM(a2.fallas) FROM grupo g2 LEFT JOIN asistencia a2 ON g2.id = a2.grupo 
                            WHERE DATE(a2.fecha)=CURDATE()
                            AND g2.jornada = 2 
                            AND g2.grupo = g1.grupo) as 'Mañana',
                            (SELECT SUM(a3.fallas) FROM grupo g3 LEFT JOIN asistencia a3 ON g3.id = a3.grupo 
                            WHERE DATE(a3.fecha)=CURDATE()
                            AND g3.jornada = 3 
                            AND g3.grupo = g1.grupo) as 'Tarde'
                            from grupo g1
                            group by g1.grupo
                            order by g1.grupo ASC";

        $ausentismo_hoy = Grupo::findbySql($query_ausentismo)->asArray()->all();


        $matriculados = Grupo::findbySql($query2)->asArray()->all();
        $matriculadosxgeneroxgrupo = Grupo::findbySql($query3)->asArray()->all();
        $generos = Tercero::findbySql($query4)->asArray()->all();
        $nacionalidades = Tercero::findbySql($query5)->asArray()->all();

        $aprobadosxgrupo = Grupo::findbySql($query6)->asArray()->all();

        $sinmatricular = Grupo::findbySql($query7)->asArray()->all();

        $bloqueados = Tercero::find()->joinWith(['academicos'])->where(['<', 'tercero.estado', 3])->andWhere(['tercero.bloqueo' => '1'])->andWhere(['tercero.eliminado_por' => '0'])->andWhere(['academico.eliminado_por' => '0'])->all();

        $query = "SELECT * FROM `agenda` WHERE NOW() BETWEEN fecha_inicio AND fecha_fin AND estado = 1";
        $eventos = Agenda::findbySql($query)->all();

        
        $ausentes = Asistencia::find()
                ->where(['DATE(fecha)' => new Expression('CURDATE()')])
                ->joinWith('estudiantes')
                //  ->groupby('estudiante')
                ->all();

        $huerfanos = Tercero::find()
                    ->joinWith(['academicos'])
                    ->where(['academico.id' => null])
                    ->andWhere(['tipo_tercero' => '1'])
                    ->orderBy('id')
                    ->all();

        $carteleras = Mensajes::find()->where(['remisor' => Yii::$app->session->get('__tercero')])->andWhere(['cartelera' => '1'])->andWhere(['eliminado_por' => '0'])->andWhere(['estado' => '1'])->all();
        
        $asignaturas = Asignatura::find()
                    ->where(['eliminado_por' => '0'])
                    ->orderBy(['grado' => SORT_ASC])
                    ->all();

        return $this->render('index',[
            'periodo' => $periodo,
            'tercero' => $tercero,
            'dataProvider' => $dataProvider,
            'ausentismo_hoy' => $ausentismo_hoy,
            'bloqueados' => $bloqueados,
            'asignaturas' => $asignaturas,
            'eventos' => $eventos,
            'ausentes' => $ausentes,
            'huerfanos' => $huerfanos,
            'matriculados' => $matriculados,
            'matriculadosxgeneroxgrupo' => $matriculadosxgeneroxgrupo,
            'generos' => $generos,
            'nacionalidades' => $nacionalidades,
            'aprobadosxgrupo' => $aprobadosxgrupo,
            'sinmatricular' => $sinmatricular,
            'total_matriculados' => $total_matriculados,
            'sede' => $sede,
            'carteleras' => $carteleras,
            ]);   
    }

    public function actionLogin()
    { 
        if (!\Yii::$app->user->isGuest) {
            return $this->goHome();
        }
     
        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            
            $bitacora = new \backend\models\Bitacora;
            $bitacora->Registrar('Inicia Sesión');
            
            if(!empty(Yii::$app->request->post('previous'))){
                return $this->redirect(Yii::$app->request->post('previous'));
            }
            else
            {

                    if (Yii::$app->session->get('__doc') == 'admin')
                    {
                        return $this->goBack();
                    }    
                        
                    switch (Yii::$app->session->get('__tipo')) {
                        case '1':
                                //Yii::$app->user->logout();

                                /*Yii::$app->session->addFlash('mensaje', [
                                    'tipo' => 'error',
                                    'titulo' => 'Accesso Prohibido',
                                    'icono' => 'fa fa-meh-o',
                                    'mensaje' => 'El usuario es un estudiante y no tiene acceso a esta área, será redirigido al área de estudiantes.',
                                ]);*/
                                //Yii::$app->getSession()->setFlash('error', 'El usuario es un estudiante y no tiene acceso a esta área, será redirigido al área de estudiantes.');
                                return $this->redirect(['estudiante/index']);
                            break;
                        case '2':    
                                return $this->redirect(['docente/index']);
                            break;
                        case '3':
                                return $this->goBack();
                            break;
                    }
                    

            }
        } else {
            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();

        $bitacora = new \backend\models\Bitacora;
        $bitacora->Registrar('Cerrar Sesión');
     

        return $this->goHome();
    
    }

    
    public function actionRequestPasswordReset()
    {
        $model = new PasswordResetRequestForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail()) {
                /*Yii::$app->session->addFlash('mensaje1', [
                                'tipo' => 'info',
                                'titulo' => 'Reestablecer Contraseña',
                                'icono' => 'fa fa-envelope-o',
                                'mensaje' => 'Se envió un enlace para reestablecer la contraseña a su correo electrónico, reviselo para obtener más instrucciones.',

                            ]);*/

                return $this->goHome();
            } else {
                Yii::$app->session->addFlash('mensaje1', [
                                'tipo' => 'danger',
                                'titulo' => 'Error Reestablecer Contraseña',
                                'icono' => 'fa fa-envelope-o',
                                'mensaje' => 'Lo sentimos, no podemos restablecer la contraseña del usuario proporcionado porque no tiene correo electrónico configurado, debes acercarte a la institución educativa para reestablecerla.',
                            ]);
            }
        }

        return $this->render('requestPasswordResetToken', [
            'model' => $model,
        ]);
    }

    public function actionResetPassword($token)
    {
        try {
            $model = new ResetPasswordForm($token);
        } catch (InvalidParamException $e) {
            throw new BadRequestHttpException($e->getMessage());
        }

        if ($model->load(Yii::$app->request->post()) && $model->validate() && $model->resetPassword()) {
            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Reestablecer Contraseña',
                                'icono' => 'fa fa-envelope-o',
                                'mensaje' => 'Contraseña Almacenada',
                            ]);

            return $this->goHome();
        }

        return $this->render('resetPassword', [
            'model' => $model,
        ]);
    }


    public function actionLockScreen($previous = NULL)
    {
        if(isset(Yii::$app->user->identity->username)){
            // save current username    
            $username = Yii::$app->user->identity->username;
            // force logout     
            // Yii::$app->user->logout();
            // render form lockscreen
            $model = new LoginForm(); 
            $model->username = $username;    //set default value 

            $bitacora = new \backend\models\Bitacora;
            $bitacora->Registrar('Sesión Bloqueada');

            return $this->render('lockScreen', [
                'model' => $model,
                'previous' => $previous,
            ]);  
        }
        else{
            return $this->redirect(['login']);
        }
    }

    public function actionVigencia($vigencia)
    {
        if (Yii::$app->request->isAjax) 
        {

            Yii::$app->db->dsn = substr(Yii::$app->db->dsn,0,-4).$vigencia;


            Yii::$app->session->set('__vigencia', $vigencia);

            Yii::$app->session->addFlash('mensaje1', [
                        'tipo' => 'info',
                        'titulo' => 'Cambio de Año Escolar',
                        'icono' => 'fa fa-clock',
                        'mensaje' => 'Se realizó el cambio de Año Escolar <b>'.$vigencia.'</b>.',
                    ]);

            return $vigencia;
        } else {
            throw new NotFoundHttpException('No puedo cambiar la vigencia');
        }
    }

}
