<?php

namespace backend\controllers;

use Yii;
use backend\models\Slide;
use backend\models\SlideSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use yii\helpers\FileHelper;


use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Image\Box;  

use yii\web\Response;

/**
 * SlideController implements the CRUD actions for Slide model.
 */
class SlideController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Slide models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SlideSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Slide model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Slide model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Slide();

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        elseif ($model->load(Yii::$app->request->post()))
        {
            $carpeta = Yii::getAlias('@frontend') . "/web/images";
            
            if (!is_dir($carpeta.'/slide')) 
            {
                if (FileHelper::createDirectory($carpeta.'/slide', $mode = 0775, $recursive = true)) 
                {
                    Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Carpeta Creada',
                        'icono' => 'far info',
                        'mensaje' => 'La Carpeta <b>slide</b> fue creada con éxito.',
                    ]);
                }
            }

            if($foto = UploadedFile::getInstance($model,'imagen'))
            {
                //$file = rand(10,100).'-'.str_replace(' ','-',$foto);
                $file = $foto;

                //$foto->saveAs( 'images/'.$file);
                $file->saveAs($carpeta.'/'.$file);
                
                Image::getImagine()->open($carpeta.'/'.$file)->thumbnail(new Box(1280, 1000))->save($carpeta.'/slide/'.$file , ['quality' => 80]);

                //save the path in DB..
                $model->imagen = $file;
                unlink($carpeta.'/'.$file);
            }


            if ($model->save()) 
            {
                \Yii::$app->session->addFlash('mensaje1', [
                                'tipo' => 'success',
                                'titulo' => 'Creación de Slide',
                                'icono' => 'fa fa-check',
                                'mensaje' => 'Se creo el slide '.$model->titulo.' éxitosamente.',
                            ]);
                
                return $this->redirect(['index']);
            }
            else
            {
                     var_dump($model->getErrors());
            }  

        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }


    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->loadAll(Yii::$app->request->post()) && $model->saveAll()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    
    public function actionDelete($id)
    {
        $model = Slide::findOne($id);

        if ($model->tipo == 1)
        {
            $file = Yii::getAlias('@frontend') . "/web/images/slide/".$model->imagen;
            unlink($file);    
        } 
        
        $model->delete();
            

        return $this->redirect(['index']);
    }

    
    /**
     * Finds the Slide model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Slide::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
