<?php

namespace backend\controllers;

use Yii;
use backend\models\Tarea;
use backend\models\Carga;
use backend\models\Academico;
use backend\models\TareaSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;

use backend\models\base\Upload;
use yii\web\UploadedFile;
use yii\helpers\Html;


/**
 * TareaController implements the CRUD actions for Tarea model.
 */
class TareaController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Tarea models.
     * @return mixed
     */
    public function actionIndex()
    {
        if(Yii::$app->session->get('__tipo') == 3)
        {
            $searchModel = new TareaSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
            $model = new Tarea();

            return $this->render('index', [
                'model' => $model,
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }
        else
        {
            return $this->redirect(['mistareas']);
        }
    }

    public function actionMistareas()
    {
        $model = new Tarea();
        $searchModel = new TareaSearch();
        
        if(Yii::$app->session->get('__tipo') == 2)
        {
            $searchModel->creado_por = Yii::$app->session->get('__id');
        }

        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('mistareas', [
            'model' => $model,
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionView($id)
    {
        $model = $this->findModel($id);

        
        if($model->asignaturas->especialidad == 1)
        {
            $query = Academico::find()->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $model->grupo])->orderBy('primer_apellido');  
        }
        else
        {
            $query = Academico::find()->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $model->grupo])->andWhere(['academico.especialidad' => $model->asignaturas->especialidad])->orderBy('primer_apellido');     
        }    
        

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 500,
            ],
        ]);

        return $this->render('view', [
            'model' => $model,
            'dataProvider' => $dataProvider,
        ]);
    }

    
    /*
    public function actionCreate()
    {
        $model = new Tarea();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }
    */

    public function actionCreate($asignatura = null, $grupo = null)
    {
        $model = new Tarea();
        $model->asignatura = $asignatura;
        $model->grupo = $grupo;

        $s3 = Yii::$app->get('s3');    
        
        if(!$s3->exist('tareas/'))
        {
            $s3->put('tareas/', null);    
        }

        if ($model->load(Yii::$app->request->post()) ) 
        {
            if($adjunto = UploadedFile::getInstance($model, 'adjunto'))
            {
                $id = Tarea::find()->max('id') + 1;


                if(!$s3->exist('tareas/'.$id.'/'))
                {
                    $s3->put('tareas/'.$id.'/', null); 
                }

                if(!$s3->exist('tareas/'.$id.'/'.Yii::$app->session->get('__tercero').'/'))
                {
                    $s3->put('tareas/'.$id.'/'.Yii::$app->session->get('__tercero').'/', null);    
                }

                $body = file_get_contents($adjunto->tempName);
                $model->adjunto = $s3->put('tareas/'.$id.'/'.Yii::$app->session->get('__tercero').'/'.$adjunto->name, $body);
            }

            $model->docente = (Yii::$app->session->get('__tercero')=='') ? NULL : Yii::$app->session->get('__tercero');
            
            $model->estado = '1';
            $model->save(false);                        
            
        
            \Yii::$app->session->addFlash('mail', [
                            'tipo' => 'success',
                            'titulo' => 'Tarea Creada',
                            'icono' => 'fa fa-envelope',
                            'mensaje' => 'Su tarea ha sido creada exitosamente!',
                        ]);

            return $this->redirect(['index']);

        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Tarea model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Tarea model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    
    /**
     * Finds the Tarea model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tarea the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Tarea::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for TareaDesarrollo
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddTareaDesarrollo()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('TareaDesarrollo');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formTareaDesarrollo', ['row' => $row]);
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
