<?php

namespace backend\controllers;

use Yii;
use backend\models\Tarea;
use backend\models\Tareadesarrollo;
use backend\models\TareadesarrolloSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\base\Upload;
use yii\web\UploadedFile;
use yii\web\Response;
use yii\widgets\ActiveForm;


/**
 * TareadesarrolloController implements the CRUD actions for Tareadesarrollo model.
 */
class TareadesarrolloController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Tareadesarrollo models.
     * @return mixed
     */
    public function actionIndex($id = null)
    {

        $searchModel = new TareadesarrolloSearch();

        if(Yii::$app->session->get('__tipo') == 1)
        {
            $searchModel->estudiante = Yii::$app->session->get('__tercero');
        }

        if(isset($id))
        {
            $searchModel->tarea = $id;
        }

        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionEntregables($id = null)
    {
        $tarea = Tarea::findOne($id);

        $desarrollos = Tareadesarrollo::find()->where(['tarea' => $id])->andWhere(['estudiante' => Yii::$app->session->get('__tercero')])->orderBy(['creado_el' => SORT_ASC])->all();

        return $this->render('entregables', [
            'desarrollos' => $desarrollos,
            'tarea' => $tarea,
        ]);
    }

    /**
     * Displays a single Tareadesarrollo model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->renderAjax('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Tareadesarrollo model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $tarea = Tarea::findOne($id);

        $model = new Tareadesarrollo();

        $total = intval(Yii::$app->formatter->asTimestamp($tarea->disponible_hasta)) -intval(Yii::$app->formatter->asTimestamp('now'));
        
        if($total < 0)
        {
            throw new NotFoundHttpException(Yii::t('app', 'No puedo guardar esta tarea porque ya no se encuentra disponible, venció <b>{disponible_hasta}</b>', [
                'disponible_hasta' => Yii::$app->formatter->format($tarea->disponible_hasta, 'relativeTime'),
                ]));
        }

        if(count($tarea->desarrollos) >= $tarea->oportunidades)
        {
           throw new NotFoundHttpException(Yii::t('app', 'No puedo guardar esta tarea porque ya superaste el total de oportunidades para presentarla <b>({desarrollos}/{oportunidades})</b>.', [
                    'desarrollos' => count($tarea->desarrollos),
                    'oportunidades' => $tarea->oportunidades,
                ]));
        }


        $s3 = Yii::$app->get('s3');    
        
        if(!$s3->exist('tareas/'))
        {
            $s3->put('tareas/', null);    
        }

        if ($model->load(Yii::$app->request->post()) ) 
        {
            if($adjunto = UploadedFile::getInstance($model, 'adjunto'))
            {
    
                if(!$s3->exist('tareas/'.$tarea->id.'/'))
                {
                    $s3->put('tareas/'.$tarea->id.'/', null); 
                }

                if(!$s3->exist('tareas/'.$tarea->id.'/'.Yii::$app->session->get('__tercero').'/'))
                {
                    $s3->put('tareas/'.$tarea->id.'/'.Yii::$app->session->get('__tercero').'/', null);    
                }

                $body = file_get_contents($adjunto->tempName);
                $model->adjunto = $s3->put('tareas/'.$tarea->id.'/'.Yii::$app->session->get('__tercero').'/'.$adjunto->name, $body);
            }


            $model->tarea = $tarea->id;
            $model->estudiante = (Yii::$app->session->get('__tercero')=='') ? NULL : Yii::$app->session->get('__tercero');
            //$model->adjunto = $adjuntos;
            $model->estado = '1';
            $model->save(false);                        
            

            \Yii::$app->session->addFlash('mail', [
                            'tipo' => 'success',
                            'titulo' => 'Tarea Enviada',
                            'icono' => 'fa fa-envelope',
                            'mensaje' => 'Su tarea ha sido enviada!',
                        ]);

            return $this->redirect(['estudiante/index']);

        } else {
            return $this->render('create', [
                'tarea' => $tarea,
                'model' => $model,
                'total' => $total,
            ]);
        }
    }


    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        $tarea = Tarea::findOne($model->tarea);

        $total = intval(Yii::$app->formatter->asTimestamp($tarea->disponible_hasta)) -intval(Yii::$app->formatter->asTimestamp('now'));
        

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
                'tarea' => $tarea,
                'total' => $total,
            ]);
        }
    }

    /**
     * Deletes an existing Tareadesarrollo model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }


    public function actionValidate($id)
    {
        $model = $this->findModel($id);
        $model->scenario = 'calificar';

        $request = \Yii::$app->getRequest();
        if ($request->isPost && $model->load($request->post())) {
            \Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }
    }

    public function actionCalificar($id)
    {
        $model = $this->findModel($id);

        $request = \Yii::$app->getRequest();
        
        if ($request->isPost && $model->load($request->post())) {
            $model->revisado_por = Yii::$app->session->get('__tercero');
            $model->revisado_el = date('Y-m-d H:i:s');
            \Yii::$app->response->format = Response::FORMAT_JSON;

            if($model->save(false))
            {
                return $this->redirect(['tarea/view','id' => $model->tareas->id]);
            }   
            else
            {
                throw new NotFoundHttpException(Yii::t('app', 'Error almacendo la calificación.'));
            }
            
        }
    }

    
    /**
     * Finds the Tareadesarrollo model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tareadesarrollo the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Tareadesarrollo::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
