<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use kartik\mpdf\Pdf;
use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Image\Box;  
use yii\db\Expression;
use yii\db\Query;
use yii\web\Response;
use yii\widgets\ActiveForm;

use backend\models\Tercero;
use backend\models\Academico;
use backend\models\Matricula;
use backend\models\Grupomatricular;
use backend\models\Sede;
use common\models\User;
use backend\models\Terceroestado;
use backend\models\Municipio;
use backend\models\Acudiente;
use backend\models\TerceroSearch;
use backend\models\base\Authassignment;
use backend\models\base\Academicovigenciaanterior;

/**
 * TerceroController implements the CRUD actions for Tercero model.
 */
class TerceroController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Tercero models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TerceroSearch();

        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    public function actionView($id)
    {
        $model = $this->findModel($id);
        $providerAcademico = new \yii\data\ArrayDataProvider([
            'allModels' => $model->academicos,
        ]);
        $providerAcudiente = new \yii\data\ArrayDataProvider([
            'allModels' => $model->acudientes,
        ]);
        $providerAsistencia = new \yii\data\ArrayDataProvider([
            'allModels' => $model->asistencias,
        ]);

        $providerGrupo = new \yii\data\ArrayDataProvider([
            'allModels' => $model->grupos,
        ]);
        $providerPlanAula = new \yii\data\ArrayDataProvider([
            'allModels' => $model->planAulas,
        ]);
        return $this->render('view', [
            'model' => $this->findModel($id),
            'providerAcademico' => $providerAcademico,
            'providerAcudiente' => $providerAcudiente,
            'providerAsistencia' => $providerAsistencia,
            'providerGrupo' => $providerGrupo,
            'providerPlanAula' => $providerPlanAula,
        ]);
    }



    public function actionCreate()
    {

        $model = new Tercero();
        $academico = new Academico();
        //$matricula = new Matricula();
        //$matricula->scenario = 'administrativo';
        
        $sede = Sede::find()->where(['principal' => '1'])->one();
        $model->departamento_residencia = $sede->departamento;
        $model->municipio_residencia = $sede->municipio;

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        elseif ($model->load(Yii::$app->request->post()))
        {

            if($foto = UploadedFile::getInstance($model,'foto'))
            {
                $file = rand(10,100).'-'.str_replace(' ','-',$foto);
                $foto->saveAs( 'uploads/'.$file);
                //Image::thumbnail('uploads/'.$foto->name, 120, 120)->save('uploads/'.$foto->name, ['quality' => 80]);

                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(120, 120))->save('uploads/thumbnail/sm-'.$file , ['quality' => 80]);
                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(360, 360))->save('uploads/thumbnail/lg-'.$file , ['quality' => 80]);

                //save the path in DB..
                $model->foto = $file;
                unlink('uploads/'.$file);
            }    
         
            $model->departamento_expedido = ($model->departamento_expedido == '') ? NULL : $model->departamento_expedido;
            $model->departamento_nacimiento = ($model->departamento_nacimiento == '') ? NULL : $model->departamento_nacimiento;
            $model->departamento_desplazado = ($model->departamento_desplazado == '') ? NULL : $model->departamento_desplazado;
            $model->departamento_resguardo = ($model->departamento_resguardo == '') ? NULL : $model->departamento_resguardo;

            switch ($model->tipo_tercero) {
                case '1':
                    $model->estado = '9';
                    break;
                case '2':
                    $model->estado = '5';
                    break;    
                case '3':
                    $model->estado = '7';
                    break;
                default:
                    $model->estado = '9';
                    break;
            }

            if ($model->save()) 
            {
                
                \Yii::$app->session->addFlash('mensaje4', [
                                'tipo' => 'success',
                                'titulo' => 'Creación de Tercero',
                                'icono' => 'fa fa-user',
                                'mensaje' => 'El tercero '.$model->nombre.' se creó éxitosamente.',
                            ]);
                
                if($model->tipo_tercero == 1)
                {
                    return $this->redirect(['tercero/update', 'id' => $model->id]);    
                }
                else
                {
                    return $this->redirect(['index']);
                }
                
            }
            else
            {
                    return $this->render('create', [
                        'model' => $model,
                        'academico' => $academico,
                        //'matricula' => $matricula,
                        'sede' => $sede,
                    ]);
            }    
                
                
        }
        else {
            return $this->render('create', [
                'model' => $model,
                'academico' => $academico,
                //'matricula' => $matricula,
                'sede' => $sede,
            ]);
        }
    }


    public function actionUsuario()
    {
        $usuarios = User::find()->select(['username']);
        $terceros = Tercero::find()->where(['NOT IN', 'identificacion', $usuarios])->all();

        foreach ($terceros as $tercero) 
        {
            $user = new User();
            $user->username = $tercero->identificacion;
            $user->email = $tercero->email;
            $user->setPassword($tercero->identificacion);
            $user->generateAuthKey();
            $user->save();

            $asignacion = Authassignment::find()->where(['user_id' => $user->id])->one();

            if(!isset($asignacion))
            {
                $asignacion = new Authassignment();
                $asignacion->item_name = $tercero->tipoterceros->tipo;
                $asignacion->user_id = $user->id;
                $asignacion->created_at = strtotime("now");
                $asignacion->save(false);
            }
                
                /*Yii::$app->mailer->compose('crea-tercero', ['model' => $tercero])
                    ->setFrom([\Yii::$app->params['supportEmail'] => \Yii::$app->name . ' robot'])
                    ->setTo('acosta@gsolcolombia.com')
                    //->setTo($tercero->email)
                    ->setSubject('Creación de Usuario')
                    ->send();*/
            
                
        }
            
        return $this->render('usuario', [
            'terceros' => $terceros,
        ]);
    
    }

    
    public function actionLista($q = null, $id = null) 
    {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        $out = ['results' => ['id' => '', 'text' => '']];
        if (!is_null($q)) {

                                                                   
            $data = Tercero::find()->select(['id', new Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido, ''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as text")])
                    ->Where(['tercero.tipo_tercero' => '1'])
                    //->andWhere(['<', 'tercero.estado', '3'])
                    ->Where(['like', 'primer_nombre', $q])
                    ->orWhere(['like', 'segundo_nombre', $q])
                    ->orWhere(['like', 'primer_apellido', $q])
                    ->orWhere(['like', 'segundo_apellido', $q])
                    ->orderBy('primer_apellido')
                    ->asArray()
                    ->all();

            $out['results'] = array_values($data);
        }
        elseif ($id > 0) {
            $out['results'] = ['id' => $id, 'text' => Tercero::findOne($id)->primer_apellido];
        }
        return $out;
    }

    public function actionFindmunicipios() {
        list($publica) = Yii::$app->createController('publica');
        return $publica->municipios($_POST['depdrop_parents']);
    }

    public function actionFindbarrios() {
        list($publica) = Yii::$app->createController('publica');
        return $publica->barrios($_POST['depdrop_parents']);
    }
 
    public function actionFindestados() {
        list($publica) = Yii::$app->createController('publica');
        return $publica->estados($_POST['depdrop_parents']);
    }

    public function actionFindresguardos() {
        list($publica) = Yii::$app->createController('publica');
        return $publica->resguardos($_POST['depdrop_parents']);
    }

    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $model->foto_anterior = $model->foto;

        $usuario_actual = $model->identificacion;

        $sede = Sede::find()->where(['principal' => '1'])->one();
        
        /*
        if (($matricula = Matricula::find()->where(['estudiante' => $id])->one()) === null) {
                $matricula = new Matricula();
                $matricula->estudiante = $id;
        }*/
        
        if($model->tipo_tercero == 1)
        {
            if (($academico = Academico::find()->where(['estudiante' => $id])->one()) === null) {
                    $academico = new Academico(['scenario'=>'academico']);
                    $academico->estudiante = $id;
            }
        }
        else
        {
            if (($academico = Academico::find()->where(['estudiante' => $id])->one()) === null) {
                $academico = new Academico();
                $academico->estudiante = $id;
            }
        }

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        //elseif ($model->load(Yii::$app->request->post()) && $academico->load(Yii::$app->request->post()) && $matricula->load(Yii::$app->request->post()))
        elseif ($model->load(Yii::$app->request->post()) && $academico->load(Yii::$app->request->post()))
        {
            //echo " 304 ";
            $isValid = $model->validate();

            if($model->tipo_tercero == 1)
            {
                $isValid = $academico->validate() && $isValid;
            }
            
            //$isValid = $matricula->validate() && $isValid;

            if($foto = UploadedFile::getInstance($model,'foto'))
            {
                if(isset($foto))
                {
                    //echo "<br>Entro";
                    if (!file_exists('uploads/thumbnail/')) {
                        mkdir('uploads/thumbnail/', 0777, true);
                    }

                    $file = rand(10,100).'-'.str_replace(' ','-',$foto);

                    $foto->saveAs( 'uploads/'.$file);
                    //Image::thumbnail('uploads/'.$foto->name, 120, 120)->save('uploads/'.$foto->name, ['quality' => 80]);

                    Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(120, 120))->save('uploads/thumbnail/sm-'.$file , ['quality' => 80]);
                    Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(360, 360))->save('uploads/thumbnail/lg-'.$file , ['quality' => 80]);

                    //save the path in DB..
                    $model->foto = $file;
                    unlink('uploads/'.$file);

                    \Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Fotografía',
                        'icono' => 'fa fa-user',
                        'mensaje' => 'Se anexo fotografía al estudiante <b>'.$model->nombre.'</b> éxitosamente.',
                    ]);
                }
               
            }
            else
            {
                //echo "No Entro";
                //echo " - ".$model->foto." = ".$model->foto_anterior;
                $model->foto = $model->foto_anterior;
            }

             //exit;    
         
            
            $model->departamento_nacimiento = ($model->departamento_nacimiento == '') ? NULL : $model->departamento_nacimiento;
            $model->departamento_expedido = ($model->departamento_expedido == '') ? NULL : $model->departamento_expedido;
            $model->departamento_desplazado = ($model->departamento_desplazado == '') ? NULL : $model->departamento_desplazado;
            $model->departamento_resguardo = ($model->departamento_resguardo == '') ? NULL : $model->departamento_resguardo;
            
            $model->resguardo = ($model->departamento_resguardo == '') ? NULL : $model->resguardo;

            
            if ($isValid) 
            {
                if($model->tipo_tercero == 1)
                {

                    if($academico->fecha_retiro !='')
                    {
                        $model->estado = $academico->motivo;    
                    }
                    else
                    {
                        $model->estado = '1';    
                    }

                    if($academico->grupo !='')
                    {
                        if($academico->isNewRecord)
                        {
                            $model->estado = '1';
                        }
                    }

                    /*
                    if($matricula->grupo !='')
                    {
                        $matricula->save();
                    }*/
         

                    $model->save();
                    $academico->save();
                    
                    
                    if (($matricula = Matricula::find()->where(['estudiante' => $academico->estudiante])->one()) === null) 
                    {
                        $matricula = new Matricula();
                        $matricula->estudiante = $academico->estudiante;
                        $matricula->grupo = $academico->grupo;
                        $matricula->especialidad = $academico->especialidad;
                        $matricula->fecha_matricula = $academico->fecha_matricula;
                        $matricula->estado = '1';
                        $matricula->save(false);
                    }
                    else
                    {
                        $matricula->grupo = $academico->grupo;
                        $matricula->especialidad = $academico->especialidad;
                        $matricula->fecha_matricula = $academico->fecha_matricula;
                        $matricula->estado = '1';
                        $matricula->update(false);
                    }                             

                }
                else
                {
                    $model->save();
                }

                if($usuario_actual != $model->identificacion)
                {
                    /*
                    $user =  User::find()->where(['username' => $usuario_actual])->one();
                    $user->username = $model->identificacion;
                    $user->email = $model->email;
                    $user->setPassword($model->identificacion);
                    $user->generateAuthKey();
                    $user->save();
        
                    \Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Actualización de Usuario',
                        'icono' => 'fa fa-user',
                        'mensaje' => 'El usuario '.$model->nombre.' se actualizó éxitosamente.',
                    ]);*/
                }


                
                \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Actualización de Tercero',
                                'icono' => 'fa fa-user',
                                'mensaje' => 'El tercero '.$model->nombre.' se actualizó éxitosamente.',
                            ]);
                
                
                //return $this->redirect(['index']);
                return $this->redirect(['tercero/update', 'id' => $model->id]);    
                
                
            }
            else
            {
                
                return $this->render('update', [
                        'model' => $model,
                        'academico' => $academico,
                        //'matricula' => $matricula,
                        'sede' => $sede,
                    ]);
            } 
        } else {

            return $this->render('update', [
                'model' => $model,
                'academico' => $academico,
                //'matricula' => $matricula,
                'sede' => $sede,
            ]);
        }
    }


    public function actionMatricula($id)
    {
        $model = $this->findModel($id);
        $matricula = Academico::find()->where(['estudiante' => $id])->andWhere(['estado' => '1'])->one();

        if(isset($matricula))
        {
            
            return $this->render('matricula', [
                'model' => $model,
                'matricula' => $matricula,
            ]);
        }
        else
        {
            throw new NotFoundHttpException('El estudiante '.$model->nombre.' no tiene registro académico');
        }
    }

    public function actionStep1($id)
    {
        $sede = Sede::find()->where(['principal' => '1'])->one();

        if($sede->activar_matriculas == 0)
        {
            throw new NotFoundHttpException(Yii::t('app', 'Las matrículas estan deshabilitadas por el momento!'));
        }
        
        $model = $this->findModel($id);

        $matricula = Academico::find()->where(['estudiante' => $id])->andWhere(['estado' => '1'])->one();

        if(isset($matricula))
        {
            return $this->redirect(['matricula', 'id' => $id]);
            
        }

        if (!Yii::$app->session->has('__step1'))
        {
            Yii::$app->session->set('__step1', 0);
            Yii::$app->session->set('__step2', 0);
            Yii::$app->session->set('__step3', 0);
            Yii::$app->session->set('__step4', 0);
            Yii::$app->session->set('__step5', 0);
        }

        $model->scenario = 'step1';
        $model->departamento_residencia = $sede->departamento;
        $model->municipio_residencia = $sede->municipio;


        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        elseif ($model->load(Yii::$app->request->post()))
        {

            if($foto = UploadedFile::getInstance($model,'foto'))
            {
                $file = rand(10,100).'-'.str_replace(' ','-',$foto);
                $foto->saveAs( 'uploads/'.$file);
                //Image::thumbnail('uploads/'.$foto->name, 120, 120)->save('uploads/'.$foto->name, ['quality' => 80]);

                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(120, 120))->save('uploads/thumbnail/sm-'.$file , ['quality' => 80]);
                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(360, 360))->save('uploads/thumbnail/lg-'.$file , ['quality' => 80]);

                //save the path in DB..
                $model->foto = $file;
                unlink('uploads/'.$file);
            }

            $model->departamento_expedido = ($model->departamento_expedido == '') ? NULL : $model->departamento_expedido;
            $model->departamento_nacimiento = ($model->departamento_nacimiento == '') ? NULL : $model->departamento_nacimiento;
            $model->departamento_desplazado = ($model->departamento_desplazado == '') ? NULL : $model->departamento_desplazado;
            $model->departamento_resguardo = ($model->departamento_resguardo == '') ? NULL : $model->departamento_resguardo;

            if ($model->save()) 
            {
                \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Éxito',
                                'icono' => 'fa fa-user',
                                'mensaje' => 'Se almaceno la información personal de <b>'.$model->nombre.'</b> con éxito!.',
                            ]);

                Yii::$app->session->set('__step1', 1);
                
                return $this->redirect(['step2', 'id' => $model->id]);
            }
            else
            {
                    throw new HttpException($model->getErrors());
            } 
            //return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('_step1', [
                'model' => $model,
                'sede' => $sede,
            ]);
        }
    }

    public function actionStep2($id)
    {
        $sede = Sede::find()->where(['principal' => '1'])->one();

        if($sede->activar_matriculas == 0)
        {
            throw new NotFoundHttpException(Yii::t('app', 'Las matrículas estan deshabilitadas por el momento!'));
        }

        $model = $this->findModel($id);

        if(Yii::$app->session->get('__step1') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información personal de <b>'.$model->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step1', 'id' => $id]); 
        }

        $model->scenario = 'step2';
        $model->recurso = 1;
        $model->bienestar = 0;
        $model->sector = 0;
        $model->heroe = 0;
        $model->fuerza_publica = 0;

        $sede = Sede::find()->where(['principal' => '1'])->one();

        //$model->departamento_resguardo = NULL;


        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        elseif ($model->load(Yii::$app->request->post()))
        {
            if($foto = UploadedFile::getInstance($model,'foto'))
            {
                $file = rand(10,100).'-'.str_replace(' ','-',$foto);
                $foto->saveAs( 'uploads/'.$file);
                //Image::thumbnail('uploads/'.$foto->name, 120, 120)->save('uploads/'.$foto->name, ['quality' => 80]);

                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(120, 120))->save('uploads/thumbnail/sm-'.$file , ['quality' => 80]);
                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(360, 360))->save('uploads/thumbnail/lg-'.$file , ['quality' => 80]);

                //save the path in DB..
                $model->foto = $file;
                unlink('uploads/'.$file);
            }

            $model->departamento_expedido = ($model->departamento_expedido == '') ? NULL : $model->departamento_expedido;
            $model->departamento_nacimiento = ($model->departamento_nacimiento == '') ? NULL : $model->departamento_nacimiento;
            $model->departamento_desplazado = ($model->departamento_desplazado == '') ? NULL : $model->departamento_desplazado;
            $model->departamento_resguardo = ($model->departamento_resguardo == '') ? NULL : $model->departamento_resguardo;
            $model->resguardo = ($model->departamento_resguardo == '') ? NULL : $model->resguardo;

            if ($model->save()) 
            {
                \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Éxito',
                                'icono' => 'fa fa-user',
                                'mensaje' => 'Se almaceno la información complementaria de <b>'.$model->nombre.'</b> con éxito!.',
                            ]);

                Yii::$app->session->set('__step2', 1);
                
                return $this->redirect(['step3', 'id' => $model->id]);
            }
            else
            {
                    throw new HttpException($model->getErrors());
            } 
        } else {
            return $this->render('_step2', [
                'model' => $model,
                'sede' => $sede,
            ]);
        }
    }

    public function actionStep3($id)
    {
        $sede = Sede::find()->where(['principal' => '1'])->one();

        if($sede->activar_matriculas == 0)
        {
            throw new NotFoundHttpException(Yii::t('app', 'Las matrículas estan deshabilitadas por el momento!'));
        }

        $tercero = $this->findModel($id);

        if(!$tercero->acudientes)
        {
            $model = new Acudiente;
            $model->estudiante = $tercero->id;
            $model->principal = 1;
            $model->tipo = 1;    
        }
        else
        {
            $model = Acudiente::find()->where(['principal' => 1])->andWhere(['eliminado_por' => 0])->one();
        }

        

        if(Yii::$app->session->get('__step1') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información personal de <b>'.$tercero->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step1', 'id' => $id]); 
        }

        if(Yii::$app->session->get('__step2') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información complementaria de <b>'.$tercero->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step2', 'id' => $id]); 
        }


        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) 
        {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        elseif ($model->load(Yii::$app->request->post()))
        {

            if ($model->save()) 
            {
                \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Se créo Acudiente',
                                'icono' => 'fa fa-user',
                                'mensaje' => 'El acudiente <b>'.$model->nombre.'</b> se agrego al estudiante <b>'.$tercero->nombre.'</b>.',
                            ]);
                
                Yii::$app->session->set('__step3', 1);
                
                return $this->redirect(['step4', 'id' => $tercero->id]);
                
            }
            else
            {
                    throw new HttpException($model->getErrors());
            } 

        } else {
            return $this->render('_step3', [
                'model' => $model,
                'tercero' => $tercero,
            ]);
        }
    }

    public function actionStep4($id)
    {
        $sede = Sede::find()->where(['principal' => '1'])->one();

        if($sede->activar_matriculas == 0)
        {
            throw new NotFoundHttpException(Yii::t('app', 'Las matrículas estan deshabilitadas por el momento!'));
        }

        $model = $this->findModel($id);

        if(Yii::$app->session->get('__step1') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información personal de <b>'.$model->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step1', 'id' => $id]); 
        }

        if(Yii::$app->session->get('__step2') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información complementaria de <b>'.$model->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step2', 'id' => $id]); 
        }

        if(Yii::$app->session->get('__step3') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información del acudiente de <b>'.$model->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step3', 'id' => $id]); 
        }


        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) 
        {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }  

        

        if ($model->load(Yii::$app->request->post()))
        {

            if($foto = UploadedFile::getInstance($model,'foto'))
            {
                $file = rand(10,100).'-'.str_replace(' ','-',$foto);
                $foto->saveAs( 'uploads/'.$file);
                //Image::thumbnail('uploads/'.$foto->name, 120, 120)->save('uploads/'.$foto->name, ['quality' => 80]);

                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(120, 120))->save('uploads/thumbnail/sm-'.$file , ['quality' => 80]);
                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(360, 360))->save('uploads/thumbnail/lg-'.$file , ['quality' => 80]);

                //save the path in DB..
                $model->foto = $file;
                unlink('uploads/'.$file);
            }

            if ($model->save()) 
            {

                $contacto = count($model->acudientes).' '.count($model->acudientes) > 1 ? "contáctos" : "contácto";

                \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Se créo Contácto',
                                'icono' => 'fa fa-user',

                                'mensaje' => 'Se agrego '.count($model->acudientes).' '.$contacto.' al estudiante <b>'.$model->nombre.'</b>.',
                            ]);
                
                Yii::$app->session->set('__step4', 1);
                
                return $this->redirect(['step5', 'id' => $model->id]);
                
            }
            else
            {
                //print_r($model->getErrors());

                \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error en el Contácto',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'El contácto no sé agrego al estudiante <b>'.$model->nombre.'</b>, puede faltar información.',
                            ]);

                //return $this->redirect(['step4', 'id' => $model->id]); 
                return $this->render('_step4', [
                    'model' => $model,
                ]);
            } 

        } else {
            return $this->render('_step4', [
                'model' => $model,
            ]);
        }
    }

    public function actionStep5($id)
    {
        $sede = Sede::find()->where(['principal' => '1'])->one();

        if($sede->activar_matriculas == 0)
        {
            throw new NotFoundHttpException(Yii::t('app', 'Las matrículas estan deshabilitadas por el momento!'));
        }

        $model = $this->findModel($id);
        $model->scenario = 'step5';

        if(Yii::$app->session->get('__step1') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información personal de <b>'.$model->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step1', 'id' => $id]); 
        }

        if(Yii::$app->session->get('__step2') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información complementaria de <b>'.$model->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step2', 'id' => $id]); 
        }

        if(Yii::$app->session->get('__step3') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información del acudiente de <b>'.$model->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step3', 'id' => $id]); 
        }


        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        elseif ($model->load(Yii::$app->request->post()))
        {
            if($foto = UploadedFile::getInstance($model,'foto'))
            {
                if(isset($foto))
                {
                    //echo "<br>Entro";
                    if (!file_exists('uploads/thumbnail/')) {
                        mkdir('uploads/thumbnail/', 0777, true);
                    }

                    $file = rand(10,100).'-'.str_replace(' ','-',$foto);

                    $foto->saveAs( 'uploads/'.$file);
                    //Image::thumbnail('uploads/'.$foto->name, 120, 120)->save('uploads/'.$foto->name, ['quality' => 80]);

                    Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(120, 120))->save('uploads/thumbnail/sm-'.$file , ['quality' => 80]);
                    Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(360, 360))->save('uploads/thumbnail/lg-'.$file , ['quality' => 80]);

                    //save the path in DB..
                    $model->foto = $file;
                    unlink('uploads/'.$file);

                    \Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Fotografía',
                        'icono' => 'fa fa-user',
                        'mensaje' => 'Se anexo fotografía al estudiante <b>'.$model->nombre.'</b> éxitosamente.',
                    ]);
                }

                if ($model->save()) 
                {
                    return $this->redirect(['step6', 'id' => $id]);
                }
            }


            $model->addError('foto', 'Fotográfia no puede estar vacío.'); 

            return $this->render('_step5', [
                'model' => $model,
            ]);
            

        } else {
            return $this->render('_step5', [
                'model' => $model,
            ]);
        }
    }

    public function actionStep6($id)
    {
        $sede = Sede::find()->where(['principal' => '1'])->one();

        if($sede->activar_matriculas == 0)
        {
            throw new NotFoundHttpException(Yii::t('app', 'Las matrículas estan deshabilitadas por el momento!'));
        }
        
        $model = $this->findModel($id);
        $tercero = Tercero::findOne($id);


        if(Yii::$app->session->get('__step1') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información personal de <b>'.$model->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step1', 'id' => $id]); 
        }

        if(Yii::$app->session->get('__step2') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información complementaria de <b>'.$model->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step2', 'id' => $id]); 
        }

        if(Yii::$app->session->get('__step3') != 1)
        {
            \Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Error',
                                'icono' => 'fa fa-times',
                                'mensaje' => 'No se diligenció la información del acudiente de <b>'.$model->nombre.'</b> se enrutó al paso 1 para su diligenciamiento!.',
                            ]);

            return $this->redirect(['step3', 'id' => $id]); 
        }

        //$actual2 = Academico::find()->where(['estudiante' => $id])->andWhere(['estado' => '1']);
        //echo $actual2->createCommand()->getRawSql(); // Mostrar SQL   

        $actual = Academicovigenciaanterior::find()->where(['estudiante' => $id])->andWhere(['estado' => '1'])->one();

        if (!isset($actual))
        {
            throw new NotFoundHttpException('El estudiante '.$model->nombre.' no tiene registro académico');
        }
        else
        {
            $matricula = Academico::find()->where(['estudiante' => $actual->estudiante])->andWhere(['estado' => '1'])->one();

            if(!isset($matricula))
            {

                $nuevo = Grupomatricular::find()->where(['grupo_actual' => $actual->grupo])->andWhere(['estado' => '1'])->one();
                
                if (!isset($nuevo))
                {
                    throw new NotFoundHttpException('La institución educativa no ha configurado la promoción del grupo '.$actual->grupos->grupo.' para el próximo año lectivo, comunicate con la institución para que sea configurada.');
                }

                $matricula = new Academico;
                $matricula->estudiante = $actual->estudiante;
                $matricula->grupo = $nuevo->grupo_nuevo;
                $matricula->especialidad = $actual->especialidad;
                $matricula->fecha_matricula = new \yii\db\Expression('NOW()');
                $matricula->estado = '1';
                $matricula->save(false);

                $tercero = Tercero::findOne($actual->estudiante);
                $tercero->estado = 1;
                $tercero->update(false);
    
                
                $user = User::find()->where(['username' => $tercero->identificacion])->one();
                
                if(!isset($user))
                {

                    $user = new User();
                    $user->username = $tercero->identificacion;
                    $user->email = $tercero->email;
                    $user->setPassword($tercero->identificacion);
                    $user->generateAuthKey();
                    $user->save();

                    $asignacion = Authassignment::find()->where(['user_id' => $user->id])->one();

                    if(!isset($asignacion))
                    {
                        $asignacion = new Authassignment();
                        $asignacion->item_name = "Estudiante";
                        $asignacion->user_id = $user->id;
                        $asignacion->created_at = strtotime("now");
                        $asignacion->save(false);
                    }

                    Yii::$app->session->addFlash('mensaje1', [
                            'tipo' => 'info',
                            'titulo' => 'Creación de Usuario',
                            'icono' => 'fa fa-key',
                            'mensaje' => 'Se creó el usuario <b>'.$tercero->identificacion.'</b> para el estudiante <b>'.$tercero->nombre.'</b> para ingresar al sistema.']); 

                    
                    if(\Yii::$app->mailer->compose('crea-tercero', ['model' => $tercero])
                        ->setFrom([\Yii::$app->params['supportEmail'] => \Yii::$app->name . ' robot'])
                        ->setTo($tercero->email)
                        ->setSubject('Creación de Usuario')
                        ->send())
                    {    
                    
                        \Yii::$app->session->addFlash('mensaje2', [
                                'tipo' => 'info',
                                'titulo' => 'Notificación de E-Mail',
                                'icono' => 'fa fa-envelope',
                                'mensaje' => 'Se notificó por correo electrónico a '.$tercero->email.' la creación del usuario']);     

                    }
                    else
                    {
                        \Yii::$app->session->addFlash('mensaje2', [
                                'tipo' => 'danger',
                                'titulo' => 'Notificación de E-Mail',
                                'icono' => 'fa fa-envelope',
                                'mensaje' => 'No se notificó por correo electrónico a '.$tercero->email.' la creación del usuario']);      
                    }
                    

                }
            }
            
            return $this->render('_step6', [
                'model' => $model,
                'actual' => $actual,
                'matricula' => $matricula,
            ]);
        }
    }

        

    public function actionCertificadomatricula($id) 
    {
        $model = $this->findModel($id);
 
        $content = $this->renderAjax('_hojadevida', [
            'model' => $model,
        ]);
        // Establecer la zona horaria predeterminada a usar. Disponible desde PHP 5.1
        date_default_timezone_set('UTC');

        date_default_timezone_set('America/Bogota');
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_LETTER,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'filename' => 'Certificado de Matricula de '.$model->nombre.'.pdf',
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                //'SetHeader' => [\Yii::$app->name],
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['Hoja de Vida|Página {PAGENO}|'. date("F j, Y g:i a")],
                
            ]
        ]);

        return $pdf->render();
    }


    public function actionDelete($id)
    {       
            $tercero = $this->findModel($id);
            $tercero->activo = '0';
            $tercero->eliminado = '1';
            $tercero->update();
        
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();
        return $this->redirect(['index']);
    }
 

    public function actionHojadevida($id) 
    {
        $model = $this->findModel($id);
 
        $content = $this->renderAjax('_hojadevida', [
            'model' => $model,
        ]);
        // Establecer la zona horaria predeterminada a usar. Disponible desde PHP 5.1
        date_default_timezone_set('UTC');

        date_default_timezone_set('America/Bogota');
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_LETTER,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'filename' => 'Hoja de Vida de '.$model->nombre.'.pdf',
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                //'SetHeader' => [\Yii::$app->name],
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['Hoja de Vida|Página {PAGENO}|'. date("F j, Y g:i a")],
                
            ]
        ]);

        return $pdf->render();
    }



    public function actionPdf($id) {
        $model = $this->findModel($id);
        $providerAcademico = new \yii\data\ArrayDataProvider([
            'allModels' => $model->academicos,
        ]);
        /*$providerAcudiente = new \yii\data\ArrayDataProvider([
            'allModels' => $model->acudientes,
        ]);*/
        $providerAsistencia = new \yii\data\ArrayDataProvider([
            'allModels' => $model->asistencias,
        ]);
        $providerCalificacion = new \yii\data\ArrayDataProvider([
            'allModels' => $model->calificacions,
        ]);
        $providerGrupo = new \yii\data\ArrayDataProvider([
            'allModels' => $model->grupos,
        ]);
        $providerPlanAula = new \yii\data\ArrayDataProvider([
            'allModels' => $model->planAulas,
        ]);

        $content = $this->renderAjax('_pdf', [
            'model' => $model,
            'providerAcademico' => $providerAcademico,
            //'providerAcudiente' => $providerAcudiente,
            'providerAsistencia' => $providerAsistencia,
            'providerCalificacion' => $providerCalificacion,
            'providerGrupo' => $providerGrupo,
            'providerPlanAula' => $providerPlanAula,
        ]);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_CORE,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_BROWSER,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['{PAGENO}'],
            ]
        ]);

        return $pdf->render();
    }
    
 
    protected function findModel($id)
    {
        if (($model = Tercero::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('El tercero no existe.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Academico
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddAcademico()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Academico');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('action') == 'load' && empty($row)) || Yii::$app->request->post('action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formAcademico', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    

    public function actionAddAcudiente()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Acudiente');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formAcudiente', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }     
    /**
    * Action to load a tabular form grid
    * for Asistencia
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddAsistencia()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Asistencia');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('action') == 'load' && empty($row)) || Yii::$app->request->post('action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formAsistencia', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Calificacion
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddCalificacion()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Calificacion');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('action') == 'load' && empty($row)) || Yii::$app->request->post('action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formCalificacion', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Grupo
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddGrupo()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Grupo');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('action') == 'load' && empty($row)) || Yii::$app->request->post('action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formGrupo', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    
    public function actionAddUsuario()
    {
        if (Yii::$app->request->isAjax) {
                if (($model = User::find()->where(['=', 'username', Yii::$app->request->post('id')])->one()) !== null) {

                        $model->setPassword(Yii::$app->request->post('id'));
                        $model->generateAuthKey();
                        $model->save();
                    return $model->username;
                } else {
                    
                    $user = new User();
                    $user->username = Yii::$app->request->post('id');
                    //$user->email = $model->email;
                    $user->setPassword(Yii::$app->request->post('id'));
                    $user->generateAuthKey();
                    $user->save(false);

                    $tercero = Tercero::find()->where(['identificacion' => Yii::$app->request->post('id')])->one();
                    
                    switch ($tercero->tipo_tercero) {
                        case '1':
                            $perfil = "Estudiante";
                            break;
                        
                        case '2':
                            $perfil = "Docente";
                            break;
                        
                        case '3':
                            $perfil = "Administrativo";
                            break;
                        
                        default:
                            $perfil = "Estudiante";
                            break;
                        
                    }


                    try {

                        $asignacion = new Authassignment();
                        $asignacion->item_name = $perfil;
                        $asignacion->user_id = $user->id;
                        //$asignacion->created_at = 1490969671;
                        $asignacion->created_at = strtotime("now");
                        $asignacion->save(false);

                        //return $perfil;

                    } catch (\yii\db\IntegrityException $e) {
                        //return $asignacion->error_reporting();
                        return 'Error L617';

                    }

                    return $user->username; 
                }

        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionAddPlanAula()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('PlanAula');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('action') == 'load' && empty($row)) || Yii::$app->request->post('action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formPlanAula', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
