<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Acudiente;

/**
 * backend\models\AcudienteSearch represents the model behind the search form about `backend\models\Acudiente`.
 */
 class AcudienteSearch extends Acudiente
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'estudiante', 'parentesco', 'rh', 'creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['identificacion', 'primer_nombre', 'segundo_nombre', 'primer_apellido', 'segundo_apellido', 'genero', 'direccion', 'fijo', 'movil', 'email', 'creado_el', 'actualizado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Acudiente::find()->where(['eliminado_por' => '0']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'estudiante' => $this->estudiante,
            'parentesco' => $this->parentesco,
            'rh' => $this->rh,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'identificacion', $this->identificacion])
            ->andFilterWhere(['like', 'primer_nombre', $this->primer_nombre])
            ->andFilterWhere(['like', 'segundo_nombre', $this->segundo_nombre])
            ->andFilterWhere(['like', 'primer_apellido', $this->primer_apellido])
            ->andFilterWhere(['like', 'segundo_apellido', $this->segundo_apellido])
            ->andFilterWhere(['like', 'genero', $this->genero])
            ->andFilterWhere(['like', 'direccion', $this->direccion])
            ->andFilterWhere(['like', 'fijo', $this->fijo])
            ->andFilterWhere(['like', 'movil', $this->movil])
            ->andFilterWhere(['like', 'email', $this->email]);

        return $dataProvider;
    }
}
