<?php

namespace backend\models;

use Yii;
use \backend\models\base\Area as BaseArea;
use backend\models\Asignatura;


/**
 * This is the model class for table "area".
 */
class Area extends BaseArea
{
    public static function getAreasbyAsignatura($id) {
        $data = static::find()->where(['id'=>$id])->select(['id', 'area AS name'])->asArray()->all();
        return $data;
    }

    public static function getAreasbyGrado($id) {
        $areas = Asignatura::find()->select(['area'])->where(['grado' => $id])->andWhere(['eliminado_por'=> '0'])->groupBy(['area']);   
        $data = static::find()->select('id, area AS name')->where(['in', 'id', $areas])->andWhere(['eliminado_por' => '0'])->asArray()->all();
            
        return $data;
    } 
	
}
