<?php

namespace backend\models;

use Yii;
use \backend\models\base\Asignatura as BaseAsignatura;
use backend\models\Carga;


/**
 * This is the model class for table "asignatura".
 */
class Asignatura extends BaseAsignatura
{
    

    public static function getAsignaturasbyGradoyGrupo($grado, $grupo = null) {


        if(Yii::$app->session->get('__tipo') == 2)

        {
            if(isset($grupo))
            {
                $carga = Carga::find()->select(['asignatura'])->andWhere(['grupo'=>$grupo])->andWhere(['docente' => Yii::$app->session->get('__tercero')]);   
                $data = static::find()->select('id, asignatura AS name')->where(['in', 'id', $carga])->andWhere(['grado'=>$grado])->asArray()->all();
            }
            else
            {
                $carga = Carga::find()->select(['asignatura'])->andWhere(['docente' => Yii::$app->session->get('__tercero')]);   
                $data = static::find()->select('id, asignatura AS name')->where(['in', 'id', $carga])->andWhere(['grado'=>$grado])->asArray()->all();
            }

            
        }
        else
        {
            $data = static::find()->where(['grado' => $grado])->select(['id', 'asignatura AS name'])->asArray()->all();
        }

        return $data;
    }


    public static function getAsignaturasbyGrado($grado) {


        if(Yii::$app->session->get('__tipo') == 2)
        {
            $carga = Carga::find()->select(['asignatura'])->andWhere(['docente' => Yii::$app->session->get('__tercero')]);   
            $data = static::find()->select('id, asignatura AS name')->where(['in', 'id', $carga])->andWhere(['grado'=>$grado])->asArray()->all();
            
        }
        else
        {
            $data = static::find()->where(['grado'=>$grado])->select(['id', 'asignatura AS name'])->asArray()->all();
        }

        return $data;
    }

    public static function getAsignaturasbyGradonoExcluidas($grado) {


        if(Yii::$app->session->get('__tipo') == 2)
        {
            $carga = Carga::find()->select(['asignatura'])->andWhere(['docente' => Yii::$app->session->get('__tercero')]);   
            $data = static::find()->select('id, asignatura AS name')->where(['in', 'id', $carga])->andWhere(['grado'=>$grado])->andWhere(['excluida_promocion' => '0'])->asArray()->all();
            
        }
        else
        {
            $data = static::find()->where(['grado'=>$grado])->andWhere(['excluida_promocion' => '0'])->select(['id', 'asignatura AS name'])->asArray()->all();
        }

        return $data;
    }
    public static function getAsignaturasbyGrupo($id) {

        if($id==''){ return ''; }
        
        $grupo = Grupo::find()->where(['id' => $id])->one();
        
        $data = static::find()->where(['grado'=>$grupo->grado])->select(['id', 'asignatura AS name'])->asArray()->all();
        //$data = static::find()->where(['grado'=>$id])->select(['area as id', 'asignatura AS name'])->asArray()->all();

        return $data;
    }

    public static function getAsignaturasbyGradoIndex($grado) {


        if(Yii::$app->session->get('__tipo') == 2)
        {
            $carga = Carga::find()->select(['asignatura'])->andWhere(['docente' => Yii::$app->session->get('__tercero')]);   
            $asignaturas = static::find()->select('id, asignatura')->where(['in', 'id', $carga])->andWhere(['grado'=>$grado])->all();
            
        }
        else
        {
            $asignaturas = static::find()->where(['grado'=>$grado])->select(['id', 'asignatura'])->all();
        }

        $data = "<option>Seleccione</option>";

        if (!empty($asignaturas)) {
            foreach($asignaturas as $asignatura) 
            {
                $data .= "<option value='".$asignatura->id."'>-".$asignatura->asignatura."</option>";
            }
        } else {
            $data .= "<option>No hay Asignaturas</option>";
        }

        return $data;
    }
}
