<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Asignatura;

/**
 * backend\models\AsignaturaSearch represents the model behind the search form about `backend\models\Asignatura`.
 */
 class AsignaturaSearch extends Asignatura
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'intensidad', 'grado', 'area', 'especialidad', 'num_calificaciones_saber', 'por_calificaciones_saber', 'num_calificaciones_ser', 'por_calificaciones_ser', 'por_calificaciones_psi', 'por_asig_area','principal', 'excluida_promocion', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['asignatura', 'codigo', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Asignatura::find()->where(['eliminado_por' => '0'])->orderBy(['grado' => SORT_ASC, 'area' => SORT_ASC, 'asignatura' => SORT_ASC,]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'intensidad' => $this->intensidad,
            'grado' => $this->grado,
            'area' => $this->area,
            'especialidad' => $this->especialidad,
            'num_calificaciones_saber' => $this->num_calificaciones_saber,
            'por_calificaciones_saber' => $this->por_calificaciones_saber,
            'num_calificaciones_ser' => $this->num_calificaciones_ser,
            'por_calificaciones_ser' => $this->por_calificaciones_ser,
            'por_calificaciones_psi' => $this->por_calificaciones_psi,
            'por_asig_area' => $this->por_asig_area,
            'principal' => $this->principal,
            'excluida_promocion' => $this->excluida_promocion,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'asignatura', $this->asignatura])
            ->andFilterWhere(['like', 'codigo', $this->codigo]);

        return $dataProvider;
    }
}
