<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Asistencia;

/**
 * backend\models\AsistenciaSearch represents the model behind the search form about `backend\models\Asistencia`.
 */
 class AsistenciaSearch extends Asistencia
{
    public $pageSize;

    public function rules()
    {
        return [
            [['id', 'asignatura', 'grupo', 'periodo', 'docente', 'estudiante', 'fallas', 'tipo_inasistencia'], 'integer'],
            [['asistio', 'fecha'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Asistencia::find()->where(['eliminado_por' => '0']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'asignatura' => $this->asignatura,
            'grupo' => $this->grupo,
            'periodo' => $this->periodo,
            'docente' => $this->docente,
            'estudiante' => $this->estudiante,
            'fallas' => $this->fallas,
            'tipo_inasistencia' => $this->tipo_inasistencia,
            'fecha' => $this->fecha,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
        ]);

        $query->andFilterWhere(['like', 'asistio', $this->asistio]);

        return $dataProvider;
    }
    
}
