<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Bitacora;

/**
 * backend\models\BitacoraSearch represents the model behind the search form about `backend\models\Bitacora`.
 */
 class BitacoraSearch extends Bitacora
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'tercero', 'periodo', 'ejecutor', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['accion', 'controlador', 'descripcion', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Bitacora::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'tercero' => $this->tercero,
            'periodo' => $this->periodo,
            'ejecutor' => $this->ejecutor,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'eliminado_por' => $this->eliminado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'accion', $this->accion])
            ->andFilterWhere(['like', 'controlador', $this->controlador])
            ->andFilterWhere(['like', 'descripcion', $this->descripcion]);

        return $dataProvider;
    }
}
