<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Calificacion;

/**
 * backend\models\CalificacionSearch represents the model behind the search form about `backend\models\Calificacion`.
 */
 class CalificacionSearch extends Calificacion
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'docente', 'estudiante', 'asignatura', 'grupo', 'periodo', 'creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['calificacion', 'coevaluacion', 'autoevaluacion', 'heteroevaluacion', 'nivelacion', 'indicador', 'observacion', 'creado_el', 'actualizado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Calificacion::find()->where(['eliminado_por' => '0']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'docente' => $this->docente,
            'estudiante' => $this->estudiante,
            'asignatura' => $this->asignatura,
            'grupo' => $this->grupo,
            'periodo' => $this->periodo,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'calificacion', $this->calificacion])
            ->andFilterWhere(['like', 'coevaluacion', $this->coevaluacion])
            ->andFilterWhere(['like', 'autoevaluacion', $this->autoevaluacion])
            ->andFilterWhere(['like', 'heteroevaluacion', $this->heteroevaluacion])
            ->andFilterWhere(['like', 'nivelacion', $this->nivelacion])
            ->andFilterWhere(['like', 'indicador', $this->indicador])
            ->andFilterWhere(['like', 'observacion', $this->observacion]);

        return $dataProvider;
    }
}
