<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Campanaitem;

/**
 * backend\models\CampanaitemSearch represents the model behind the search form about `backend\models\Campanaitem`.
 */
 class CampanaitemSearch extends Campanaitem
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'campana', 'tercero', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['mensaje', 'adjunto', 'foto', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Campanaitem::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'campana' => $this->campana,
            'tercero' => $this->tercero,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'eliminado_por' => $this->eliminado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'mensaje', $this->mensaje])
            ->andFilterWhere(['like', 'adjunto', $this->adjunto])
            ->andFilterWhere(['like', 'foto', $this->foto]);

        return $dataProvider;
    }
}
