<?php

namespace backend\models;

use Yii;
use \backend\models\base\Carga as BaseCarga;

/**
 * This is the model class for table "carga".
 */
class Carga extends BaseCarga
{
    public static function getAsignaturasbyDocente($id) {

        $cargas = Carga::find()
        			->joinWith(['asignaturas','grupos','grupos.grados'])
        			->where(['carga.docente' => $id])
        			->orderBy(['grado.id' => SORT_ASC, 'grupo.grupo' => SORT_ASC, 'asignatura.asignatura' => SORT_ASC])
        			->all();

       	$data = [];
        foreach ($cargas as $carga) {
        	$data[] = ['id' => $carga->id, 'name' => $carga->asignaturas->asignatura.' ('.$carga->grupos->grupo.')'];
        }
       	
       	//return $cargas->createCommand()->getRawSql();
        return $data;
    }

    public static function getAsignaturasbyGrupoxDocente($id) 
    {
        $cargas = Carga::find()
              ->joinWith(['asignaturas'])
              ->where(['carga.docente' => Yii::$app->session->get('__tercero')])
              ->andWhere(['carga.grupo' => $id])
              ->orderBy(['asignatura.asignatura' => SORT_ASC])
              ->all(); 
        $data = [];

        foreach ($cargas as $carga) {
          $data[] = ['id' => $carga->asignatura, 'name' => $carga->asignaturas->asignatura];
        }
        
        return $data;
    }
	
}
