<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Carga;

/**
 * backend\models\CargaSearch represents the model behind the search form about `backend\models\Carga`.
 */
 class CargaSearch extends Carga
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'docente', 'asignatura', 'grupo', 'creado_por', 'actualizado_por', 'estado','director_area'], 'integer'],
            [['creado_el', 'actualizado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Carga::find()->where(['eliminado_por' => '0'])->orderBy(['docente' => SORT_ASC, 'grupo' => SORT_ASC, 'asignatura' => SORT_ASC]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'docente' => $this->docente,
            'asignatura' => $this->asignatura,
            'grupo' => $this->grupo,
            'director_area' => $this->director_area,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'estado' => $this->estado,
        ]);

        return $dataProvider;
    }
}
