<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Competencia;

/**
 * backend\models\CompetenciaSearch represents the model behind the search form about `backend\models\Competencia`.
 */
 class CompetenciaSearch extends Competencia
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'grado', 'asignatura', 'periodo', 'estandar', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['competencia', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        //$query = Competencia::find();

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $carga = Carga::find()->select(['asignatura'])->where(['docente' =>  Yii::$app->session->get('__tercero')])->andWhere(['eliminado_por' => '0']);
            $query = Competencia::find()->where(['IN', 'asignatura', $carga])->andWhere(['eliminado_por' => '0']);
        }
        else
        {
            $query = Competencia::find()->where(['eliminado_por' => '0']);
        }

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'grado' => $this->grado,
            'asignatura' => $this->asignatura,
            'periodo' => $this->periodo,
            'estandar' => $this->estandar,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'eliminado_por' => $this->eliminado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'competencia', $this->competencia]);

        return $dataProvider;
    }
}
