<?php

namespace backend\models;

use Yii;
use \backend\models\base\Comportamiento as BaseComportamiento;


class Comportamiento extends BaseComportamiento
{

	public function Crear_Registro($estudiante, $grupo, $asignatura, $periodo, $calificacionxcompetencia, $num_calificaciones_saber, $num_calificaciones_ser)
    {
    	
    	for($p=1;$p<=$periodo;$p++)
    	{

	    	$model = new Comportamiento;
		    //$model->docente = Yii::$app->session->get('__id');
			$model->docente = Yii::$app->session->get('__doc') == 'admin' ? NULL : Yii::$app->session->get('__tercero');
		    $model->estudiante = $estudiante;
		    $model->grupo = $grupo;
		    $model->periodo = $p;
	        
	        if($model->save(false))
	        {
	            Yii::$app->session->addFlash('mensaje', [
	                'tipo' => 'success',
	                'titulo' => 'Calificaciones Creada',
	                'icono' => 'fa fa-check-square-o',
	                'mensaje' => 'Las calificaciones de '.$model->estudiantes->nombre.' se crearon con éxito en el sistema para el periodo '.$p,
	            ]);  
	        } 

    	}

        return true;
    }

	public function Promedio($calificaciones, $cantidad)
    {
    	$promedio = round(array_sum($calificaciones)/$cantidad,1); 
        return $promedio;
    }

    public function Definitiva($calificaciones, $cantidad, $porcentaje)
    {
    	$definitiva = round((((array_sum($calificaciones)/$cantidad) * $porcentaje) / 100),1); 
        return $definitiva;	
    }


}
