<?php

namespace backend\models;

use Yii;
use \backend\models\base\Desempeno as BaseDesempeno;
//use \backend\models\base\Grado;


/**
 * This is the model class for table "desempeno".
 */
class Desempeno extends BaseDesempeno
{
    static function getDesempenosbyGrado($id) {
        

        $tipo = Grado::find()->where(['id'=>$id])->select(['tipo_calificacion'])->one();
        $data = static::find()->where(['tipo_calificacion'=>$tipo])->select(['id', 'desempeno AS name'])->asArray()->all();

        return $data;
    }    

    public function getTipocalificacionbyGrado($id){
        $data = Grado::find($id)->one()->tipo_calificacion;
    }

    public function Color($calificacion, $tipo_calificacion = NULL)
    {                    
        if($tipo_calificacion == 1)
        {
            
            $calificacion = $calificacion == NULL ? 'NE' : $calificacion;
            $desempeno = static::find()->where(['nota' => $calificacion, 'tipo_calificacion' => $tipo_calificacion])->one();
            $color = $desempeno->color;
        }
        else
        {
            $calificacion = $calificacion == NULL ? 0 : round($calificacion,1);

            $query = "SELECT * FROM `desempeno` WHERE ".$calificacion." BETWEEN limite_inferior AND limite_superior AND tipo_calificacion =".$tipo_calificacion;
            $desempeno = static::findbySql($query)->one();
            $color = $desempeno->color;
        }
        
    
        return $color;
    }

    public function Nota($calificacion,$tipo_calificacion = NULL)
    {
        
            
        if($tipo_calificacion == 1)
        {    
            $calificacion = $calificacion == NULL ? 'NE' : $calificacion;
            $desempeno = static::find()->where(['nota' => $calificacion, 'tipo_calificacion' => $tipo_calificacion])->one();
        }
        else
        {
            $calificacion = round($calificacion,1);
            $query = "SELECT * FROM `desempeno` WHERE ".$calificacion." BETWEEN limite_inferior AND limite_superior AND tipo_calificacion =".$tipo_calificacion;
            $desempeno = static::findbySql($query)->one();
        }
        
        return $desempeno->nota;
     
    }

    public function Perdido($calificacion, $tipo_calificacion = NULL)
    {
        
            
        if($tipo_calificacion == '1')
        {    
            $calificacion = $calificacion == NULL ? 'NE' : $calificacion;
            $desempeno = static::find()->where(['nota' => $calificacion, 'tipo_calificacion' => $tipo_calificacion])->one();
        }
        else
        {
            $calificacion = round($calificacion,1);
            $query = "SELECT * FROM `desempeno` WHERE ".$calificacion." BETWEEN limite_inferior AND limite_superior AND tipo_calificacion =".$tipo_calificacion;
            $desempeno = static::findbySql($query)->one();
        }
        
        return $desempeno->perdido;
     
    }

    public function Emoticons($calificacion,$tipo_calificacion = NULL)
    {

        if ($tipo_calificacion == '1') // TIPO CALIFICACION LETRAS
        {
            $calificacion = ($calificacion == '0') ? 'NE' : $calificacion;
                
            $desempeno = static::find()->where(['nota' => $calificacion])->one();    
        }
        else  // TIPO CALIFICACION NUMEROS
        {
            $calificacion = round($calificacion,1);
                
            $query = "SELECT * FROM `desempeno` WHERE ".$calificacion." BETWEEN limite_inferior AND limite_superior AND tipo_calificacion =".$tipo_calificacion;
            $desempeno = static::findbySql($query)->one();    
        }
        
        
        return $desempeno->emoticons;
     
    }

    public function Notacolor($calificacion,$tipo_calificacion = NULL)
    {                    

        if($tipo_calificacion == 1)
        {
            $calificacion = $calificacion == NULL ? 'NE' : $calificacion;
            $desempeno = static::find()->where(['nota' => $calificacion, 'tipo_calificacion' => $tipo_calificacion])->one();
            $color = ['nota' => $desempeno->nota ,'color' => $desempeno->color];
        }
        else{
            $query = "SELECT * FROM `desempeno` WHERE ".$calificacion." BETWEEN limite_inferior AND limite_superior AND tipo_calificacion =".$tipo_calificacion;
            $desempeno = static::findbySql($query)->one();
            $color = ['nota' => $desempeno->nota ,'color' => $desempeno->color];
        }
        
    
        return $color;
    }


    public function Desempeno($calificacion,$tipo_calificacion = NULL)
    {   
        if($tipo_calificacion == 1){
            $calificacion = $calificacion == '' ? 'NE' : $calificacion;
            $desempeno = static::find()->where(['nota' => $calificacion, 'tipo_calificacion' => $tipo_calificacion])->one();
        }
        else{
            $calificacion = ($calificacion == '' ? '0' : $calificacion);
            $query = "SELECT * FROM `desempeno` WHERE ".$calificacion." BETWEEN limite_inferior AND limite_superior AND tipo_calificacion =".$tipo_calificacion;
            $desempeno = static::findbySql($query)->one();
        }
        return $desempeno->desempeno;
    }

    public function Desempenoid($calificacion,$tipo_calificacion = NULL)
    {   
        if($tipo_calificacion == 1)
        {
            $calificacion = $calificacion == '' ? 'NE' : $calificacion;
            $desempeno = static::find()->where(['nota' => $calificacion, 'tipo_calificacion' => $tipo_calificacion])->one();
        }
        else
        {
            $calificacion = ($calificacion == '' ? '0' : $calificacion);
            $query = "SELECT * FROM `desempeno` WHERE ".$calificacion." BETWEEN limite_inferior AND limite_superior AND tipo_calificacion =".$tipo_calificacion;
            $desempeno = static::findbySql($query)->one();
        }
        
        return $desempeno->id;
    }

    function hex2rgb($color) 
    {
        if ( $color[0] == '#' ) {
                $color = substr( $color, 1 );
        }
        if ( strlen( $color ) == 6 ) {
                list( $r, $g, $b ) = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
        } elseif ( strlen( $color ) == 3 ) {
                list( $r, $g, $b ) = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
        } else {
                return false;
        }
        $r = hexdec( $r );
        $g = hexdec( $g );
        $b = hexdec( $b );
        return array( 'r' => $r, 'g' => $g, 'b' => $b );
    }
}
