<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Desempeno;

/**
 * backend\models\DesempenoSearch represents the model behind the search form about `backend\models\Desempeno`.
 */
 class DesempenoSearch extends Desempeno
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'tipo_calificacion', 'creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['desempeno', 'color', 'nota', 'creado_el', 'actualizado_el'], 'safe'],
            [['limite_inferior', 'limite_superior'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Desempeno::find()->where(['eliminado_por' => '0']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'tipo_calificacion' => $this->tipo_calificacion,
            'limite_inferior' => $this->limite_inferior,
            'limite_superior' => $this->limite_superior,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'desempeno', $this->desempeno])
            ->andFilterWhere(['like', 'color', $this->color])
            ->andFilterWhere(['like', 'nota', $this->nota]);

        return $dataProvider;
    }
}
