<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Estandar;

/**
 * backend\models\EstandarSearch represents the model behind the search form about `backend\models\Estandar`.
 */
 class EstandarSearch extends Estandar
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'grado', 'asignatura', 'periodo', 'creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['estandar', 'creado_el', 'actualizado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        if(Yii::$app->session->get('__tipo') == 2)
        {
            $carga = Carga::find()->select(['asignatura'])->where(['docente' =>  Yii::$app->session->get('__tercero')])->andWhere(['eliminado_por' => '0']);
            $query = Estandar::find()->where(['IN', 'asignatura', $carga])->andWhere(['eliminado_por' => '0']);
        }
        else
        {
            $query = Estandar::find()->where(['eliminado_por' => '0']);
        }

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'grado' => $this->grado,
            'asignatura' => $this->asignatura,
            'periodo' => $this->periodo,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'estandar', $this->estandar]);

        return $dataProvider;
    }
}
