<?php

namespace backend\models;

use Yii;
use \backend\models\base\Carga;
use \backend\models\Tercero;

use \backend\models\base\Grado as BaseGrado;

/**
 * This is the model class for table "grado".
 */
class Grado extends BaseGrado
{
 
	public static function getGradobyDocente($tercero = null) 
    {
        if($tercero != NULL)
        {
            $tercero = Tercero::findOne($tercero);    

            if($tercero->tipo_tercero == 2)
            {
                $carga = Carga::find()
                            ->select(['grupo'])
                            ->where(['docente' => $tercero])
                            ->groupBy(['grupo']);
                            //->orderBy(['grupo' => SORT_ASC]);
                            //->all();

                $grado = Grupo::find()
                            ->select(['grado'])
                            ->where(['id' => $carga])
                            ->groupBy(['grado'])
                            ->orderBy(['grado' => SORT_ASC]);
                            //->all(); 

                $data = Grado::find()
                            ->select(['id', 'grado'])
                            ->where(['id' => $grado])
                            ->groupBy(['id'])
                            ->orderBy(['id' => SORT_ASC])
                            ->asArray()->all();

                return $data;

                //return $data->createCommand()->getRawSql();
            }
            else
            {
                $data = Grado::find()->where(['estado' => '1'])->select(['id', 'grado'])->asArray()->all();
            }
        }
        else
        {
            $data = Grado::find()->where(['estado' => '1'])->select(['id', 'grado'])->asArray()->all();
        }
        return $data;
    }

    public static function getGrados($sede, $tercero = null) 
    {
        $data = Grado::find()->where(['sede' => $sede])->andWhere(['estado' => '1'])->select(['id', 'grado AS name'])->asArray()->all();
        
        return $data;
    }
	
}
