<?php

namespace backend\models;


use Yii;
use \backend\models\base\Grupo as BaseGrupo;

use \backend\models\base\Academico;
use \backend\models\base\Grado;
use \backend\models\base\Carga;


class Grupo extends BaseGrupo
{   
	public static function getGradobyTercero($sede, $tercero = null) 
	{
    	if($tercero != NULL)
    	{
    		$academico = Academico::find()->where(['estudiante' => $tercero])->one(); 
    		$data = Grado::find()->where(['id'=>$academico->grupos->grados->id])->select(['id', 'grado AS name'])->asArray()->all();       
        }
    	else
    	{
    		$data = Grado::find()->where(['estado' => '1'])->select(['id', 'grado AS name'])->asArray()->all();
    	}
        return $data;
    }

    public static function getGruposbyGrado($sede, $grado, $tercero = null) {

    	if($tercero != NULL)
    	{
    		$academico = Academico::find()->where(['estudiante' => $tercero])->one(); 
    		$data = static::find()->where(['id' => $academico->grupo])->select(['id', 'grupo AS name'])->asArray()->all();

    	}
    	else
    	{
    		$data = static::find()->where(['sede' => $sede, 'grado'=>$grado])->andWhere(['eliminado_por' => 0])->select(['id', 'grupo AS name'])->asArray()->all();
    	}	
        
        return $data;
    }

    public static function getGruposbyGradoJornada($sede, $grado, $jornada) {

        $data = static::find()->where(['sede' => $sede])->andWhere(['grado' => $grado])->andWhere(['eliminado_por' => 0])->andWhere(['jornada' => $jornada])->select(['id', 'grupo AS name'])->asArray()->all();
        
        return $data;
    }

    public static function getEstudiantesbyGrupo($grupo) {

        $total = Academico::find()->where(['grupo' => $grupo])->andWhere(['eliminado_por' => 0])->count(); 
        return $total;
    }

    public static function getAreasbyGrupo($grupo) {


        $grupo = static::find()->where(['id' => $grupo])->one();
        $total = Asignatura::find()->where(['grado' => $grupo->grado])->andWhere(['eliminado_por' => 0])->count(); 
        return $total;
    }

    public static function getGrupobyDocente($tercero = null) 
    {
        if($tercero != NULL)
        {
            $carga = Carga::find()
                        ->select(['grupo'])
                        ->where(['docente' => $tercero])
                        ->groupBy(['grupo']);
                        //->orderBy(['grupo' => SORT_ASC]);
                        //->all();

            $data = Grupo::find()
                        ->select(['id','grupo'])
                        ->where(['id' => $carga])
                        ->orderBy(['id' => SORT_ASC])
                        ->asArray()->all();

            return $data;

        }
        else
        {
            $data = Grupo::find()->where(['estado' => '1'])->select(['id', 'grupo'])->andWhere(['eliminado_por' => 0])->asArray()->all();
        }
        return $data;
    }
}
