<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Grupo;

/**
 * backend\models\GrupoSearch represents the model behind the search form about `backend\models\grupo`.
 */
 class GrupoSearch extends Grupo
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'grado', 'director', 'jornada', 'sede', 'metodologia', 'modalidad', 'especialidad', 'creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['grupo', 'creado_el', 'actualizado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = grupo::find()->where(['eliminado_por' => '0']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'grado' => $this->grado,
            'director' => $this->director,
            'jornada' => $this->jornada,
            'sede' => $this->sede,
            'metodologia' => $this->metodologia,
            'modalidad' => $this->modalidad,
            'especialidad' => $this->especialidad,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'grupo', $this->grupo]);

        return $dataProvider;
    }
}
