<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Grupomatricular;

/**
 * backend\models\GupomatricularSearch represents the model behind the search form about `backend\models\Grupomatricular`.
 */
 class GupomatricularSearch extends Grupomatricular
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'sede_actual', 'grado_actual', 'jornada_actual', 'grupo_actual', 'sede_nuevo', 'grado_nuevo', 'jornada_nuevo', 'grupo_nuevo', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Grupomatricular::find()->where(['eliminado_por' => '0']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'sede_actual' => $this->sede_actual,
            'grado_actual' => $this->grado_actual,
            'jornada_actual' => $this->jornada_actual,
            'grupo_actual' => $this->grupo_actual,
            'sede_nuevo' => $this->sede_nuevo,
            'grado_nuevo' => $this->grado_nuevo,
            'jornada_nuevo' => $this->jornada_nuevo,
            'grupo_nuevo' => $this->grupo_nuevo,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'eliminado_por' => $this->eliminado_por,
            'estado' => $this->estado,
        ]);

        return $dataProvider;
    }
}
