<?php

namespace backend\models;

use Yii;
use \backend\models\base\Instituto as BaseInstituto;

/**
 * This is the model class for table "instituto".
 */
class Instituto extends BaseInstituto
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return array_replace_recursive(parent::rules(),
	    [
            [['instituto', 'direccion', 'fijo', 'resolucion', 'dane', 'rector_nombre', 'rector_cc', 'rector_expedida', 'rector_movil', 'rector_email', 'creado_por', 'actualizado_por'], 'required'],
            [['pdf_header', 'pdf_footer'], 'string'],
            [['bloquear_boletin', 'compromiso_acudiente', 'autorizar_nivelaciones', 'bloquear_estudiante', 'creado_por', 'actualizado_por', 'eliminado_por'], 'integer'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['nit'], 'string', 'max' => 15],
            [['instituto', 'fijo', 'resolucion', 'dane', 'rector_nombre', 'rector_cc', 'rector_expedida'], 'string', 'max' => 30],
            [['direccion', 'rector_email', 'pdf_marcadeagua_contenido'], 'string', 'max' => 255],
            [['rector_movil'], 'string', 'max' => 10],
            [['pdf_marcadeagua'], 'string', 'max' => 1],
            [['rector_email'], 'unique']
        ]);
    }
	
}
