<?php

namespace backend\models;

use Yii;
use yii\base\Model;

class LanzadorDocenteForm extends Model
{
    public $reporte; 
    public $observaciones; 
    
    public $tercero;
    public $docente;
    public $grado;
    public $asignatura;
    public $grupo;
    public $periodo;
    public $competencia;
    public $columnas;
    public $opciones;
    public $fecha;
    public $ver_estandar;
    public $ver_competencia;
    public $ver_niveles;
    public $ver_desempenos;
    public $ver_frd;
    public $ver_fecha;
    public $ver_parametros;
    public $ver_letrasonumeros;
    public $ver_colores;
    public $fuente;
    public $alto;
    public $carga;
    public $rango;
    public $fecha_inicio;
    public $fecha_fin;


    public function rules()
    {
        return [
            [['tercero', 'grado', 'asignatura', 'grupo', 'periodo', 'competencia', 'columnas', 'ver_estandar', 'ver_competencia', 'ver_niveles', 'ver_desempenos', 'ver_frd', 'ver_fecha', 'ver_letrasonumeros','ver_colores', 'fuente', 'alto', 'ver_parametros'], 'integer'],
            [['tercero', 'carga', 'grado', 'asignatura', 'grupo', 'periodo', 'competencia', 'fecha', 'ver_estandar', 'ver_competencia', 'ver_niveles', 'ver_desempenos', 'ver_frd', 'ver_fecha', 'ver_letrasonumeros','ver_colores', 'fuente', 'alto', 'ver_parametros', 'fecha_inicio', 'fecha_fin', 'rango'], 'safe'],
            [['reporte', 'observaciones'], 'string'],
            [['tercero'], 'required', 'on' => 'tercero'],
            [['tercero', 'rango'], 'required', 'on' => 'tercero-rango'],
            [['grado', 'grupo', 'asignatura'], 'required', 'on' => 'asignatura'],
            [['grado', 'grupo', 'asignatura', 'periodo'], 'required', 'on' => 'asignatura-periodo'],
            [['grado', 'grupo', 'periodo'], 'required', 'on' => 'grupo-periodo'],
            [['tercero','grado', 'grupo', 'periodo'], 'required', 'on' => 'grupo-periodo-tercero'],
            [['tercero','periodo'], 'required', 'on' => 'tercero-periodo'],
            [['tercero', 'grado', 'asignatura', 'grupo', 'periodo', 'competencia', 'columnas'], 'required', 'on' => 'todos'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'sede' => Yii::t('app', 'Sede'),
            'tercero' => Yii::t('app', 'Tercero'),
            'grado' => Yii::t('app', 'Grado'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'area' => Yii::t('app', 'Área'),
            'grupo' => Yii::t('app', 'Grupo'),
            'estandar' => Yii::t('app', 'Estandar'),
            'periodo' => Yii::t('app', 'Periodo'),
            'competencia' => Yii::t('app', 'Competencia'),
            'columnas' => Yii::t('app', 'Agregar Columnas'),
            'fecha' => Yii::t('app', 'Fecha'),
            'ver_estandar' => Yii::t('app', 'Estandar'),
            'ver_competencia' => Yii::t('app', 'Competencia'),
            'ver_niveles' => Yii::t('app', 'Niveles'),
            'ver_desempenos' => Yii::t('app', 'Desempeños'),
            'ver_frd' => Yii::t('app', 'FRD'),
            'ver_fecha' => Yii::t('app', 'Fecha'),
            'ver_letrasonumeros' => Yii::t('app', 'Letras o Números'),
            'ver_colores' => Yii::t('app', 'Ver Colores'),
            'fuente' => Yii::t('app', 'Tamaño de la Fuente'),
            'alto' => Yii::t('app', 'Alto de la Celda')
        ];
    }

}
