<?php

namespace backend\models;

use Yii;
use yii\base\Model;

class LanzadorForm extends Model
{
    public $reporte; 
    public $observaciones; 
    
    public $sede;
    public $tercero;
    public $grado;
    public $asignatura;
    public $grupo;
    public $periodo;
    public $competencia;
    public $columnas;
    public $opciones;
    public $fecha;
    public $ver_estandar;
    public $ver_competencia;
    public $ver_niveles;
    public $ver_desempenos;
    public $ver_frd;
    public $ver_fecha;
    public $ver_parametros;
    public $ver_letrasonumeros;
    public $ver_orientacion;
    public $ver_colores;
    public $ver_emoticons;
    public $fuente;
    public $alto;
    public $carga;


    public function rules()
    {
        return [
            [['sede','tercero', 'grado', 'asignatura', 'grupo', 'periodo', 'competencia', 'columnas', 'ver_estandar', 'ver_competencia', 'ver_niveles', 'ver_desempenos', 'ver_frd', 'ver_fecha', 'ver_letrasonumeros','ver_colores', 'fuente', 'alto', 'ver_parametros','carga'], 'safe'],
            [['sede','tercero', 'grado', 'asignatura', 'grupo', 'periodo', 'competencia', 'fecha', 'ver_estandar', 'ver_competencia', 'ver_niveles', 'ver_desempenos', 'ver_frd', 'ver_fecha', 'ver_letrasonumeros','ver_colores', 'ver_emoticons', 'fuente', 'alto', 'ver_parametros','ver_orientacion'], 'safe'],
            [['reporte', 'observaciones'], 'string'],
            
            [['sede'], 'required', 'on' => 'sede'],
            [['sede','grado'], 'required', 'on' => 'grado'],
            [['sede','grado', 'grupo'], 'required', 'on' => 'grupo'],
            [['sede','grado', 'grupo', 'asignatura'], 'required', 'on' => 'asignatura'],
            [['sede','grado', 'grupo', 'asignatura', 'periodo'], 'required', 'on' => 'asignatura-periodo'],
            [['sede'], 'required', 'on' => 'grado-periodo'],
            [['sede','grado', 'grupo', 'periodo'], 'required', 'on' => 'grupo-periodo'],
            [['sede','tercero','grado', 'grupo', 'periodo'], 'required', 'on' => 'grupo-periodo-tercero'],
            [['tercero','periodo'], 'required', 'on' => 'tercero-periodo'],
            [['sede','tercero', 'grado', 'asignatura', 'grupo', 'periodo', 'competencia', 'columnas'], 'required', 'on' => 'todos'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'sede' => Yii::t('app', 'Sede'),
            'tercero' => Yii::t('app', 'Tercero'),
            'grado' => Yii::t('app', 'Grado'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'area' => Yii::t('app', 'Área'),
            'grupo' => Yii::t('app', 'Grupo'),
            'estandar' => Yii::t('app', 'Estandar'),
            'periodo' => Yii::t('app', 'Periodo'),
            'competencia' => Yii::t('app', 'Competencia'),
            'columnas' => Yii::t('app', 'Agregar Columnas'),
            'fecha' => Yii::t('app', 'Fecha'),
            'ver_estandar' => Yii::t('app', 'Estandar'),
            'ver_competencia' => Yii::t('app', 'Competencia'),
            'ver_niveles' => Yii::t('app', 'Niveles'),
            'ver_desempenos' => Yii::t('app', 'Desempeños'),
            'ver_frd' => Yii::t('app', 'FRD'),
            'ver_fecha' => Yii::t('app', 'Fecha'),
            'ver_letrasonumeros' => Yii::t('app', 'Letras o Números'),
            'ver_colores' => Yii::t('app', 'Colores'),
            'ver_emoticons' => Yii::t('app', 'Emoticons'),
            'ver_orientacion' => Yii::t('app', 'Orientación'),
            'fuente' => Yii::t('app', 'Tamaño de la Fuente'),
            'alto' => Yii::t('app', 'Alto de la Celda')
        ];
    }

}
