<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\base\Mensajes;

/**
 * backend\models\MensajesSearch represents the model behind the search form about `backend\models\base\Mensajes`.
 */
 class MensajesSearch extends Mensajes
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'remitente', 'remisor', 'categoria', 'importante', 'visto', 'creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['asunto', 'mensaje', 'adjunto', 'visto_el', 'creado_el', 'actualizado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        //$query = Mensajes::find()->groupBy(['mid']);
        $query = Mensajes::find()->where(['eliminado_por' => '0'])->orderBy(['creado_el' => SORT_DESC]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'remitente' => $this->remitente,
            'remisor' => $this->remisor,
            'categoria' => $this->categoria,
            'importante' => $this->importante,
            'visto' => $this->visto,
            'visto_el' => $this->visto_el,
            
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'asunto', $this->asunto])
            ->andFilterWhere(['like', 'mensaje', $this->mensaje])
            ->andFilterWhere(['like', 'adjunto', $this->adjunto])
            ->andFilterWhere(['like', 'creado_el', $this->creado_el]);

        return $dataProvider;
    }
}
