<?php

namespace backend\models;

use Yii;
use \backend\models\base\Municipio as BaseMunicipio;

/**
 * This is the model class for table "municipio".
 */
class Municipio extends BaseMunicipio
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return array_replace_recursive(parent::rules(),
	    [
            [['dane', 'nombre', 'departamento'], 'required'],
            [['creado_el', 'actualizado_el'], 'safe'],
            [['creado_por', 'actualizado_por'], 'integer'],
            [['dane', 'departamento'], 'string', 'max' => 5],
            [['nombre'], 'string', 'max' => 100]
        ]);
    }
    public static function getMunicipiosbyDepartamento($id) {
        $data = static::find()->where(['departamento'=>$id])->select(['id', 'nombre AS name'])->asArray()->all();
        return $data;
    }
    public static function getDefaultMunicipio($id) {
        $data = static::find()->where(['id'=> 687])->select(['id'])->asArray()->all();
        return $data;
    }
    
    
	
}
