<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Observador;

/**
 * app\models\ObservadorSearch represents the model behind the search form about `backend\models\Observador`.
 */
 class ObservadorSearch extends Observador
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'estudiante', 'momento', 'asignatura', 'periodo', 'docente', 'clase_observacion', 'tipo_observacion', 'creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['comprometidos', 'fecha', 'descripcion', 'descargos', 'proceso', 'creado_el', 'actualizado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Observador::find()->where(['eliminado_por' => '0']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'estudiante' => $this->estudiante,
            'momento' => $this->momento,
            'asignatura' => $this->asignatura,
            'periodo' => $this->periodo,
            'fecha' => $this->fecha,
            'docente' => $this->docente,
            'clase_observacion' => $this->clase_observacion,
            'tipo_observacion' => $this->tipo_observacion,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'comprometidos', $this->comprometidos])
            ->andFilterWhere(['like', 'descripcion', $this->descripcion])
            ->andFilterWhere(['like', 'descargos', $this->descargos])
            ->andFilterWhere(['like', 'proceso', $this->proceso]);

        return $dataProvider;
    }
}
