<?php
namespace backend\models;

use Yii;
use common\models\User;
use backend\models\Tercero;
use yii\base\Model;

/**
 * Password reset request form
 */
class PasswordResetRequestForm extends Model
{
    public $username;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            ['username', 'filter', 'filter' => 'trim'],
            ['username', 'required'],
            ['username', 'exist',
                'targetClass' => '\common\models\User',
                'filter' => ['status' => User::STATUS_ACTIVE],
                'message' => 'El usuario no existe.'
            ],
        ];
    }

    public function attributeLabels()
    {
        return [
            'username' => Yii::t('app', 'Usuario'),
        ];
    }

    /**
     * Sends an email with a link, for resetting the password.
     *
     * @return boolean whether the email was send
     */
    public function sendEmail()
    {
        /* @var $user User */
        $user = User::findOne([
            'status' => User::STATUS_ACTIVE,
            'username' => $this->username,
        ]);

        if ($user) {
            if (!User::isPasswordResetTokenValid($user->password_reset_token)) {
                $user->generatePasswordResetToken();
            }

            if ($user->save()) {

                $tercero = Tercero::findOne(['identificacion' => $this->username]);

                if ($tercero->email != '')
                {
                    Yii::$app->mailer->compose(['html' => 'passwordresettoken-html', 'text' => 'passwordresettoken-text'], ['user' => $user, 'model' => $tercero])
                        ->setFrom([Yii::$app->params['supportEmail'] => Yii::$app->name . ' robot'])
                        ->setTo($tercero->email)
                        ->setSubject('Recuperar contraseña de ' . Yii::$app->name)
                        ->send();
                    
                    Yii::$app->session->addFlash('mensaje10', [
                        'tipo' => 'success',
                        'titulo' => 'Recuperación de Contraseña',
                        'icono' => 'fa fa-envelope-o',
                        'mensaje' => 'Hola <b>'.$tercero->nombre.'</b>, se envió un enlace para reestablecer la contraseña a <b>'.$tercero->email.'</b> reviselo para obtener más instrucciones.']);    

                    return true;
                }    

                
            }
        }

        return false;
    }
}
