<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Planaula;
use backend\models\Carga;

/**
 * backend\models\PlanaulaSearch represents the model behind the search form about `backend\models\Planaula`.
 */
 class PlanaulaSearch extends Planaula
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'docente', 'grado', 'asignatura', 'grupo', 'periodo', 'competencia', 'unidad', 'horas', 'creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['semana_inicio', 'semana_fin', 'nombre_unidad', 'derechos', 'inicio', 'desarrollo', 'cierre', 'formativa', 'articulacion', 'recursos', 'reflexion', 'observaciones', 'creado_el', 'actualizado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        if(Yii::$app->session->get('__tipo') == 2)
        {
            $carga = Carga::find()->select(['asignatura'])->where(['docente' =>  Yii::$app->session->get('__tercero')])->andWhere(['eliminado_por' => '0']);
            $query = Planaula::find()->where(['IN', 'asignatura', $carga])->andWhere(['eliminado_por' => '0']);
        }
        else
        {
            $query = Planaula::find()->where(['eliminado_por' => '0']);
        }


        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'docente' => $this->docente,
            'semana_inicio' => $this->semana_inicio,
            'semana_fin' => $this->semana_fin,
            'grado' => $this->grado,
            'asignatura' => $this->asignatura,
            'grupo' => $this->grupo,
            'periodo' => $this->periodo,
            'competencia' => $this->competencia,
            'unidad' => $this->unidad,
            'horas' => $this->horas,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'nombre_unidad', $this->nombre_unidad])
            ->andFilterWhere(['like', 'derechos', $this->derechos])
            ->andFilterWhere(['like', 'inicio', $this->inicio])
            ->andFilterWhere(['like', 'desarrollo', $this->desarrollo])
            ->andFilterWhere(['like', 'cierre', $this->cierre])
            ->andFilterWhere(['like', 'formativa', $this->formativa])
            ->andFilterWhere(['like', 'articulacion', $this->articulacion])
            ->andFilterWhere(['like', 'recursos', $this->recursos])
            ->andFilterWhere(['like', 'reflexion', $this->reflexion])
            ->andFilterWhere(['like', 'observaciones', $this->observaciones]);

        return $dataProvider;
    }
}
