<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Planmejoramiento;
use backend\models\Carga;

/**
 * backend\models\PlanmejoramientoSearch represents the model behind the search form about `backend\models\Planmejoramiento`.
 */
 class PlanmejoramientoSearch extends Planmejoramiento
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'docente', 'grado', 'asignatura', 'grupo', 'periodo', 'competencia', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['fecha_inicio', 'fecha_fin', 'tematica', 'productivo', 'cognitivo', 'valorativo', 'observaciones', 'adjunto', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        
        if(Yii::$app->session->get('__tipo') == 2)
        {
            $carga = Carga::find()->select(['asignatura'])->where(['docente' =>  Yii::$app->session->get('__tercero')])->andWhere(['eliminado_por' => '0']);
            $query = Planmejoramiento::find()->where(['IN', 'asignatura', $carga])->andWhere(['eliminado_por' => '0']);
        }
        else
        {
            $query = Planmejoramiento::find()->where(['eliminado_por' => '0']);
        }

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'docente' => $this->docente,
            'fecha_inicio' => $this->fecha_inicio,
            'fecha_fin' => $this->fecha_fin,
            'grado' => $this->grado,
            'asignatura' => $this->asignatura,
            'grupo' => $this->grupo,
            'periodo' => $this->periodo,
            'competencia' => $this->competencia,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'eliminado_por' => $this->eliminado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'tematica', $this->tematica])
            ->andFilterWhere(['like', 'productivo', $this->productivo])
            ->andFilterWhere(['like', 'cognitivo', $this->cognitivo])
            ->andFilterWhere(['like', 'valorativo', $this->valorativo])
            ->andFilterWhere(['like', 'observaciones', $this->observaciones])
            ->andFilterWhere(['like', 'adjunto', $this->adjunto]);

        return $dataProvider;
    }
}
