<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Pqrsd;

/**
 * backend\models\PqrsdSearch represents the model behind the search form about `backend\models\Pqrsd`.
 */
 class PqrsdSearch extends Pqrsd
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'tercero', 'tipo', 'visto', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['asunto', 'mensaje', 'adjunto_solicitud', 'respuesta', 'adjunto_respuesta', 'visto_el', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Pqrsd::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'tercero' => $this->tercero,
            'tipo' => $this->tipo,
            'visto' => $this->visto,
            'visto_el' => $this->visto_el,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'eliminado_por' => $this->eliminado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'asunto', $this->asunto])
            ->andFilterWhere(['like', 'mensaje', $this->mensaje])
            ->andFilterWhere(['like', 'adjunto_solicitud', $this->adjunto_solicitud])
            ->andFilterWhere(['like', 'respuesta', $this->respuesta])
            ->andFilterWhere(['like', 'adjunto_respuesta', $this->adjunto_respuesta]);

        return $dataProvider;
    }
}
