<?php

namespace backend\models;

use Yii;
use \backend\models\base\Promedio as BasePromedio;
use \backend\models\Asignatura;
use \backend\models\Calificacion;

/**
 * This is the model class for table "promedio".
 */
class Promedio extends BasePromedio
{

    public function getPromedioxEstudiante($tipo_calificacion, $estudiante, $calificacion, $grado, $grupo, $area, $asignatura, $periodo)
    {
         //echo "<br>getPromedioxEstudiante - Tipo: ".$tipo_calificacion.", estudia ".$estudiante.", califi : ".$calificacion.", grado ".$grado.", grupo ".$grupo.", area ".$area.", Periodo ".$periodo;
        
        $asignatura = Asignatura::findOne($asignatura);


        //echo "Asinatura: ".$asignatura->asignatura." ESTUDIANTE: ".$estudiante;
        //exit;
        
        /////////////////////////////   TIPO CALIFICACION LETRAS  ///////////////////////////

        if($tipo_calificacion == '1')
        {
            
            //$tercero = Tercero::findOne($estudiante);

            ///  PROMEDIO ESTUDIANTE POR AREA

           // $asignaturas = Asignatura::find()->select(['id'])->where(['area' => $asignatura->area])->andWhere(['grado' => $grado]);

            //echo "<br>".$promedio_area->createCommand()->getRawSql();

            try {
                    /*
                    $promedio = Promedioarea::find()
                                    ->where(['estudiante' => $estudiante])
                                    ->andWhere(['grado' => $grado])
                                    ->andWhere(['grupo' => $grupo])
                                    ->andWhere(['area' => $area])
                                    ->andWhere(['periodo' => $periodo]);

                    echo "<br>".$promedio->createCommand()->getRawSql();
                    */

                    $promedio = Promedioarea::find()
                                    ->where(['estudiante' => $estudiante])
                                    ->andWhere(['grado' => $grado])
                                    ->andWhere(['grupo' => $grupo])
                                    ->andWhere(['area' => $area])
                                    ->andWhere(['periodo' => $periodo])
                                    ->one();

                    if(!isset($promedio))
                    {
                        $promedio = new Promedioarea();
                        $promedio->promedio_estudiante = $calificacion;
                        $promedio->estudiante = $estudiante;
                        $promedio->grado = $grado;
                        $promedio->grupo = $grupo;
                        $promedio->area = $area;
                        $promedio->periodo = $periodo;
                        $promedio->save(false);
                    }
                    else
                    {
                        $promedio->promedio_estudiante = $calificacion;
                        $promedio->update(false);    
                    }

            } catch (\yii\db\IntegrityException $e) {
                return $promedio->error_reporting();

            }
        
                        
        }

        /////////////////////////////   FIN CALIFICACIONES LETRAS  ///////////////////////////


        /////////////////////////////   TIPO CALIFICACION NUMEROS  ///////////////////////////
        if($tipo_calificacion != 1)
        {
            $suma_estudiante = Calificacion::find()
                                    ->select(['SUM(definitiva_periodo) as definitiva_periodo'])
                                    ->where(['estudiante' => $estudiante])
                                    ->andWhere(['grupo' => $grupo])
                                    ->andWhere(['periodo' => $periodo])
                                    ->groupBy(['estudiante'])
                                    ->one();
            
            $tercero = Tercero::findOne($estudiante);

            $promedio_estudiante = ROUND($suma_estudiante->definitiva_periodo / $tercero->totalasignaturas,1);
            
            try {
                    $promedio = Promedio::find()
                                    ->where(['estudiante' => $estudiante])
                                    ->andWhere(['grado' => $grado])
                                    ->andWhere(['grupo' => $grupo])
                                    ->andWhere(['periodo' => $periodo])
                                    ->one();

                    if(!isset($promedio))
                    {
                        //echo " 113";
                        $promedio = new Promedio();
                        $promedio->promedio_estudiante = $promedio_estudiante;
                        $promedio->estudiante = $estudiante;
                        $promedio->grado = $grado;
                        $promedio->grupo = $grupo;
                        $promedio->periodo = $periodo;
                        
                        if(!$promedio->save())
                        {
                            echo "<br>124";
                            var_dump($promedio->getErrors());
                        }
                        
                    }
                    else
                    {
                        $promedio->promedio_estudiante = $promedio_estudiante;
                        
                        if(!$promedio->update())
                        {
                            echo "<br>134";
                            var_dump($promedio->getErrors());
                        }  
                    }

            } catch (\yii\db\IntegrityException $e) {
                return $promedio->error_reporting();

            }



            ///  PROMEDIO ESTUDIANTE POR AREA

            $asignaturas = Asignatura::find()->select(['id'])->where(['area' => $asignatura->area])->andWhere(['grado' => $grado]);

            /*$promedio_area = Calificacion::find()
                                ->select(['AVG(definitiva_final_periodo) as definitiva_final_periodo'])
                                ->where(['estudiante' => $estudiante])
                                ->andWhere(['grupo' => $grupo])
                                ->andWhere(['periodo' => $periodo])
                                ->andWhere(['asignatura' => $asignaturas])
                                ->groupBy(['estudiante']);

            echo "<br>".$promedio_area->createCommand()->getRawSql();
*/
            $promedio_area = Calificacion::find()
                                ->select(['AVG(definitiva_final_periodo) as definitiva_final_periodo'])
                                ->where(['estudiante' => $estudiante])
                                ->andWhere(['grupo' => $grupo])
                                ->andWhere(['periodo' => $periodo])
                                ->andWhere(['asignatura' => $asignaturas])
                                ->groupBy(['estudiante'])
                                ->one();
            try {
                    $promedio = Promedioarea::find()
                                    ->where(['estudiante' => $estudiante])
                                    ->andWhere(['grado' => $grado])
                                    ->andWhere(['grupo' => $grupo])
                                    ->andWhere(['area' => $asignatura->area])
                                    ->andWhere(['periodo' => $periodo])
                                    ->one();

                    if(!isset($promedio))
                    {
                        $promedio = new Promedioarea();
                        $promedio->promedio_estudiante = $promedio_area->definitiva_final_periodo;
                        $promedio->estudiante = $estudiante;
                        $promedio->grado = $grado;
                        $promedio->grupo = $grupo;
                        $promedio->area = $asignatura->area;
                        $promedio->periodo = $periodo;
                        
                        if($promedio->save() === false)
                        {
                            var_dump($promedio->getErrors());
                        }
                    }
                    else
                    {
                        $promedio->promedio_estudiante = $promedio_area->definitiva_final_periodo;
                        
                        if($promedio->update() === false)
                        {
                            var_dump($promedio->getErrors());
                        }
                    }

            } catch (\yii\db\IntegrityException $e) {
                return $promedio->error_reporting();

            }
        
                        
        } 

        //echo "<br><br>Fin";
    }   


    public function getPuestoxGrupo($tipo_calificacion, $grado, $grupo, $asignatura, $periodo)
    {
        $asignatura = Asignatura::find()->where(['id' => $asignatura])->one();
        $area = $asignatura->area;
        
        if($tipo_calificacion != 1)
        {
            try 
            {
                $grupo_act = Grupo::find()->where(['id' => $grupo])->one();

                /// PUESTO POR GRUPO ///

                //echo $suma_grado->createCommand()->getRawSql(); // Mostrar SQL   
            
                $promedios = Promedio::find()
                                ->andWhere(['grupo' => $grupo])
                                ->andWhere(['periodo' => $periodo])
                                ->orderBy(['promedio_estudiante' => SORT_DESC])
                                ->all();
                
                $puesto = 0;
                $promedio_anterior = 0;
                foreach ($promedios as $promedio) 
                {


                    if($promedio->promedio_estudiante != $promedio_anterior)
                    {
                        $puesto++;
                    }

                    $promedio->puesto_grupo = $puesto;
                    $promedio_anterior = $promedio->promedio_estudiante;
                    
                    if($promedio->update() === false)
                    {
                        echo "<br>251";
                        var_dump($promedio->getErrors());
                    }

                }

                /// PUESTO POR GRADO /// 

                $promedios = Promedio::find()
                                ->where(['grado' => $grado])
                                ->andWhere(['periodo' => $periodo])
                                ->orderBy(['promedio_estudiante' => SORT_DESC])
                                ->all();

                $puesto = 0;
                $promedio_anterior = 0;

                foreach ($promedios as $promedio) 
                {

                    if($promedio->promedio_estudiante != $promedio_anterior)
                    {
                        $puesto++;
                    }

                    $promedio->puesto_grado = $puesto;
                    $promedio_anterior = $promedio->promedio_estudiante;

                    if($promedio->update() === false)
                    {
                        echo "<br>280";
                        var_dump($promedio->getErrors());
                    }   
                    
                }

                

            } catch (\yii\db\IntegrityException $e) {
                return $promedio->error_reporting();

            }      
        }
    }

    public function getPromedios($tipo_calificacion, $grado, $grupo, $asignatura, $periodo)
    {
        $asignatura = Asignatura::find()->where(['id' => $asignatura])->one();
        $area = $asignatura->area;

        $grupo_act = Grupo::find()->where(['id' => $grupo])->one();
        

        if($tipo_calificacion != 1)
        {
            ////////       PROMEDIOS POR AREAS     ///////////

            ///////  PROMEDIO DEL AREA POR GRUPO  ////////////


            $promedio_grupo = Promedioarea::find()
                            ->select(['ROUND(AVG(promedio_estudiante),1) as promedio_estudiante'])
                            ->where(['grupo' => $grupo])
                            ->andWhere(['periodo' => $periodo])
                            ->andWhere(['area' => $area])
                            ->groupBy(['grupo'])
                            ->one();

            Promedioarea::updateAll(['promedio_area_grupo' => round($promedio_grupo->promedio_estudiante,2)], ['grupo' => $grupo, 'periodo' => $periodo, 'area' => $area]);

            
            /// PROMEDIO DEL GRUPO ///
            
            $suma_grupo = Promedioarea::find()
                            ->select(['ROUND(SUM(DISTINCT promedio_area_grupo),2) as promedio_area_grupo'])
                            ->where(['grupo' => $grupo])
                            ->andWhere(['periodo' => $periodo])
                            ->groupBy(['grupo'])
                            ->one();


            $total_grupo = (float)$suma_grupo->promedio_area_grupo / $grupo_act->getAreasbyGrupo($grupo);

            Promedioarea::updateAll(['promedio_grupo' => round($total_grupo,2)], ['grupo' => $grupo, 'periodo' => $periodo]);
            


            /// PROMEDIO DEL GRADO ///
            
            $suma_grado = Promedioarea::find()
                            ->select(['ROUND(SUM(DISTINCT promedio_grupo),2) as promedio_grupo'])
                            ->where(['grado' => $grado])
                            ->andWhere(['periodo' => $periodo])
                            ->groupBy(['grado'])
                            ->one();

            $num_grupos = Grupo::find()->where(['grado' => $grado])->count();

            $total_grado = (float)$suma_grado->promedio_grupo / $num_grupos;

            Promedioarea::updateAll(['promedio_grado' => round($total_grado,2)], ['grado' => $grado, 'periodo' => $periodo]);
            


            /// PROMEDIO POR AREA DEL COLEGIO /// 

            $asignatura_act = Asignatura::find()->where(['id' => $asignatura])->one();

            $suma_area = Promedioarea::find()
                            ->select(['ROUND(SUM(DISTINCT promedio_grado),2) as promedio_grado'])
                            ->where(['area' => $area])
                            ->andWhere(['periodo' => $periodo])
                            ->groupBy(['area'])
                            ->one();

            $total_grados = Asignatura::find()->where(['area' => $area])->count();                                   

            $total_area = (float)$suma_area->promedio_grado / $total_grados;


            Promedioarea::updateAll(['promedio_area' => round($total_area,2)], ['area' => $area, 'periodo' => $periodo]);
                
        }
    }

    public function getPromedioxAreaxEstudiante($tipo_calificacion, $estudiante, $grado, $grupo, $area, $periodo)
    {
         //echo "<br>getPromedioxEstudiante - Tipo: ".$tipo_calificacion.", Area: ".$calificacion_area.", ".$estudiante.", ".$grado.", ".$grupo.", ".$asignatura.", ".$periodo;
        
        
        //echo "Asinatura: ".$asignatura->asignatura." ESTUDIANTE: ".$estudiante;
        //exit;
        
        /////////////////////////////   TIPO CALIFICACION LETRAS  ///////////////////////////

        if($tipo_calificacion == '1')
        {
            $asignaturas = Asignatura::find()->select(['id'])->where(['grado' => $grado])->andWhere(['area' => $area]);
            $calificaciones = Calificacion::find()->select(['asignatura','definitiva_final_periodo'])->where(['estudiante' => $estudiante])->andWhere(['grupo' => $grupo])->andWhere(['IN','asignatura', $asignaturas])->andWhere(['periodo' => '3']);

            echo "<br>".$calificaciones->createCommand()->getRawSql();

            $asignaturas = Asignatura::find()->select(['id'])->where(['grado' => $grado])->andWhere(['area' => $area]);
            $calificaciones = Calificacion::find()->select(['asignatura','definitiva_final_periodo'])->where(['estudiante' => $estudiante])->andWhere(['grupo' => $grupo])->andWhere(['IN','asignatura', $asignaturas])->andWhere(['periodo' => '4'])->all();

            foreach ($calificaciones as $calificacion) 
            {
                echo "<br>Asignatura: ".$calificacion->asignaturas->asignatura." - ".$calificacion->definitiva_final_periodo;
            }

            //echo "<br>".$promedio_area->createCommand()->getRawSql();
            /*
            try {
                    $promedio = Promedioarea::find()
                                    ->where(['estudiante' => $estudiante])
                                    ->andWhere(['grado' => $grado])
                                    ->andWhere(['grupo' => $grupo])
                                    ->andWhere(['area' => $asignatura->area])
                                    ->andWhere(['periodo' => $periodo])
                                    ->one();

                    if(!isset($promedio))
                    {
                        $promedio = new Promedioarea();
                        $promedio->promedio_estudiante = $calificacion_area;
                        $promedio->estudiante = $estudiante;
                        $promedio->grado = $grado;
                        $promedio->grupo = $grupo;
                        $promedio->area = $asignatura->area;
                        $promedio->periodo = $periodo;
                        $promedio->save(false);
                    }
                    else
                    {
                        $promedio->promedio_estudiante = $calificacion_area;
                        $promedio->update(false);    
                    }

            } catch (\yii\db\IntegrityException $e) {
                return $promedio->error_reporting();

            }
        */
                        
        }

        //exit;

        /////////////////////////////   FIN CALIFICACIONES LETRAS  ///////////////////////////
    }
	
}
