<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Sede;

/**
 * backend\models\SedeSearch represents the model behind the search form about `backend\models\Sede`.
 */
 class SedeSearch extends Sede
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'bloquear_boletin', 'compromiso_acudiente', 'autorizar_calificaciones', 'autorizar_nivelaciones', 'bloquear_estudiante', 'creado_por', 'actualizado_por', 'eliminado_por'], 'integer'],
            [['nit', 'sede', 'direccion', 'fijo', 'resolucion', 'dane', 'rector_nombre', 'rector_cc', 'rector_expedida', 'rector_movil', 'rector_email', 'logo', 'vigencia', 'pdf_header', 'pdf_footer', 'pdf_marcadeagua', 'pdf_marcadeagua_contenido', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Sede::find()->where(['eliminado_por' => '0']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'bloquear_boletin' => $this->bloquear_boletin,
            'compromiso_acudiente' => $this->compromiso_acudiente,
            'autorizar_nivelaciones' => $this->autorizar_nivelaciones,
            'autorizar_calificaciones' => $this->autorizar_calificaciones,
            'bloquear_estudiante' => $this->bloquear_estudiante,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'eliminado_por' => $this->eliminado_por,
        ]);

        $query->andFilterWhere(['like', 'nit', $this->nit])
            ->andFilterWhere(['like', 'sede', $this->sede])
            ->andFilterWhere(['like', 'direccion', $this->direccion])
            ->andFilterWhere(['like', 'fijo', $this->fijo])
            ->andFilterWhere(['like', 'resolucion', $this->resolucion])
            ->andFilterWhere(['like', 'dane', $this->dane])
            ->andFilterWhere(['like', 'rector_nombre', $this->rector_nombre])
            ->andFilterWhere(['like', 'rector_cc', $this->rector_cc])
            ->andFilterWhere(['like', 'rector_expedida', $this->rector_expedida])
            ->andFilterWhere(['like', 'rector_movil', $this->rector_movil])
            ->andFilterWhere(['like', 'rector_email', $this->rector_email])
            ->andFilterWhere(['like', 'logo', $this->logo])
            ->andFilterWhere(['like', 'vigencia', $this->vigencia])
            ->andFilterWhere(['like', 'pdf_header', $this->pdf_header])
            ->andFilterWhere(['like', 'pdf_footer', $this->pdf_footer])
            ->andFilterWhere(['like', 'pdf_marcadeagua', $this->pdf_marcadeagua])
            ->andFilterWhere(['like', 'pdf_marcadeagua_contenido', $this->pdf_marcadeagua_contenido]);

        return $dataProvider;
    }
}
