<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Slide;

/**
 * backend\models\SlideSearch represents the model behind the search form about `backend\models\Slide`.
 */
 class SlideSearch extends Slide
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'tipo', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['titulo', 'enlace', 'target', 'descripcion', 'imagen', 'video', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Slide::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'tipo' => $this->tipo,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'eliminado_por' => $this->eliminado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'titulo', $this->titulo])
            ->andFilterWhere(['like', 'enlace', $this->enlace])
            ->andFilterWhere(['like', 'target', $this->target])
            ->andFilterWhere(['like', 'descripcion', $this->descripcion])
            ->andFilterWhere(['like', 'imagen', $this->imagen])
            ->andFilterWhere(['like', 'video', $this->video]);

        return $dataProvider;
    }
}
