<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Tarea;

/**
 * backend\models\TareaSearch represents the model behind the search form about `backend\models\Tarea`.
 */
 class TareaSearch extends Tarea
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'docente', 'asignatura', 'grupo', 'periodo', 'tipo', 'oportunidades','creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['tarea', 'descripcion', 'adjunto', 'disponible_desde', 'disponible_hasta', 'disponible_desde_2', 'disponible_hasta_2', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Tarea::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'docente' => $this->docente,
            'asignatura' => $this->asignatura,
            'grupo' => $this->grupo,
            'periodo' => $this->periodo,
            'tipo' => $this->tipo,
            'oportunidades' => $this->oportunidades,
            'disponible_desde' => $this->disponible_desde,
            'disponible_hasta' => $this->disponible_hasta,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'eliminado_por' => $this->eliminado_por,
            'estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'tarea', $this->tarea])
            ->andFilterWhere(['like', 'descripcion', $this->descripcion])
            ->andFilterWhere(['like', 'adjunto', $this->adjunto]);

        return $dataProvider;
    }
}
