<?php

namespace backend\models;

use Yii;
use yii\db\Expression;
use yii\web\Response;

use \backend\models\base\Tercero as Basetercero;
//use \backend\models\base\Academico;
//use \backend\models\base\Grupo;

/**
 * This is the model class for table "tercero".
 */
class tercero extends Basetercero
{

    public function getEstudiantes()
    {
        
        $query = "SELECT tercero.id, CONCAT(tercero.primer_apellido,' ',IFNULL(tercero.segundo_apellido,''),' ',tercero.primer_nombre,' ',IFNULL(tercero.segundo_nombre,'')) as nombre, IFNULL(grupo.grupo,'Sin Grupo') as grupo FROM tercero 
                    LEFT JOIN academico ON tercero.id = academico.estudiante 
                    LEFT JOIN grupo ON academico.grupo = grupo.id 
                    WHERE (tercero.tipo_tercero='1') 
                    AND (tercero.estado < '3')
                    AND (tercero.eliminado_por = '0')
                    AND (academico.eliminado_por = '0')
                    ORDER BY grupo.grado ASC, grupo.grupo ASC, nombre ASC;
                ";
        $avaliable = static::findBySql($query)->asArray()->all();

        $exists = [];

        if (Yii::$app->request->isAjax) 
        {
            Yii::$app->response->format = Response::FORMAT_JSON;
            
            return[
                'avaliable' => $avaliable,
                'assigned' => $exists
            ];
        }
        else
        {
            //Yii::$app->response->format = Response::FORMAT_JSON;
            return[
                'avaliable' => $avaliable,
                'assigned' => $exists
            ];
        }
    }

    public function getEstudiantesbloqueados($grupo = null)
    {
        
        if($grupo != null)
        {
            $query_activos = "SELECT tercero.id, CONCAT(tercero.primer_apellido,' ',IFNULL(segundo_apellido,''),' ',tercero.primer_nombre,' ',IFNULL(segundo_nombre,'')) as nombre, IFNULL(grupo.grupo,'Sin Grupo') as grupo 
                    FROM tercero 
                    LEFT JOIN academico ON tercero.id = academico.estudiante 
                    LEFT JOIN grupo ON academico.grupo = grupo.id 
                    WHERE (tercero.tipo_tercero='1') 
                    AND (tercero.estado < '3') 
                    AND (academico.grupo = $grupo)  
                    AND (tercero.bloqueo = '0')
                    AND (tercero.eliminado_por = '0')
                    AND (academico.eliminado_por = '0')
                    ORDER BY grupo.grado ASC, grupo.grupo ASC, tercero.primer_apellido ASC, tercero.segundo_apellido ASC, tercero.primer_nombre ASC, tercero.segundo_nombre ASC;
                ";

            $query_bloqueados = "SELECT tercero.id, CONCAT(tercero.primer_apellido,' ',IFNULL(segundo_apellido,''),' ',tercero.primer_nombre,' ',IFNULL(segundo_nombre,'')) as nombre, IFNULL(grupo.grupo,'Sin Grupo') as grupo 
                    FROM tercero 
                    LEFT JOIN academico ON tercero.id = academico.estudiante 
                    LEFT JOIN grupo ON academico.grupo = grupo.id 
                    WHERE (tercero.tipo_tercero='1') 
                    AND (tercero.estado < '3') 
                    AND (academico.grupo = $grupo)  
                    AND (tercero.bloqueo = '1')
                    AND (tercero.eliminado_por = '0')
                    AND (academico.eliminado_por = '0')
                    ORDER BY grupo.grado ASC, grupo.grupo ASC, tercero.primer_apellido ASC, tercero.segundo_apellido ASC, tercero.primer_nombre ASC, tercero.segundo_nombre ASC;
                ";
            
            $activos = static::findBySql($query_activos)->asArray()->all();
            $bloqueados = static::findBySql($query_bloqueados)->asArray()->all();
        }
        else
        {
            $query_activos = "SELECT tercero.id, CONCAT(tercero.primer_apellido,' ',IFNULL(segundo_apellido,''),' ',tercero.primer_nombre,' ',IFNULL(segundo_nombre,'')) as nombre, IFNULL(grupo.grupo,'Sin Grupo') as grupo 
                    FROM tercero 
                    LEFT JOIN academico ON tercero.id = academico.estudiante 
                    LEFT JOIN grupo ON academico.grupo = grupo.id 
                    WHERE (tercero.tipo_tercero='1') 
                    AND (tercero.estado < '3') 
                    AND (tercero.bloqueo = '0')
                    AND (tercero.eliminado_por = '0')
                    AND (academico.eliminado_por = '0')
                    ORDER BY grupo.grado ASC, grupo.grupo ASC, tercero.primer_apellido ASC, tercero.segundo_apellido ASC, tercero.primer_nombre ASC, tercero.segundo_nombre ASC;
                ";

            $query_bloqueados = "SELECT tercero.id, CONCAT(tercero.primer_apellido,' ',IFNULL(segundo_apellido,''),' ',tercero.primer_nombre,' ',IFNULL(segundo_nombre,'')) as nombre, IFNULL(grupo.grupo,'Sin Grupo') as grupo 
                    FROM tercero 
                    LEFT JOIN academico ON tercero.id = academico.estudiante 
                    LEFT JOIN grupo ON academico.grupo = grupo.id 
                    WHERE (tercero.tipo_tercero='1') 
                    AND (tercero.estado < '3') 
                    AND (tercero.bloqueo = '1')
                    AND (tercero.eliminado_por = '0')
                    AND (academico.eliminado_por = '0')
                    ORDER BY grupo.grado ASC, grupo.grupo ASC, tercero.primer_apellido ASC, tercero.segundo_apellido ASC, tercero.primer_nombre ASC, tercero.segundo_nombre ASC;
                ";
            
            $activos = static::findBySql($query_activos)->asArray()->all();
            $bloqueados = static::findBySql($query_bloqueados)->asArray()->all();
        }
        
        return[
            'avaliable' => $activos,
            'assigned' => $bloqueados
        ];
    }


    public function getEstudiantesxtesorero()
    {
        
        $query = "SELECT tercero.id, CONCAT(tercero.primer_apellido,' ',tercero.segundo_apellido,' ',tercero.primer_nombre,' ',tercero.segundo_nombre, ' - ', IFNULL(grupo.grupo, 'Sin Grupo'), '') as nombre FROM tercero 
                    LEFT JOIN academico ON tercero.id = academico.estudiante 
                    LEFT JOIN grupo ON academico.grupo = grupo.id 
                    LEFT JOIN grado ON grado.id = grupo.grado 
                    WHERE (tercero.tipo_tercero='1') 
                    AND (tercero.estado < '3')
                    ORDER BY grupo.grupo + 0 ASC, nombre ASC;
                ";
        $terceros = static::findBySql($query)->asArray()->all();

        return $terceros;
    }

    public function getEstudiantesxgrado($id)
    {
        
        $query = "SELECT tercero.id, CONCAT(tercero.primer_apellido,' ',tercero.segundo_apellido,' ',tercero.primer_nombre,' ',tercero.segundo_nombre, ' - ', IFNULL(grupo.grupo, 'Sin Grupo'), '') as nombre FROM tercero 
                    LEFT JOIN academico ON tercero.id = academico.estudiante 
                    LEFT JOIN grupo ON academico.grupo = grupo.id 
                    LEFT JOIN grado ON grado.id = grupo.grado 
                    WHERE (tercero.tipo_tercero='1') 
                    AND (tercero.estado < '3')
                    AND (grado.id = $id)
                    ORDER BY grupo.grupo + 0 ASC, nombre ASC;
                ";
        $terceros = static::findBySql($query)->asArray()->all();

        return $terceros;
    }

    public function getEstudiantesxgrupo($id)
    {
        
        $query = "SELECT tercero.id, CONCAT(tercero.primer_apellido,' ',tercero.segundo_apellido,' ',tercero.primer_nombre,' ',tercero.segundo_nombre) as nombre, IFNULL(grupo.grupo,'Sin Grupo') as grupo FROM tercero 
                    LEFT JOIN academico ON tercero.id = academico.estudiante 
                    LEFT JOIN grupo ON academico.grupo = grupo.id 
                    WHERE (tercero.tipo_tercero='1') 
                    AND (tercero.estado < '3')
                    AND (grupo.id = $id)
                    ORDER BY grupo.grupo + 0 ASC, nombre ASC;
                ";
        $terceros = static::findBySql($query)->asArray()->all();

        return $terceros;
    }

    public function getDocentes()
    {
        
        $query = "SELECT tercero.id, CONCAT(tercero.primer_apellido,' ',tercero.segundo_apellido,' ',tercero.primer_nombre,' ',tercero.segundo_nombre) as nombre FROM tercero 
                    WHERE (tercero.tipo_tercero='2') 
                    AND (tercero.estado = '5')
                    ORDER BY nombre ASC;
                ";
        $terceros = static::findBySql($query)->asArray()->all();

        return $terceros;
    }

}
