<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Tercero;

/**
 * backend\models\TerceroSearch represents the model behind the search form about `backend\models\tercero`.
 */
 class TerceroSearch extends Tercero
{
    /**
     * @inheritdoc
     */
    public $grupo, $eliminado;

    public function rules()
    {
        return [
            [['id', 'tipo', 'tipo_tercero', 'municipio_nacimiento', 'rh', 'religion', 'etnia', 'eps', 'barrio', 'estrato', 'situacion', 'municipio_desplazado', 'capacidad', 'discapacidad_certificada', 'subsidio', 'recurso', 'bienestar', 'heroe', 'fuerza_publica', 'sector', 'resguardo', 'creado_por', 'actualizado_por', 'activo', 'estado','eliminado','eliminado_por'], 'integer'],
            [['identificacion', 'primer_nombre', 'segundo_nombre', 'primer_apellido', 'segundo_apellido', 'genero', 'fecha_nacimiento', 'departamento_nacimiento', 'direccion', 'fijo', 'movil', 'email', 'foto', 'codigo_desplazado', 'departamento_desplazado', 'codigo_sisben', 'codigo_familia_accion', 'medicamentos', 'alergias', 'discapacidad', 'departamento_resguardo', 'creado_el', 'actualizado_el','eliminado_el', 'grupo'], 'safe'],
        ]; 
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = tercero::find()
                    ->select(['tercero.*', new \yii\db\Expression("CASE WHEN academico.grupo = NULL THEN '0' END")])
                    ->joinWith(['academicos'])
                    ->where(['tercero.eliminado_por' => '0']);
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $dataProvider->setSort([
            'attributes' => [
                'id',
                'identificacion',
                'primer_nombre',
                'segundo_nombre',
                'primer_apellido',
                'segundo_apellido',
                'genero',
                'departamento_nacimiento',
                'direccion',
                'email',
                'tipo',
                'tipo_tercero',
                'genero',
                'fecha_nacimiento',
                'municipio_nacimiento',
                'rh',
                'religion',
                'etnia',
                'eps',
                'barrio',
                'fijo',
                'movil',
                'estado' => [
                    'asc' => ['tercero.estado' => SORT_ASC],
                    'desc' => ['tercero.estado' => SORT_DESC],
                ],
                'grupo' => [
                    'asc' => ['academico.grupo' => SORT_ASC],
                    'desc' => ['academico.grupo' => SORT_DESC],
                ],
                'eliminado',
            ]
        ]);


        if (!($this->load($params) && $this->validate())) {
            /**
             * The following line will allow eager loading with country data 
             * to enable sorting by country on initial loading of the grid.
             */ 
            //$query->joinWith(['academicos']);
            return $dataProvider;
        }
        

        $query->andFilterWhere([
            'id' => $this->id,
            'tipo' => $this->tipo,
            'tipo_tercero' => $this->tipo_tercero,
            'fecha_nacimiento' => $this->fecha_nacimiento,
            'municipio_nacimiento' => $this->municipio_nacimiento,
            'rh' => $this->rh,
            'religion' => $this->religion,
            'etnia' => $this->etnia,
            'eps' => $this->eps,
            'barrio' => $this->barrio,
            'estrato' => $this->estrato,
            'situacion' => $this->situacion,
            'municipio_desplazado' => $this->municipio_desplazado,
            'capacidad' => $this->capacidad,
            'discapacidad_certificada' => $this->discapacidad_certificada,
            'subsidio' => $this->subsidio,
            'recurso' => $this->recurso,
            'bienestar' => $this->bienestar,
            'heroe' => $this->heroe,
            'fuerza_publica' => $this->fuerza_publica,
            'sector' => $this->sector,
            'resguardo' => $this->resguardo,
            'creado_el' => $this->creado_el,
            'creado_por' => $this->creado_por,
            'actualizado_el' => $this->actualizado_el,
            'actualizado_por' => $this->actualizado_por,
            'eliminado_el' => $this->eliminado_el,
            'eliminado_por' => $this->eliminado_por,
            'activo' => $this->activo,
            'tercero.estado' => $this->estado,
        ]);

        $query->andFilterWhere(['like', 'identificacion', $this->identificacion])
            ->andFilterWhere(['like', 'primer_nombre', $this->primer_nombre])
            ->andFilterWhere(['like', 'segundo_nombre', $this->segundo_nombre])
            ->andFilterWhere(['like', 'primer_apellido', $this->primer_apellido])
            ->andFilterWhere(['like', 'segundo_apellido', $this->segundo_apellido])
            ->andFilterWhere(['like', 'genero', $this->genero])
            ->andFilterWhere(['like', 'departamento_nacimiento', $this->departamento_nacimiento])
            ->andFilterWhere(['like', 'direccion', $this->direccion])
            ->andFilterWhere(['like', 'fijo', $this->fijo])
            ->andFilterWhere(['like', 'movil', $this->movil])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'foto', $this->foto])
            ->andFilterWhere(['like', 'codigo_desplazado', $this->codigo_desplazado])
            ->andFilterWhere(['like', 'departamento_desplazado', $this->departamento_desplazado])
            ->andFilterWhere(['like', 'codigo_sisben', $this->codigo_sisben])
            ->andFilterWhere(['like', 'codigo_familia_accion', $this->codigo_familia_accion])
            ->andFilterWhere(['like', 'medicamentos', $this->medicamentos])
            ->andFilterWhere(['like', 'alergias', $this->alergias])
            ->andFilterWhere(['like', 'discapacidad', $this->discapacidad])
            ->andFilterWhere(['like', 'departamento_resguardo', $this->departamento_resguardo]);


        if ($this->grupo != '0'){
            $query->andFilterWhere(['grupo' => $this->grupo]);
        }    
        else{
            $query->andFilterWhere([ 'IS', 'grupo', new \yii\db\Expression("NULL")]);
        } 
/*
        if($this->eliminado == '1') {
            $query->where([ 'IS NOT', 'tercero.eliminado_el', new \yii\db\Expression('NULL')]);
            //$query->andFilterWhere([ 'IS NOT', 'tercero.eliminado_el', new \yii\db\Expression('NULL')]);
        }
        else
        {
            $query->where([ 'IS', 'tercero.eliminado_el', new \yii\db\Expression('NULL')]);
        }
*/
        return $dataProvider;
    }
}
